/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.version;

import java.net.URL;
import java.util.Date;

public class Version {
    private static final int MAJOR_SEPARATOR = 1000000;

    public static int version() {
        return 1201716;
    }

    public static int versionPatched() {
        if (Version.beta() != 0) {
            return Version.version() + 1;
        }
        return Version.version();
    }

    public static String versionString() {
        if (Version.beta() != 0) {
            return Version.dotted(Version.version() + 1) + "beta" + Version.beta();
        }
        return Version.dotted(Version.version());
    }

    private static String dotted(int n) {
        String string = "" + n % 1000000;
        String string2 = "" + n / 1000000;
        return string2 + "." + string.substring(0, 4) + "." + string.substring(4);
    }

    public static String versionString(int n) {
        StringBuilder stringBuilder = new StringBuilder(Version.versionString());
        while (stringBuilder.length() < n) {
            stringBuilder.append(' ');
        }
        return stringBuilder.toString();
    }

    public static int beta() {
        return 0;
    }

    public static String etag() {
        return Integer.toString(Version.version() % 1000000 - 201670, 36) + Integer.toString(Version.beta(), 36);
    }

    public static String turningId() {
        return Version.etag();
    }

    public static long compileTime() {
        return 1504436017935L;
    }

    public static String compileTimeString() {
        if (Version.beta() != 0) {
            return "Unknown compile time";
        }
        return new Date(Version.compileTime()).toString();
    }

    public static String getJarPath() {
        try {
            ClassLoader classLoader = Version.class.getClassLoader();
            if (classLoader == null) {
                return "No ClassLoader?";
            }
            URL uRL = classLoader.getResource("znaishaded/net/sourceforge/plantuml/version/Version.class");
            if (uRL == null) {
                return "No URL?";
            }
            String string = uRL.toString();
            string = string.replaceAll("znaishaded/net/sourceforge/plantuml/version/Version\\.class", "");
            return string;
        }
        catch (Throwable throwable) {
            throwable.printStackTrace();
            return throwable.toString();
        }
    }
}

