/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.antlr.v4.runtime.misc;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.List;
import javax.print.PrintException;
import znaishaded.org.antlr.v4.runtime.ANTLRInputStream;
import znaishaded.org.antlr.v4.runtime.CharStream;
import znaishaded.org.antlr.v4.runtime.CommonTokenStream;
import znaishaded.org.antlr.v4.runtime.DiagnosticErrorListener;
import znaishaded.org.antlr.v4.runtime.Lexer;
import znaishaded.org.antlr.v4.runtime.Parser;
import znaishaded.org.antlr.v4.runtime.ParserRuleContext;
import znaishaded.org.antlr.v4.runtime.Token;
import znaishaded.org.antlr.v4.runtime.TokenStream;
import znaishaded.org.antlr.v4.runtime.atn.ParserATNSimulator;
import znaishaded.org.antlr.v4.runtime.atn.PredictionMode;

public class TestRig {
    public static final String LEXER_START_RULE_NAME = "tokens";
    protected String grammarName;
    protected String startRuleName;
    protected final List<String> inputFiles = new ArrayList<String>();
    protected boolean printTree = false;
    protected boolean gui = false;
    protected String psFile = null;
    protected boolean showTokens = false;
    protected boolean trace = false;
    protected boolean diagnostics = false;
    protected String encoding = null;
    protected boolean SLL = false;

    public TestRig(String[] args) throws Exception {
        if (args.length < 2) {
            System.err.println("java org.antlr.v4.runtime.misc.TestRig GrammarName startRuleName\n  [-tokens] [-tree] [-gui] [-ps file.ps] [-encoding encodingname]\n  [-trace] [-diagnostics] [-SLL]\n  [input-filename(s)]");
            System.err.println("Use startRuleName='tokens' if GrammarName is a lexer grammar.");
            System.err.println("Omitting input-filename makes rig read from stdin.");
            return;
        }
        int i = 0;
        this.grammarName = args[i];
        this.startRuleName = args[++i];
        ++i;
        while (i < args.length) {
            String arg = args[i];
            ++i;
            if (arg.charAt(0) != '-') {
                this.inputFiles.add(arg);
                continue;
            }
            if (arg.equals("-tree")) {
                this.printTree = true;
            }
            if (arg.equals("-gui")) {
                this.gui = true;
            }
            if (arg.equals("-tokens")) {
                this.showTokens = true;
                continue;
            }
            if (arg.equals("-trace")) {
                this.trace = true;
                continue;
            }
            if (arg.equals("-SLL")) {
                this.SLL = true;
                continue;
            }
            if (arg.equals("-diagnostics")) {
                this.diagnostics = true;
                continue;
            }
            if (arg.equals("-encoding")) {
                if (i >= args.length) {
                    System.err.println("missing encoding on -encoding");
                    return;
                }
                this.encoding = args[i];
                ++i;
                continue;
            }
            if (!arg.equals("-ps")) continue;
            if (i >= args.length) {
                System.err.println("missing filename on -ps");
                return;
            }
            this.psFile = args[i];
            ++i;
        }
    }

    public static void main(String[] args) throws Exception {
        TestRig testRig = new TestRig(args);
        if (args.length >= 2) {
            testRig.process();
        }
    }

    public void process() throws Exception {
        String lexerName = this.grammarName + "Lexer";
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        Class<Lexer> lexerClass = null;
        try {
            lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
        }
        catch (ClassNotFoundException cnfe) {
            lexerName = this.grammarName;
            try {
                lexerClass = cl.loadClass(lexerName).asSubclass(Lexer.class);
            }
            catch (ClassNotFoundException cnfe2) {
                System.err.println("Can't load " + lexerName + " as lexer or parser");
                return;
            }
        }
        Constructor<Lexer> lexerCtor = lexerClass.getConstructor(CharStream.class);
        Lexer lexer = lexerCtor.newInstance(new Object[]{null});
        Class<Parser> parserClass = null;
        Parser parser = null;
        if (!this.startRuleName.equals(LEXER_START_RULE_NAME)) {
            String parserName = this.grammarName + "Parser";
            parserClass = cl.loadClass(parserName).asSubclass(Parser.class);
            if (parserClass == null) {
                System.err.println("Can't load " + parserName);
            }
            Constructor<Parser> parserCtor = parserClass.getConstructor(TokenStream.class);
            parser = parserCtor.newInstance(new Object[]{null});
        }
        if (this.inputFiles.size() == 0) {
            InputStream is = System.in;
            InputStreamReader r = this.encoding != null ? new InputStreamReader(is, this.encoding) : new InputStreamReader(is);
            this.process(lexer, parserClass, parser, is, r);
            return;
        }
        for (String inputFile : this.inputFiles) {
            InputStream is = System.in;
            if (inputFile != null) {
                is = new FileInputStream(inputFile);
            }
            InputStreamReader r = this.encoding != null ? new InputStreamReader(is, this.encoding) : new InputStreamReader(is);
            if (this.inputFiles.size() > 1) {
                System.err.println(inputFile);
            }
            this.process(lexer, parserClass, parser, is, r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Lexer lexer, Class<? extends Parser> parserClass, Parser parser, InputStream is, Reader r) throws IOException, IllegalAccessException, InvocationTargetException, PrintException {
        try {
            ANTLRInputStream input = new ANTLRInputStream(r);
            lexer.setInputStream(input);
            CommonTokenStream tokens = new CommonTokenStream(lexer);
            tokens.fill();
            if (this.showTokens) {
                for (Token tok : tokens.getTokens()) {
                    System.out.println(tok);
                }
            }
            if (this.startRuleName.equals(LEXER_START_RULE_NAME)) {
                return;
            }
            if (this.diagnostics) {
                parser.addErrorListener(new DiagnosticErrorListener());
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.LL_EXACT_AMBIG_DETECTION);
            }
            if (this.printTree || this.gui || this.psFile != null) {
                parser.setBuildParseTree(true);
            }
            if (this.SLL) {
                ((ParserATNSimulator)parser.getInterpreter()).setPredictionMode(PredictionMode.SLL);
            }
            parser.setTokenStream(tokens);
            parser.setTrace(this.trace);
            try {
                Method startRule = parserClass.getMethod(this.startRuleName, new Class[0]);
                ParserRuleContext tree = (ParserRuleContext)startRule.invoke((Object)parser, (Object[])null);
                if (this.printTree) {
                    System.out.println(tree.toStringTree(parser));
                }
                if (this.gui) {
                    tree.inspect(parser);
                }
                if (this.psFile != null) {
                    tree.save(parser, this.psFile);
                }
            }
            catch (NoSuchMethodException nsme) {
                System.err.println("No method for rule " + this.startRuleName + " or it has arguments");
            }
        }
        finally {
            if (r != null) {
                r.close();
            }
            if (is != null) {
                is.close();
            }
        }
    }
}

