/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.org.commonmark.internal.inline;

import znaishaded.org.commonmark.node.Emphasis;
import znaishaded.org.commonmark.node.Node;
import znaishaded.org.commonmark.node.StrongEmphasis;
import znaishaded.org.commonmark.node.Text;
import znaishaded.org.commonmark.parser.delimiter.DelimiterProcessor;
import znaishaded.org.commonmark.parser.delimiter.DelimiterRun;

public abstract class EmphasisDelimiterProcessor
implements DelimiterProcessor {
    private final char delimiterChar;

    protected EmphasisDelimiterProcessor(char delimiterChar) {
        this.delimiterChar = delimiterChar;
    }

    @Override
    public char getOpeningCharacter() {
        return this.delimiterChar;
    }

    @Override
    public char getClosingCharacter() {
        return this.delimiterChar;
    }

    @Override
    public int getMinLength() {
        return 1;
    }

    @Override
    public int getDelimiterUse(DelimiterRun opener, DelimiterRun closer) {
        if ((opener.canClose() || closer.canOpen()) && (opener.length() + closer.length()) % 3 == 0) {
            return 0;
        }
        if (opener.length() < 3 || closer.length() < 3) {
            return closer.length() <= opener.length() ? closer.length() : opener.length();
        }
        return closer.length() % 2 == 0 ? 2 : 1;
    }

    @Override
    public void process(Text opener, Text closer, int delimiterUse) {
        String singleDelimiter = String.valueOf(this.getOpeningCharacter());
        Node emphasis = delimiterUse == 1 ? new Emphasis(singleDelimiter) : new StrongEmphasis(singleDelimiter + singleDelimiter);
        Node tmp = opener.getNext();
        while (tmp != null && tmp != closer) {
            Node next = tmp.getNext();
            emphasis.appendChild(tmp);
            tmp = next;
        }
        opener.insertAfter(emphasis);
    }
}

