/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.parser.sphinx;

import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import org.testingisdocumenting.znai.core.ComponentsRegistry;
import org.testingisdocumenting.znai.extensions.PluginParams;
import org.testingisdocumenting.znai.extensions.PluginResult;
import org.testingisdocumenting.znai.parser.ParserHandler;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonClass;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonClassIncludePlugin;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonClassXmlParser;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunction;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionIncludePlugin;
import org.testingisdocumenting.znai.parser.sphinx.python.PythonFunctionXmlParser;
import org.testingisdocumenting.znai.parser.sphinx.xml.DocUtilsXmlFixer;
import org.testingisdocumenting.znai.reference.DocReferences;
import org.testingisdocumenting.znai.utils.XmlUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import znaishaded.org.apache.commons.lang3.StringUtils;
import znaishaded.org.apache.commons.lang3.text.WordUtils;

class DocTreeDomXmlParser {
    private ComponentsRegistry componentsRegistry;
    private Path filePath;
    private ParserHandler parserHandler;

    DocTreeDomXmlParser(ComponentsRegistry componentsRegistry, Path filePath, ParserHandler parserHandler) {
        this.componentsRegistry = componentsRegistry;
        this.filePath = filePath;
        this.parserHandler = parserHandler;
    }

    public void parse(String xml) {
        xml = DocUtilsXmlFixer.fixDocUtilsIncorrectXml(xml);
        Document document = XmlUtils.parseXml(xml);
        NodeList nodes = document.getChildNodes();
        this.parseNodeList(nodes);
    }

    private boolean parseNodeList(NodeList nodes) {
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node item2 = nodes.item(i);
            this.parseNode(item2);
        }
        return true;
    }

    private boolean parseNode(Node node) {
        switch (node.getNodeName()) {
            case "document": {
                return this.parseChildren(node);
            }
            case "section": {
                return this.parseSection(node);
            }
            case "paragraph": {
                return this.parseParagraph(node);
            }
            case "emphasis": {
                return this.parseEmphasis(node);
            }
            case "strong": {
                return this.parseStrong(node);
            }
            case "literal": {
                return this.parseLiteral(node);
            }
            case "literal_strong": {
                return this.parseLiteralStrong(node);
            }
            case "literal_emphasis": {
                return this.parseLiteralEmphasis(node);
            }
            case "literal_block": {
                return this.parseSnippet(node);
            }
            case "bullet_list": {
                return this.parseBulletList(node);
            }
            case "enumerated_list": {
                return this.parseOrderedList(node);
            }
            case "list_item": {
                return this.parseListItem(node);
            }
            case "reference": {
                return this.parseReference(node);
            }
            case "#text": {
                return this.parseText(node);
            }
            case "title": {
                return false;
            }
            case "desc_signature": {
                return this.parseDescSignature(node);
            }
            case "field_list": 
            case "field": 
            case "field_name": 
            case "field_body": 
            case "desc": 
            case "desc_parameterlist": 
            case "desc_name": 
            case "desc_addname": 
            case "desc_annotation": 
            case "desc_content": 
            case "desc_parameter": 
            case "desc_optional": {
                return this.parseDocUtils(node);
            }
        }
        return false;
    }

    private boolean parseDescSignature(Node node) {
        if (XmlUtils.hasAttributeText(node, "ids")) {
            String ids = XmlUtils.getAttributeText(node, "ids");
            this.parserHandler.onGlobalAnchor(ids);
        }
        return this.parseDocUtils(node);
    }

    private boolean parseDocUtils(Node node) {
        String nodeName = DocTreeDomXmlParser.convertNodeName(node.getNodeName());
        this.parserHandler.onCustomNodeStart(nodeName, DocTreeDomXmlParser.camelCaseKeys(XmlUtils.getAttributes(node)));
        this.parseChildren(node);
        this.parserHandler.onCustomNodeEnd(nodeName);
        return true;
    }

    private boolean parseReference(Node node) {
        this.parserHandler.onLinkStart(XmlUtils.getAttributeText(node, "refuri"));
        this.parseChildren(node);
        this.parserHandler.onLinkEnd();
        return true;
    }

    private boolean parseSection(Node node) {
        this.parserHandler.onSectionStart(this.extractTitle(node));
        this.parseChildren(node);
        this.parserHandler.onSectionEnd();
        return true;
    }

    private boolean parseParagraph(Node node) {
        this.parserHandler.onParagraphStart();
        this.parseChildren(node);
        this.parserHandler.onParagraphEnd();
        return true;
    }

    private boolean parseEmphasis(Node node) {
        this.parserHandler.onEmphasisStart();
        this.parseChildren(node);
        this.parserHandler.onEmphasisEnd();
        return true;
    }

    private boolean parseStrong(Node node) {
        this.parserHandler.onStrongEmphasisStart();
        this.parseChildren(node);
        this.parserHandler.onStrongEmphasisEnd();
        return true;
    }

    private boolean parseLiteral(Node node) {
        this.parserHandler.onInlinedCode(node.getTextContent(), DocReferences.EMPTY);
        return true;
    }

    private boolean parseLiteralStrong(Node node) {
        this.parserHandler.onStrongEmphasisStart();
        this.parserHandler.onInlinedCode(node.getTextContent(), DocReferences.EMPTY);
        this.parserHandler.onStrongEmphasisEnd();
        return true;
    }

    private boolean parseLiteralEmphasis(Node node) {
        this.parserHandler.onEmphasisStart();
        this.parserHandler.onInlinedCode(node.getTextContent(), DocReferences.EMPTY);
        this.parserHandler.onEmphasisEnd();
        return true;
    }

    private boolean parseSnippet(Node node) {
        this.parserHandler.onSnippet(PluginParams.EMPTY, XmlUtils.getAttributeText(node, "language"), "", node.getTextContent());
        return true;
    }

    private boolean parseBulletList(Node node) {
        this.parserHandler.onBulletListStart(XmlUtils.getAttributeText(node, "bullet", "*").charAt(0), false);
        this.parseChildren(node);
        this.parserHandler.onBulletListEnd();
        return true;
    }

    private boolean parseOrderedList(Node node) {
        this.parserHandler.onOrderedListStart(XmlUtils.getAttributeText(node, "suffix").charAt(0), 1);
        this.parseChildren(node);
        this.parserHandler.onOrderedListEnd();
        return true;
    }

    private boolean parseListItem(Node node) {
        this.parserHandler.onListItemStart();
        this.parseChildren(node);
        this.parserHandler.onListItemEnd();
        return true;
    }

    private boolean parseDesc(Node node) {
        String descType;
        switch (descType = XmlUtils.getAttributeText(node, "desctype")) {
            case "class": {
                return this.parseClass(node);
            }
            case "function": {
                return this.parseFunction(node);
            }
        }
        return false;
    }

    private boolean parseFunction(Node node) {
        PythonFunction pythonFunction = new PythonFunctionXmlParser().parse(node);
        this.parserHandler.onGlobalAnchor(pythonFunction.getRefId());
        PythonFunctionIncludePlugin includePlugin = new PythonFunctionIncludePlugin();
        PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.filePath, new PluginParams(includePlugin.id(), pythonFunction.toMap()));
        this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
        return false;
    }

    private boolean parseClass(Node node) {
        PythonClassXmlParser xmlParser = new PythonClassXmlParser();
        PythonClass pythonClass = xmlParser.parseClass(node);
        this.parserHandler.onGlobalAnchor(pythonClass.getRefId());
        pythonClass.getMethods().forEach(m3 -> this.parserHandler.onGlobalAnchor(m3.getRefId()));
        PythonClassIncludePlugin includePlugin = new PythonClassIncludePlugin();
        PluginResult pluginResult = includePlugin.process(this.componentsRegistry, this.parserHandler, this.filePath, new PluginParams(includePlugin.id(), pythonClass.toMap()));
        this.parserHandler.onIncludePlugin(includePlugin, pluginResult);
        return true;
    }

    private boolean parseText(Node node) {
        String textContent = node.getTextContent();
        if (textContent.startsWith("\n")) {
            return false;
        }
        this.parserHandler.onSimpleText(textContent);
        return true;
    }

    private boolean parseChildren(Node node) {
        return this.parseNodeList(node.getChildNodes());
    }

    private String extractTitle(Node node) {
        Element element = (Element)node;
        return element.getElementsByTagName("title").item(0).getTextContent();
    }

    private static Map<String, String> camelCaseKeys(Map<String, String> attributes) {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        attributes.forEach((k, v) -> result.put(DocTreeDomXmlParser.convertAttributeName(k), (String)v));
        return result;
    }

    private static String convertNodeName(String name) {
        return "DocUtils" + WordUtils.capitalizeFully(name, '_').replaceAll("_", "");
    }

    private static String convertAttributeName(String name) {
        name = name.replace(":", "_");
        return StringUtils.uncapitalize(WordUtils.capitalizeFully(name, '_').replaceAll("_", ""));
    }
}

