/*
 * Decompiled with CFR 0.152.
 */
package smetana.core;

import h.Ppoly_t;
import h.htmllabel_t;
import h.pointf;
import java.lang.reflect.Field;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import smetana.core.JUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CType {
    private final String type;

    CType(String string) {
        this.type = string;
        if (string.equals("void")) {
            throw new IllegalArgumentException();
        }
    }

    public boolean isInteger() {
        return this.type.equals("int") || this.type.equals("packval_t");
    }

    public boolean isChar() {
        return this.type.equals("char");
    }

    public boolean isBoolean() {
        return this.type.equals("boolean");
    }

    public boolean isDoubleOrFloat() {
        return this.type.equals("double") || this.type.equals("float");
    }

    public boolean isShort() {
        return this.type.equals("short");
    }

    public boolean isLong() {
        return this.type.equals("long");
    }

    public boolean isEnum() {
        JUtils.LOG("IS ENUM " + this);
        if (this.functionPointer() || this.isVoidStar() || this.isInteger() || this.isChar() || this.isCString() || this.isBoolean() || this.isDoubleOrFloat() || this.isShort() || this.isLong()) {
            return false;
        }
        if (this.getType().contains("*")) {
            return false;
        }
        if (this.getType().contains("[")) {
            return false;
        }
        Class clazz = this.getTypeClass();
        if (clazz == null) {
            return false;
        }
        List<String> list = CType.getDefinition(clazz);
        JUtils.LOG("def3=" + list);
        return list.get(0).equals("typedef enum");
    }

    public String toString() {
        return "CTYPE:" + this.type;
    }

    public Class getTypeClass() {
        if (this.isPrimitive()) {
            return null;
        }
        if (this.type.equals("Ppolyline_t")) {
            return Ppoly_t.class;
        }
        return CType.getClassFrom(this.type);
    }

    public static Class getClassFrom(String string) {
        if (string == null) {
            throw new IllegalArgumentException();
        }
        if (string.equals("h.pointf_s")) {
            return pointf.class;
        }
        if (string.equals("pointf_s")) {
            return pointf.class;
        }
        if (string.endsWith("htmllabel_t")) {
            return htmllabel_t.class;
        }
        try {
            Class<?> clazz = Class.forName("h." + string);
            List<String> list = CType.getDefinition(clazz);
            if (list.size() != 1) {
                return clazz;
            }
            String string2 = list.get(0);
            Pattern pattern = Pattern.compile("^typedef\\s+struct\\s+(\\w+)\\s+(\\w+)$");
            Matcher matcher = pattern.matcher(string2);
            if (!matcher.find()) {
                throw new IllegalStateException(string2);
            }
            if (!matcher.group(2).equals(string)) {
                throw new IllegalStateException(string2);
            }
            return CType.getClassFrom(matcher.group(1));
        }
        catch (Exception exception) {
            exception.printStackTrace();
            return null;
        }
    }

    private List<String> getDefinition() {
        return CType.getDefinition(this.getTypeClass());
    }

    static List<String> getDefinition(Class clazz) {
        try {
            if (clazz == null) {
                return null;
            }
            Field field = clazz.getField("DEFINITION");
            return (List)field.get(null);
        }
        catch (NoSuchFieldException noSuchFieldException) {
            System.err.println("inter=" + clazz);
            noSuchFieldException.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (SecurityException securityException) {
            securityException.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            illegalArgumentException.printStackTrace();
            throw new UnsupportedOperationException();
        }
        catch (IllegalAccessException illegalAccessException) {
            illegalAccessException.printStackTrace();
            throw new UnsupportedOperationException();
        }
    }

    public boolean functionPointer() {
        if (this.isPrimitive()) {
            return false;
        }
        boolean bl = this.type.matches("^.*(\\(\\*(\\w+)\\)).*$");
        if (bl) {
            return true;
        }
        try {
            List<String> list = CType.getDefinition(Class.forName("h." + this.type));
            JUtils.LOG("def=" + list);
            if (list.size() != 1) {
                return false;
            }
            assert (list.size() == 1);
            bl = list.get(0).matches("^.*(\\(\\*(\\w+)\\)).*$");
            JUtils.LOG("checking " + this.type + " " + bl);
            return bl;
        }
        catch (ClassNotFoundException classNotFoundException) {
            JUtils.LOG("typeXXX=" + this.type);
            return false;
        }
    }

    public static boolean isPrimitive(String string) {
        return string.equals("char") || string.equals("long") || string.equals("int") || string.equals("packval_t") || string.equals("boolean") || string.equals("double") || string.equals("float") || string.equals("short");
    }

    public boolean isPrimitive() {
        return CType.isPrimitive(this.type);
    }

    public Class getClassFrom() {
        return CType.getClassFrom(this.type);
    }

    public int getArrayLength() {
        Pattern pattern = Pattern.compile(".*\\[(\\d+)\\]$");
        Matcher matcher = pattern.matcher(this.type);
        if (!matcher.find()) {
            return 0;
        }
        return Integer.parseInt(matcher.group(1));
    }

    public boolean isIntStar() {
        return "int*".equals(this.type);
    }

    public boolean isDoubleStar() {
        return "double*".equals(this.type);
    }

    public boolean isVoidStar() {
        return "void*".equals(this.type);
    }

    public String getType() {
        return this.type;
    }

    public boolean isCString() {
        return this.type.equals("CString");
    }

    public boolean isArrayOfCString() {
        return this.type.equals("CString[]");
    }

    public boolean containsStar() {
        return this.type.contains("*");
    }
}

