/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import javax.net.ssl.SSLHandshakeException;
import znaishaded.io.netty.bootstrap.Bootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.ChannelHandler;
import znaishaded.io.netty.channel.ChannelPipeline;
import znaishaded.io.netty.handler.codec.http.HttpClientCodec;
import znaishaded.io.netty.handler.codec.http.HttpContentDecompressor;
import znaishaded.io.netty.handler.logging.LoggingHandler;
import znaishaded.io.netty.handler.ssl.SslHandler;
import znaishaded.io.netty.handler.timeout.IdleStateHandler;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpClientOptions;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.http.impl.Http1xClientConnection;
import znaishaded.io.vertx.core.http.impl.Http1xClientHandler;
import znaishaded.io.vertx.core.http.impl.Http2ClientConnection;
import znaishaded.io.vertx.core.http.impl.Http2UpgradedClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientConnection;
import znaishaded.io.vertx.core.http.impl.HttpClientImpl;
import znaishaded.io.vertx.core.http.impl.VertxHttp2ConnectionHandler;
import znaishaded.io.vertx.core.http.impl.pool.ConnectResult;
import znaishaded.io.vertx.core.http.impl.pool.ConnectionListener;
import znaishaded.io.vertx.core.http.impl.pool.ConnectionProvider;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.net.ProxyType;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.ChannelProvider;
import znaishaded.io.vertx.core.net.impl.ProxyChannelProvider;
import znaishaded.io.vertx.core.net.impl.SSLHelper;
import znaishaded.io.vertx.core.spi.metrics.HttpClientMetrics;

class HttpChannelConnector
implements ConnectionProvider<HttpClientConnection> {
    private final HttpClientImpl client;
    private final HttpClientOptions options;
    private final HttpClientMetrics metrics;
    private final SSLHelper sslHelper;
    private final HttpVersion version;
    private final long weight;
    private final long http1Weight;
    private final long http2Weight;
    private final long http1MaxConcurrency;
    private final boolean ssl;
    private final String peerHost;
    private final String host;
    private final int port;
    private final Object metric;

    HttpChannelConnector(HttpClientImpl client, Object metric, HttpVersion version, boolean ssl, String peerHost, String host, int port2) {
        this.client = client;
        this.metric = metric;
        this.options = client.getOptions();
        this.metrics = client.metrics();
        this.sslHelper = client.getSslHelper();
        this.version = version;
        this.http1Weight = client.getOptions().getHttp2MaxPoolSize();
        this.http2Weight = client.getOptions().getMaxPoolSize();
        this.weight = version == HttpVersion.HTTP_2 ? this.http2Weight : this.http1Weight;
        this.http1MaxConcurrency = client.getOptions().isPipelining() ? (long)client.getOptions().getPipeliningLimit() : 1L;
        this.ssl = ssl;
        this.peerHost = peerHost;
        this.host = host;
        this.port = port2;
    }

    public long weight() {
        return this.weight;
    }

    @Override
    public void close(HttpClientConnection conn) {
        conn.close();
    }

    @Override
    public void connect(ConnectionListener<HttpClientConnection> listener, ContextImpl context, Handler<AsyncResult<ConnectResult<HttpClientConnection>>> handler) {
        Future<ConnectResult<HttpClientConnection>> future = Future.future().setHandler(handler);
        try {
            this.doConnect(listener, context, future);
        }
        catch (Exception e) {
            future.tryFail(e);
        }
    }

    @Override
    public void activate(HttpClientConnection conn) {
        if (this.options.getIdleTimeout() > 0) {
            ChannelPipeline pipeline = conn.channelHandlerContext().pipeline();
            pipeline.addFirst("idle", (ChannelHandler)new IdleStateHandler(0, 0, this.options.getIdleTimeout()));
        }
    }

    @Override
    public void deactivate(HttpClientConnection conn) {
        if (this.options.getIdleTimeout() > 0) {
            ChannelPipeline pipeline = conn.channelHandlerContext().pipeline();
            pipeline.remove("idle");
        }
    }

    private void doConnect(ConnectionListener<HttpClientConnection> listener, ContextImpl context, Future<ConnectResult<HttpClientConnection>> future) {
        Bootstrap bootstrap = new Bootstrap();
        bootstrap.group(context.nettyEventLoop());
        bootstrap.channel(this.client.getVertx().transport().channelType(false));
        this.applyConnectionOptions(bootstrap);
        ChannelProvider channelProvider = this.options.getProxyOptions() == null || !this.ssl && this.options.getProxyOptions().getType() == ProxyType.HTTP ? ChannelProvider.INSTANCE : ProxyChannelProvider.INSTANCE;
        boolean useAlpn = this.options.isUseAlpn();
        Handler<Channel> channelInitializer = ch -> {
            ChannelPipeline pipeline = ch.pipeline();
            if (this.ssl) {
                SslHandler sslHandler = new SslHandler(this.sslHelper.createEngine(this.client.getVertx(), this.peerHost, this.port, this.options.isForceSni() ? this.peerHost : null));
                ch.pipeline().addLast("ssl", (ChannelHandler)sslHandler);
                sslHandler.handshakeFuture().addListener(fut -> {
                    if (fut.isSuccess()) {
                        String protocol = sslHandler.applicationProtocol();
                        if (useAlpn) {
                            if ("h2".equals(protocol)) {
                                this.applyHttp2ConnectionOptions(ch.pipeline());
                                this.http2Connected(listener, context, (Channel)ch, future);
                            } else {
                                this.applyHttp1xConnectionOptions(ch.pipeline());
                                HttpVersion fallbackProtocol = "http/1.0".equals(protocol) ? HttpVersion.HTTP_1_0 : HttpVersion.HTTP_1_1;
                                this.http1xConnected(listener, fallbackProtocol, this.host, this.port, true, context, (Channel)ch, this.http1Weight, future);
                            }
                        } else {
                            this.applyHttp1xConnectionOptions(ch.pipeline());
                            this.http1xConnected(listener, this.version, this.host, this.port, true, context, (Channel)ch, this.http1Weight, future);
                        }
                    } else {
                        this.handshakeFailure((Channel)ch, fut.cause(), listener, future);
                    }
                });
            } else if (this.version == HttpVersion.HTTP_2) {
                if (this.client.getOptions().isHttp2ClearTextUpgrade()) {
                    this.applyHttp1xConnectionOptions(pipeline);
                } else {
                    this.applyHttp2ConnectionOptions(pipeline);
                }
            } else {
                this.applyHttp1xConnectionOptions(pipeline);
            }
        };
        Handler<AsyncResult<Channel>> channelHandler = res -> {
            if (res.succeeded()) {
                Channel ch = (Channel)res.result();
                if (!this.ssl) {
                    if (this.version == HttpVersion.HTTP_2) {
                        if (this.client.getOptions().isHttp2ClearTextUpgrade()) {
                            this.http1xConnected(listener, this.version, this.host, this.port, false, context, ch, this.http2Weight, future);
                        } else {
                            this.http2Connected(listener, context, ch, future);
                        }
                    } else {
                        this.http1xConnected(listener, this.version, this.host, this.port, false, context, ch, this.http1Weight, future);
                    }
                }
            } else {
                this.connectFailed(null, listener, res.cause(), future);
            }
        };
        channelProvider.connect(this.client.getVertx(), bootstrap, this.client.getOptions().getProxyOptions(), SocketAddress.inetSocketAddress(this.port, this.host), channelInitializer, channelHandler);
    }

    private void applyConnectionOptions(Bootstrap bootstrap) {
        this.client.getVertx().transport().configure(this.options, bootstrap);
    }

    private void applyHttp2ConnectionOptions(ChannelPipeline pipeline) {
    }

    private void applyHttp1xConnectionOptions(ChannelPipeline pipeline) {
        if (this.client.getOptions().getLogActivity()) {
            pipeline.addLast("logging", (ChannelHandler)new LoggingHandler());
        }
        pipeline.addLast("codec", (ChannelHandler)new HttpClientCodec(this.client.getOptions().getMaxInitialLineLength(), this.client.getOptions().getMaxHeaderSize(), this.client.getOptions().getMaxChunkSize(), false, false, this.client.getOptions().getDecoderInitialBufferSize()));
        if (this.client.getOptions().isTryUseCompression()) {
            pipeline.addLast("inflater", (ChannelHandler)new HttpContentDecompressor(true));
        }
    }

    private void handshakeFailure(Channel ch, Throwable cause, ConnectionListener<HttpClientConnection> listener, Future<ConnectResult<HttpClientConnection>> future) {
        SSLHandshakeException sslException = new SSLHandshakeException("Failed to create SSL connection");
        if (cause != null) {
            sslException.initCause(cause);
        }
        this.connectFailed(ch, listener, sslException, future);
    }

    private void http1xConnected(ConnectionListener<HttpClientConnection> listener, HttpVersion version, String host, int port2, boolean ssl, ContextImpl context, Channel ch, long weight, Future<ConnectResult<HttpClientConnection>> future) {
        boolean upgrade = version == HttpVersion.HTTP_2 && this.options.isHttp2ClearTextUpgrade();
        Http1xClientHandler clientHandler = new Http1xClientHandler(listener, context, upgrade ? HttpVersion.HTTP_1_1 : version, this.peerHost, host, port2, ssl, this.client, this.metric, this.client.metrics());
        clientHandler.addHandler(conn -> {
            if (upgrade) {
                future.complete(new ConnectResult<Http2UpgradedClientConnection>(new Http2UpgradedClientConnection(this.client, (Http1xClientConnection)conn), 1L, ch, context, this.http2Weight));
            } else {
                future.complete(new ConnectResult<Http1xClientConnection>((Http1xClientConnection)conn, this.http1MaxConcurrency, ch, context, this.http1Weight));
            }
        });
        clientHandler.removeHandler(conn -> listener.onDiscard());
        ch.pipeline().addLast("handler", (ChannelHandler)clientHandler);
    }

    private void http2Connected(ConnectionListener<HttpClientConnection> listener, ContextImpl context, Channel ch, Future<ConnectResult<HttpClientConnection>> future) {
        try {
            VertxHttp2ConnectionHandler<Http2ClientConnection> clientHandler = Http2ClientConnection.createHttp2ConnectionHandler(this.client, this.metric, listener, context, (conn, concurrency) -> future.complete(new ConnectResult<Http2ClientConnection>((Http2ClientConnection)conn, (long)concurrency, ch, context, this.http2Weight)));
            ch.pipeline().addLast("handler", clientHandler);
            ch.flush();
        }
        catch (Exception e) {
            this.connectFailed(ch, listener, e, future);
        }
    }

    private void connectFailed(Channel ch, ConnectionListener<HttpClientConnection> listener, Throwable t, Future<ConnectResult<HttpClientConnection>> future) {
        if (ch != null) {
            try {
                ch.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        future.tryFail(t);
    }
}

