/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.net.MalformedURLException;
import java.net.URL;
import java.util.HashSet;
import java.util.Set;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.AuthProvider;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.auth.oauth2.OAuth2Auth;
import znaishaded.io.vertx.ext.auth.oauth2.OAuth2FlowType;
import znaishaded.io.vertx.ext.web.Route;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.Session;
import znaishaded.io.vertx.ext.web.handler.AuthHandler;
import znaishaded.io.vertx.ext.web.handler.OAuth2AuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.AuthorizationAuthHandler;
import znaishaded.io.vertx.ext.web.handler.impl.HttpStatusException;

public class OAuth2AuthHandlerImpl
extends AuthorizationAuthHandler
implements OAuth2AuthHandler {
    private final String host;
    private final String callbackPath;
    private final Set<String> scopes = new HashSet<String>();
    private Route callback;
    private JsonObject extraParams;

    private static AuthProvider verifyProvider(AuthProvider provider) {
        if (provider instanceof OAuth2Auth && ((OAuth2Auth)provider).getFlowType() != OAuth2FlowType.AUTH_CODE) {
            throw new IllegalArgumentException("OAuth2Auth + Bearer Auth requires OAuth2 AUTH_CODE flow");
        }
        return provider;
    }

    public OAuth2AuthHandlerImpl(OAuth2Auth authProvider, String callbackURL) {
        super(OAuth2AuthHandlerImpl.verifyProvider((AuthProvider)authProvider), AuthorizationAuthHandler.Type.BEARER);
        try {
            if (callbackURL != null) {
                URL url = new URL(callbackURL);
                this.host = url.getProtocol() + "://" + url.getHost() + (url.getPort() == -1 ? "" : ":" + url.getPort());
                this.callbackPath = url.getPath();
            } else {
                this.host = null;
                this.callbackPath = null;
            }
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public AuthHandler addAuthority(String authority) {
        this.scopes.add(authority);
        return this;
    }

    @Override
    public AuthHandler addAuthorities(Set<String> authorities) {
        this.scopes.addAll(authorities);
        return this;
    }

    @Override
    public void parseCredentials(RoutingContext context, Handler<AsyncResult<JsonObject>> handler) {
        this.parseAuthorization(context, true, parseAuthorization -> {
            if (parseAuthorization.failed()) {
                handler.handle(Future.failedFuture(parseAuthorization.cause()));
                return;
            }
            String token = (String)parseAuthorization.result();
            if (token == null) {
                if (this.callback == null) {
                    handler.handle(Future.failedFuture("callback route is not configured."));
                    return;
                }
                handler.handle(Future.failedFuture(new HttpStatusException(302, this.authURI(context.request().uri()))));
            } else {
                ((OAuth2Auth)this.authProvider).decodeToken(token, decodeToken -> {
                    if (decodeToken.failed()) {
                        handler.handle(Future.failedFuture(new HttpStatusException(401, decodeToken.cause().getMessage())));
                        return;
                    }
                    context.setUser((User)decodeToken.result());
                    handler.handle(Future.succeededFuture());
                });
            }
        });
    }

    private String authURI(String redirectURL) {
        JsonObject config = new JsonObject().put("state", redirectURL);
        if (this.host != null) {
            config.put("redirect_uri", this.host + this.callback.getPath());
        }
        if (this.extraParams != null) {
            config.mergeIn(this.extraParams);
        }
        if (this.scopes.size() > 0) {
            JsonArray _scopes = new JsonArray();
            for (String authority : this.scopes) {
                _scopes.add(authority);
            }
            config.put("scopes", _scopes);
        }
        return ((OAuth2Auth)this.authProvider).authorizeURL(config);
    }

    @Override
    public OAuth2AuthHandler extraParams(JsonObject extraParams) {
        this.extraParams = extraParams;
        return this;
    }

    @Override
    public OAuth2AuthHandler setupCallback(Route route2) {
        this.callback = route2;
        if (this.callbackPath != null && !"".equals(this.callbackPath)) {
            this.callback.path(this.callbackPath);
        }
        this.callback.method(HttpMethod.GET);
        route2.handler(ctx -> {
            String code = ctx.request().getParam("code");
            if (code == null) {
                ctx.fail(400);
                return;
            }
            String state = ctx.request().getParam("state");
            JsonObject config = new JsonObject().put("code", code);
            if (this.host != null) {
                config.put("redirect_uri", this.host + this.callback.getPath());
            }
            if (this.extraParams != null) {
                config.mergeIn(this.extraParams);
            }
            this.authProvider.authenticate(config, res -> {
                if (res.failed()) {
                    ctx.fail(res.cause());
                } else {
                    ctx.setUser((User)res.result());
                    Session session = ctx.session();
                    if (session != null) {
                        session.regenerateId();
                        ctx.response().putHeader(HttpHeaders.CACHE_CONTROL, (CharSequence)"no-cache, no-store, must-revalidate").putHeader("Pragma", "no-cache").putHeader(HttpHeaders.EXPIRES, (CharSequence)"0").putHeader(HttpHeaders.LOCATION, (CharSequence)(state != null ? state : "/")).setStatusCode(302).end("Redirecting to " + (state != null ? state : "/") + ".");
                    } else {
                        ctx.reroute(state != null ? state : "/");
                    }
                }
            });
        });
        return this;
    }
}

