/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.impl;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.Route;
import znaishaded.io.vertx.ext.web.Router;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.impl.RouteImpl;
import znaishaded.io.vertx.ext.web.impl.RoutingContextImpl;
import znaishaded.io.vertx.ext.web.impl.RoutingContextWrapper;

public class RouterImpl
implements Router {
    private static final Comparator<RouteImpl> routeComparator = (o1, o2) -> {
        int compare = Integer.compare(o1.order(), o2.order());
        if (compare == 0) {
            if (o1.equals(o2)) {
                return 0;
            }
            return 1;
        }
        return compare;
    };
    private static final Logger log = LoggerFactory.getLogger(RouterImpl.class);
    private final Vertx vertx;
    private final Set<RouteImpl> routes = new ConcurrentSkipListSet<RouteImpl>(routeComparator);
    private final AtomicInteger orderSequence = new AtomicInteger();
    private Handler<Throwable> exceptionHandler;

    public RouterImpl(Vertx vertx) {
        this.vertx = vertx;
    }

    @Override
    public void accept(HttpServerRequest request) {
        if (log.isTraceEnabled()) {
            log.trace("Router: " + System.identityHashCode(this) + " accepting request " + (Object)((Object)request.method()) + " " + request.absoluteURI());
        }
        new RoutingContextImpl(null, this, request, this.routes).next();
    }

    @Override
    public Route route() {
        return new RouteImpl(this, this.orderSequence.getAndIncrement());
    }

    @Override
    public Route route(HttpMethod method, String path2) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, path2);
    }

    @Override
    public Route route(String path2) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), path2);
    }

    @Override
    public Route routeWithRegex(HttpMethod method, String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), method, regex, true);
    }

    @Override
    public Route routeWithRegex(String regex) {
        return new RouteImpl(this, this.orderSequence.getAndIncrement(), regex, true);
    }

    @Override
    public Route get() {
        return this.route().method(HttpMethod.GET);
    }

    @Override
    public Route get(String path2) {
        return this.route(HttpMethod.GET, path2);
    }

    @Override
    public Route getWithRegex(String path2) {
        return this.route().method(HttpMethod.GET).pathRegex(path2);
    }

    @Override
    public Route head() {
        return this.route().method(HttpMethod.HEAD);
    }

    @Override
    public Route head(String path2) {
        return this.route(HttpMethod.HEAD, path2);
    }

    @Override
    public Route headWithRegex(String path2) {
        return this.route().method(HttpMethod.HEAD).pathRegex(path2);
    }

    @Override
    public Route options() {
        return this.route().method(HttpMethod.OPTIONS);
    }

    @Override
    public Route options(String path2) {
        return this.route(HttpMethod.OPTIONS, path2);
    }

    @Override
    public Route optionsWithRegex(String path2) {
        return this.route().method(HttpMethod.OPTIONS).pathRegex(path2);
    }

    @Override
    public Route put() {
        return this.route().method(HttpMethod.PUT);
    }

    @Override
    public Route put(String path2) {
        return this.route(HttpMethod.PUT, path2);
    }

    @Override
    public Route putWithRegex(String path2) {
        return this.route().method(HttpMethod.PUT).pathRegex(path2);
    }

    @Override
    public Route post() {
        return this.route().method(HttpMethod.POST);
    }

    @Override
    public Route post(String path2) {
        return this.route(HttpMethod.POST, path2);
    }

    @Override
    public Route postWithRegex(String path2) {
        return this.route().method(HttpMethod.POST).pathRegex(path2);
    }

    @Override
    public Route delete() {
        return this.route().method(HttpMethod.DELETE);
    }

    @Override
    public Route delete(String path2) {
        return this.route(HttpMethod.DELETE, path2);
    }

    @Override
    public Route deleteWithRegex(String path2) {
        return this.route().method(HttpMethod.DELETE).pathRegex(path2);
    }

    @Override
    public Route trace() {
        return this.route().method(HttpMethod.TRACE);
    }

    @Override
    public Route trace(String path2) {
        return this.route(HttpMethod.TRACE, path2);
    }

    @Override
    public Route traceWithRegex(String path2) {
        return this.route().method(HttpMethod.TRACE).pathRegex(path2);
    }

    @Override
    public Route connect() {
        return this.route().method(HttpMethod.CONNECT);
    }

    @Override
    public Route connect(String path2) {
        return this.route(HttpMethod.CONNECT, path2);
    }

    @Override
    public Route connectWithRegex(String path2) {
        return this.route().method(HttpMethod.CONNECT).pathRegex(path2);
    }

    @Override
    public Route patch() {
        return this.route().method(HttpMethod.PATCH);
    }

    @Override
    public Route patch(String path2) {
        return this.route(HttpMethod.PATCH, path2);
    }

    @Override
    public Route patchWithRegex(String path2) {
        return this.route().method(HttpMethod.PATCH).pathRegex(path2);
    }

    @Override
    public List<Route> getRoutes() {
        return new ArrayList<Route>(this.routes);
    }

    @Override
    public Router clear() {
        this.routes.clear();
        return this;
    }

    @Override
    public void handleContext(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    @Override
    public void handleFailure(RoutingContext ctx) {
        new RoutingContextWrapper(this.getAndCheckRoutePath(ctx), ctx.request(), this.routes, ctx).next();
    }

    @Override
    public Router mountSubRouter(String mountPoint, Router subRouter) {
        if (mountPoint.endsWith("*")) {
            throw new IllegalArgumentException("Don't include * when mounting subrouter");
        }
        if (mountPoint.contains(":")) {
            throw new IllegalArgumentException("Can't use patterns in subrouter mounts");
        }
        this.route(mountPoint + "*").handler(subRouter::handleContext).failureHandler(subRouter::handleFailure);
        return this;
    }

    @Override
    public synchronized Router exceptionHandler(Handler<Throwable> exceptionHandler) {
        this.exceptionHandler = exceptionHandler;
        return this;
    }

    void add(RouteImpl route2) {
        this.routes.add(route2);
    }

    void remove(RouteImpl route2) {
        this.routes.remove(route2);
    }

    Vertx vertx() {
        return this.vertx;
    }

    Iterator<RouteImpl> iterator() {
        return this.routes.iterator();
    }

    Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    private String getAndCheckRoutePath(RoutingContext ctx) {
        Route currentRoute = ctx.currentRoute();
        String path2 = currentRoute.getPath();
        if (path2 == null) {
            throw new IllegalStateException("Sub routers must be mounted on constant paths (no regex or patterns)");
        }
        return path2;
    }
}

