/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3;

import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.MonoSwimable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.BoxStyle;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileKilled;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;

public class InstructionSimple
extends MonoSwimable
implements Instruction {
    private boolean killed = false;
    private final Display label;
    private final Colors colors;
    private final LinkRendering inlinkRendering;
    private final BoxStyle style;
    private final Url url;

    public InstructionSimple(Display display, LinkRendering linkRendering, Swimlane swimlane, BoxStyle boxStyle, Url url, Colors colors) {
        super(swimlane);
        if (colors == null) {
            throw new IllegalArgumentException();
        }
        this.url = url;
        this.style = boxStyle;
        this.label = display;
        this.inlinkRendering = linkRendering;
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.colors = colors;
    }

    public Ftile createFtile(FtileFactory ftileFactory) {
        Ftile ftile = ftileFactory.activity(this.label, this.getSwimlaneIn(), this.style, this.colors);
        if (this.url != null) {
            ftile = ftileFactory.addUrl(ftile, this.url);
        }
        ftile = this.eventuallyAddNote(ftileFactory, ftile, ftile.getSwimlaneIn());
        if (this.killed) {
            return new FtileKilled(ftile);
        }
        return ftile;
    }

    public void add(Instruction instruction) {
        throw new UnsupportedOperationException();
    }

    public final boolean kill() {
        this.killed = true;
        return true;
    }

    public LinkRendering getInLinkRendering() {
        return this.inlinkRendering;
    }
}

