/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile;

import java.awt.geom.Dimension2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.Pragma;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Instruction;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.InstructionList;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.CollisionDetector;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Connection;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.ConnectionCross;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.TextBlockInterceptorUDrawable;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddNote;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAddUrl;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorAssembly;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateGroup;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorCreateParallel;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorIf;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorRepeat;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileFactoryDelegatorWhile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.UGraphicInterceptorOneSwimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.VCompactFactory;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.AbstractTextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.UGraphicDelegator;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.UGraphicForSnake;
import znaishaded.net.sourceforge.plantuml.ugraphic.LimitFinder;
import znaishaded.net.sourceforge.plantuml.ugraphic.MinMax;
import znaishaded.net.sourceforge.plantuml.ugraphic.SlotSet;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChange;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.URectangle;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

public class Swimlanes
extends AbstractTextBlock
implements TextBlock {
    private final ISkinParam skinParam;
    private final Pragma pragma;
    private final List<Swimlane> swimlanes = new ArrayList<Swimlane>();
    private Swimlane currentSwimlane = null;
    private final Instruction root;
    private Instruction currentInstruction = this.root = new InstructionList();
    private LinkRendering nextLinkRenderer = LinkRendering.none();
    private static final double separationMargin = 10.0;

    public Swimlanes(ISkinParam iSkinParam, Pragma pragma) {
        this.skinParam = iSkinParam;
        this.pragma = pragma;
    }

    private FontConfiguration getFontConfiguration() {
        return new FontConfiguration(this.skinParam, FontParam.SWIMLANE_TITLE, null);
    }

    private FtileFactory getFtileFactory(StringBounder stringBounder) {
        FtileFactory ftileFactory = new VCompactFactory(this.skinParam, stringBounder);
        ftileFactory = new FtileFactoryDelegatorAddUrl(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorAssembly(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorIf(ftileFactory, this.pragma);
        ftileFactory = new FtileFactoryDelegatorWhile(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorRepeat(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorCreateParallel(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorAddNote(ftileFactory);
        ftileFactory = new FtileFactoryDelegatorCreateGroup(ftileFactory);
        return ftileFactory;
    }

    public void swimlane(String string, HtmlColor htmlColor, Display display) {
        this.currentSwimlane = this.getOrCreate(string);
        if (htmlColor != null) {
            this.currentSwimlane.setSpecificColorTOBEREMOVED(ColorType.BACK, htmlColor);
        }
        if (!Display.isNull(display)) {
            this.currentSwimlane.setDisplay(display);
        }
    }

    private Swimlane getOrCreate(String string) {
        for (Swimlane swimlane : this.swimlanes) {
            if (!swimlane.getName().equals(string)) continue;
            return swimlane;
        }
        Swimlane swimlane = new Swimlane(string);
        this.swimlanes.add(swimlane);
        return swimlane;
    }

    public void drawU(UGraphic uGraphic) {
        FtileFactory ftileFactory = this.getFtileFactory(uGraphic.getStringBounder());
        TextBlock textBlock = this.root.createFtile(ftileFactory);
        uGraphic = new UGraphicForSnake(uGraphic);
        if (this.swimlanes.size() <= 1) {
            textBlock = new TextBlockInterceptorUDrawable(textBlock);
            textBlock.drawU(uGraphic);
            uGraphic.flushUg();
            return;
        }
        this.drawWhenSwimlanes(uGraphic, textBlock);
    }

    private static void printDebug(UGraphic uGraphic, SlotSet slotSet, HtmlColor htmlColor, TextBlock textBlock) {
        slotSet.drawDebugX(uGraphic.apply(new UChangeColor(htmlColor)).apply(new UChangeBackColor(htmlColor)), textBlock.calculateDimension(uGraphic.getStringBounder()).getHeight());
    }

    private void drawWhenSwimlanes(UGraphic uGraphic, TextBlock textBlock) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        Dimension2D dimension2D = textBlock.calculateDimension(stringBounder);
        UTranslate uTranslate = this.getTitleHeightTranslate(stringBounder);
        this.computeSize(uGraphic, textBlock);
        double d = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            Object object;
            HtmlColor htmlColor = swimlane.getColors(this.skinParam).getColor(ColorType.BACK);
            if (htmlColor != null) {
                object = uGraphic.apply(new UChangeBackColor(htmlColor)).apply(new UChangeColor(htmlColor)).apply(new UTranslate(d, 0.0));
                object.draw(new URectangle(swimlane.getTotalWidth(), dimension2D.getHeight() + uTranslate.getDy()));
            }
            object = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            double d2 = object.calculateDimension(stringBounder).getWidth();
            double d3 = d + (swimlane.getTotalWidth() - d2) / 2.0;
            object.drawU(uGraphic.apply(new UTranslate(d3, 0.0)));
            this.drawSeparation(uGraphic.apply(new UTranslate(d, 0.0)), dimension2D.getHeight() + uTranslate.getDy());
            textBlock.drawU(new UGraphicInterceptorOneSwimlane(uGraphic, swimlane).apply(swimlane.getTranslate()).apply(uTranslate));
            d += swimlane.getTotalWidth();
        }
        this.drawSeparation(uGraphic.apply(new UTranslate(d, 0.0)), dimension2D.getHeight() + uTranslate.getDy());
        Cross cross = new Cross(uGraphic.apply(uTranslate));
        textBlock.drawU(cross);
        cross.flushUg();
    }

    private void computeDrawingWidths(UGraphic uGraphic, TextBlock textBlock) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Swimlane swimlane : this.swimlanes) {
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            UGraphicInterceptorOneSwimlane uGraphicInterceptorOneSwimlane = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane);
            textBlock.drawU(uGraphicInterceptorOneSwimlane);
            uGraphicInterceptorOneSwimlane.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            swimlane.setMinMax(minMax);
        }
    }

    private void computeSize(UGraphic uGraphic, TextBlock textBlock) {
        MinMax minMax;
        this.computeDrawingWidths(uGraphic, textBlock);
        double d = 0.0;
        StringBounder stringBounder = uGraphic.getStringBounder();
        double d2 = this.skinParam.swimlaneWidth();
        if (d2 == -1.0) {
            for (Swimlane swimlane : this.swimlanes) {
                minMax = swimlane.getMinMax();
                d2 = Math.max(d2, minMax.getWidth());
            }
        }
        for (Swimlane swimlane : this.swimlanes) {
            minMax = swimlane.getMinMax();
            double d3 = minMax.getWidth() + 20.0;
            TextBlock textBlock2 = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            double d4 = textBlock2.calculateDimension(stringBounder).getWidth();
            double d5 = MathUtils.max(d2, d3, d4 + 20.0);
            UTranslate uTranslate = new UTranslate(d - minMax.getMinX() + 10.0 + (d5 - d3) / 2.0, 0.0);
            swimlane.setTranslateAndWidth(uTranslate, d5);
            d += d5;
        }
    }

    private void computeSizeOld(UGraphic uGraphic, TextBlock textBlock) {
        double d = 0.0;
        StringBounder stringBounder = uGraphic.getStringBounder();
        for (Swimlane swimlane : this.swimlanes) {
            LimitFinder limitFinder = new LimitFinder(stringBounder, false);
            UGraphicInterceptorOneSwimlane uGraphicInterceptorOneSwimlane = new UGraphicInterceptorOneSwimlane(new UGraphicForSnake(limitFinder), swimlane);
            textBlock.drawU(uGraphicInterceptorOneSwimlane);
            uGraphicInterceptorOneSwimlane.flushUg();
            MinMax minMax = limitFinder.getMinMax();
            double d2 = minMax.getWidth() + 20.0;
            TextBlock textBlock2 = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            double d3 = textBlock2.calculateDimension(stringBounder).getWidth();
            double d4 = Math.max(d2, d3 + 20.0);
            UTranslate uTranslate = new UTranslate(d - minMax.getMinX() + 10.0 + (d4 - d2) / 2.0, 0.0);
            swimlane.setTranslateAndWidth(uTranslate, d4);
            d += d4;
        }
    }

    private UTranslate getTitleHeightTranslate(StringBounder stringBounder) {
        double d = 0.0;
        for (Swimlane swimlane : this.swimlanes) {
            TextBlock textBlock = swimlane.getDisplay().create(this.getFontConfiguration(), HorizontalAlignment.LEFT, this.skinParam);
            d = Math.max(d, textBlock.calculateDimension(stringBounder).getHeight());
        }
        UTranslate uTranslate = new UTranslate(0.0, d);
        return uTranslate;
    }

    private CollisionDetector getCollisionDetector(UGraphic uGraphic, UTranslate uTranslate) {
        FtileFactory ftileFactory = this.getFtileFactory(uGraphic.getStringBounder());
        Ftile ftile = this.root.createFtile(ftileFactory);
        uGraphic = new UGraphicForSnake(uGraphic);
        CollisionDetector collisionDetector = new CollisionDetector(uGraphic.getStringBounder());
        for (Swimlane swimlane : this.swimlanes) {
            ftile.drawU(new UGraphicInterceptorOneSwimlane(collisionDetector, swimlane).apply(swimlane.getTranslate()).apply(uTranslate));
        }
        collisionDetector.setManageSnakes(true);
        Cross cross = new Cross(collisionDetector.apply(uTranslate));
        ftile.drawU(cross);
        cross.flushUg();
        return collisionDetector;
    }

    private void drawSeparation(UGraphic uGraphic, double d) {
        HtmlColor htmlColor = this.skinParam.getHtmlColor(ColorParam.swimlaneBorder, null, false);
        if (htmlColor == null) {
            htmlColor = ColorParam.swimlaneBorder.getDefaultValue();
        }
        UStroke uStroke = Rose.getStroke(this.skinParam, LineParam.swimlaneBorder, 2.0);
        uGraphic.apply(uStroke).apply(new UChangeColor(htmlColor)).draw(new ULine(0.0, d));
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return TextBlockUtils.getMinMax(this, stringBounder).getDimension();
    }

    public Instruction getCurrent() {
        return this.currentInstruction;
    }

    public void setCurrent(Instruction instruction) {
        this.currentInstruction = instruction;
    }

    public LinkRendering nextLinkRenderer() {
        return this.nextLinkRenderer;
    }

    public void setNextLinkRenderer(LinkRendering linkRendering) {
        if (linkRendering == null) {
            throw new IllegalArgumentException();
        }
        this.nextLinkRenderer = linkRendering;
    }

    public Swimlane getCurrentSwimlane() {
        return this.currentSwimlane;
    }

    class Cross
    extends UGraphicDelegator {
        private Cross(UGraphic uGraphic) {
            super(uGraphic);
        }

        public void draw(UShape uShape) {
            if (uShape instanceof Ftile) {
                Ftile ftile = (Ftile)uShape;
                ftile.drawU(this);
            } else if (uShape instanceof Connection) {
                Connection connection = (Connection)uShape;
                Ftile ftile = connection.getFtile1();
                Ftile ftile2 = connection.getFtile2();
                if (ftile == null || ftile2 == null) {
                    return;
                }
                if (ftile.getSwimlaneOut() != ftile2.getSwimlaneIn()) {
                    ConnectionCross connectionCross = new ConnectionCross(connection);
                    connectionCross.drawU(this.getUg());
                }
            }
        }

        public UGraphic apply(UChange uChange) {
            return new Cross(this.getUg().apply(uChange));
        }
    }
}

