/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.api;

import znaishaded.net.sourceforge.plantuml.api.MagicArray;

public final class CountRate {
    private final MagicArray lastMinute = new MagicArray(60);
    private final MagicArray lastHour = new MagicArray(60);
    private final MagicArray lastDay = new MagicArray(140);

    public void increment() {
        long l = System.currentTimeMillis();
        this.lastMinute.incKey(l / 1000L);
        this.lastHour.incKey(l / 60000L);
        this.lastDay.incKey(l / 600000L);
    }

    public void increment(int n) {
        long l = System.currentTimeMillis();
        this.lastMinute.incKey(l / 1000L, n);
        this.lastHour.incKey(l / 60000L, n);
        this.lastDay.incKey(l / 600000L, n);
    }

    public long perMinute() {
        return this.lastMinute.getSum();
    }

    public long perHour() {
        return this.lastHour.getSum();
    }

    public long perDay() {
        return this.lastDay.getSum();
    }

    public long perMinuteMax() {
        return this.lastMinute.getMaxSum();
    }

    public long perHourMax() {
        return this.lastHour.getMaxSum();
    }

    public long perDayMax() {
        return this.lastDay.getMaxSum();
    }
}

