/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.dedication;

import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.Random;
import znaishaded.net.sourceforge.plantuml.dedication.TurningBytes;

public class DecoderInputStream
extends InputStream {
    private final TurningBytes message;
    private final TurningBytes sha;
    private final Random rnd;
    private final InputStream source;

    public DecoderInputStream(InputStream inputStream, String string) {
        this.source = inputStream;
        try {
            byte[] byArray = string.getBytes("UTF-8");
            byte[] byArray2 = DecoderInputStream.getSignatureSha512(byArray);
            this.rnd = new Random(this.getSeed(byArray2));
            this.message = new TurningBytes(byArray);
            this.sha = new TurningBytes(byArray2);
        }
        catch (UnsupportedEncodingException unsupportedEncodingException) {
            unsupportedEncodingException.printStackTrace();
            throw new UnsupportedOperationException(unsupportedEncodingException);
        }
    }

    private static byte[] getSignatureSha512(byte[] byArray) {
        try {
            MessageDigest messageDigest = MessageDigest.getInstance("SHA-512");
            messageDigest.update(byArray);
            return messageDigest.digest();
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
            noSuchAlgorithmException.printStackTrace();
            throw new UnsupportedOperationException(noSuchAlgorithmException);
        }
    }

    private long getSeed(byte[] byArray) {
        long l = 17L;
        for (byte by : byArray) {
            l = l * 37L + (long)by;
        }
        return l;
    }

    private byte getNextByte() {
        return (byte)(this.rnd.nextInt() ^ this.message.nextByte() ^ this.sha.nextByte());
    }

    public void close() throws IOException {
        this.source.close();
    }

    public int read() throws IOException {
        int n = this.source.read();
        if (n == -1) {
            return -1;
        }
        n = (n ^ this.getNextByte()) & 0xFF;
        return n;
    }
}

