/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graphic;

import java.util.AbstractCollection;
import java.util.EnumSet;
import java.util.Map;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontPosition;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorUtils;
import znaishaded.net.sourceforge.plantuml.graphic.SvgAttributes;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FontConfiguration {
    private final EnumSet<FontStyle> styles;
    private final UFont currentFont;
    private final UFont motherFont;
    private final HtmlColor motherColor;
    private final HtmlColor hyperlinkColor;
    private final HtmlColor currentColor;
    private final HtmlColor extendedColor;
    private final FontPosition fontPosition;
    private final SvgAttributes svgAttributes;
    private final boolean hyperlink;
    private final boolean useUnderlineForHyperlink;
    private final int tabSize;

    public FontConfiguration(UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl) {
        this(uFont, htmlColor, htmlColor2, bl, 8);
    }

    public FontConfiguration(UFont uFont, HtmlColor htmlColor, HtmlColor htmlColor2, boolean bl, int n) {
        this(FontConfiguration.getStyles(uFont), uFont, htmlColor, uFont, htmlColor, null, FontPosition.NORMAL, new SvgAttributes(), false, htmlColor2, bl, n);
    }

    public static FontConfiguration blackBlueTrue(UFont uFont) {
        return new FontConfiguration(uFont, HtmlColorUtils.BLACK, HtmlColorUtils.BLUE, true, 8);
    }

    public FontConfiguration(ISkinParam iSkinParam, FontParam fontParam, Stereotype stereotype) {
        this(SkinParamUtils.getFont(iSkinParam, fontParam, stereotype), SkinParamUtils.getFontColor(iSkinParam, fontParam, stereotype), iSkinParam.getHyperlinkColor(), iSkinParam.useUnderlineForHyperlink(), iSkinParam.getTabSize());
    }

    public final boolean useUnderlineForHyperlink() {
        return this.useUnderlineForHyperlink;
    }

    public final HtmlColor getHyperlinkColor() {
        return this.hyperlinkColor;
    }

    private static EnumSet<FontStyle> getStyles(UFont uFont) {
        boolean bl = uFont.isBold();
        boolean bl2 = uFont.isItalic();
        if (bl && bl2) {
            return EnumSet.of(FontStyle.ITALIC, FontStyle.BOLD);
        }
        if (bl) {
            return EnumSet.of(FontStyle.BOLD);
        }
        if (bl2) {
            return EnumSet.of(FontStyle.ITALIC);
        }
        return EnumSet.noneOf(FontStyle.class);
    }

    public String toString() {
        return this.styles.toString() + " " + this.currentColor;
    }

    private FontConfiguration(EnumSet<FontStyle> enumSet, UFont uFont, HtmlColor htmlColor, UFont uFont2, HtmlColor htmlColor2, HtmlColor htmlColor3, FontPosition fontPosition, SvgAttributes svgAttributes, boolean bl, HtmlColor htmlColor4, boolean bl2, int n) {
        this.styles = enumSet;
        this.currentFont = uFont2;
        this.motherFont = uFont;
        this.currentColor = htmlColor2;
        this.motherColor = htmlColor;
        this.extendedColor = htmlColor3;
        this.fontPosition = fontPosition;
        this.svgAttributes = svgAttributes;
        this.hyperlink = bl;
        this.hyperlinkColor = htmlColor4;
        this.useUnderlineForHyperlink = bl2;
        this.tabSize = n;
    }

    public FontConfiguration forceFont(UFont uFont, HtmlColor htmlColor) {
        if (uFont == null) {
            return this.add(FontStyle.ITALIC);
        }
        FontConfiguration fontConfiguration = new FontConfiguration(this.styles, uFont, this.motherColor, uFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
        if (htmlColor != null) {
            fontConfiguration = fontConfiguration.changeColor(htmlColor);
        }
        return fontConfiguration;
    }

    public FontConfiguration changeAttributes(SvgAttributes svgAttributes) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes.add(svgAttributes), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    private FontConfiguration withHyperlink() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, true, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeColor(HtmlColor htmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, htmlColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration mute(Colors colors) {
        if (colors == null) {
            throw new IllegalArgumentException();
        }
        HtmlColor htmlColor = colors.getColor(ColorType.TEXT);
        if (htmlColor == null) {
            return this;
        }
        return this.changeColor(htmlColor);
    }

    FontConfiguration changeExtendedColor(HtmlColor htmlColor) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, htmlColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeSize(float f) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont.withSize(f), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration bigger(double d) {
        return this.changeSize((float)((double)this.currentFont.getSize() + d));
    }

    public FontConfiguration changeFontPosition(FontPosition fontPosition) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration changeFamily(String string) {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, new UFont(string, this.currentFont.getStyle(), this.currentFont.getSize()), this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration resetFont() {
        return new FontConfiguration(this.styles, this.motherFont, this.motherColor, this.motherFont, this.motherColor, null, FontPosition.NORMAL, new SvgAttributes(), this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    FontConfiguration add(FontStyle fontStyle) {
        Object object = this.styles.clone();
        if (fontStyle == FontStyle.PLAIN) {
            ((AbstractCollection)object).clear();
        }
        ((AbstractCollection)object).add(fontStyle);
        return new FontConfiguration((EnumSet<FontStyle>)object, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public FontConfiguration italic() {
        return this.add(FontStyle.ITALIC);
    }

    public FontConfiguration bold() {
        return this.add(FontStyle.BOLD);
    }

    public FontConfiguration underline() {
        return this.add(FontStyle.UNDERLINE);
    }

    public FontConfiguration hyperlink() {
        if (this.useUnderlineForHyperlink) {
            return this.add(FontStyle.UNDERLINE).withHyperlink();
        }
        return this.withHyperlink();
    }

    FontConfiguration remove(FontStyle fontStyle) {
        Object object = this.styles.clone();
        ((AbstractCollection)object).remove((Object)fontStyle);
        return new FontConfiguration((EnumSet<FontStyle>)object, this.motherFont, this.motherColor, this.currentFont, this.currentColor, this.extendedColor, this.fontPosition, this.svgAttributes, this.hyperlink, this.hyperlinkColor, this.useUnderlineForHyperlink, this.tabSize);
    }

    public UFont getFont() {
        UFont uFont = this.currentFont;
        for (FontStyle fontStyle : this.styles) {
            uFont = fontStyle.mutateFont(uFont);
        }
        return this.fontPosition.mute(uFont);
    }

    public HtmlColor getColor() {
        if (this.hyperlink) {
            return this.hyperlinkColor;
        }
        return this.currentColor;
    }

    public HtmlColor getExtendedColor() {
        return this.extendedColor;
    }

    public boolean containsStyle(FontStyle fontStyle) {
        return this.styles.contains((Object)fontStyle);
    }

    public int getSpace() {
        return this.fontPosition.getSpace();
    }

    public Map<String, String> getAttributes() {
        return this.svgAttributes.attributes();
    }

    public double getSize2D() {
        return this.currentFont.getSize2D();
    }

    public int getTabSize() {
        return this.tabSize;
    }
}

