/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.util.Collection;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.EntityPortion;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.PortionShower;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.SymbolContext;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.graphic.USymbol;
import znaishaded.net.sourceforge.plantuml.graphic.USymbolFolder;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Margins;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.ugraphic.UComment;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;
import znaishaded.net.sourceforge.plantuml.utils.MathUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class EntityImageDescription
extends AbstractEntityImage {
    private final ShapeType shapeType;
    private final Url url;
    private final TextBlock asSmall;
    private final TextBlock name;
    private final TextBlock desc;
    private TextBlock stereo;
    private final boolean hideText;
    private final Collection<Link> links;
    private final boolean useRankSame;

    public EntityImageDescription(ILeaf iLeaf, ISkinParam iSkinParam, PortionShower portionShower, Collection<Link> collection) {
        super(iLeaf, iLeaf.getColors(iSkinParam).mute(iSkinParam));
        this.useRankSame = iSkinParam.useRankSame();
        this.links = collection;
        Stereotype stereotype = iLeaf.getStereotype();
        USymbol uSymbol = this.getUSymbol(iLeaf);
        this.shapeType = uSymbol == USymbol.FOLDER ? ShapeType.FOLDER : ShapeType.RECTANGLE;
        this.hideText = uSymbol == USymbol.INTERFACE;
        Display display = Display.getWithNewlines(iLeaf.getCode());
        this.desc = iLeaf.getDisplay().equals(display) && uSymbol instanceof USymbolFolder || iLeaf.getDisplay().isWhite() ? TextBlockUtils.empty(0.0, 0.0) : new BodyEnhanced(iLeaf.getDisplay(), uSymbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.LEFT, stereotype, uSymbol.manageHorizontalLine(), false, iLeaf);
        this.url = iLeaf.getUrl99();
        HtmlColor htmlColor = this.getEntity().getColors(this.getSkinParam()).getColor(ColorType.BACK);
        if (htmlColor == null) {
            htmlColor = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBack(), this.getStereo());
        }
        assert (this.getStereo() == stereotype);
        HtmlColor htmlColor2 = SkinParamUtils.getColor(this.getSkinParam(), uSymbol.getColorParamBorder(), stereotype);
        double d = uSymbol.getSkinParameter().getRoundCorner(this.getSkinParam(), stereotype);
        UStroke uStroke = uSymbol.getSkinParameter().getStroke(this.getSkinParam(), stereotype);
        SymbolContext symbolContext = new SymbolContext(htmlColor, htmlColor2).withStroke(uStroke).withShadow(this.getSkinParam().shadowing2(uSymbol.getSkinParameter())).withRoundCorner(d);
        this.stereo = TextBlockUtils.empty(0.0, 0.0);
        if (stereotype != null && stereotype.getSprite() != null && this.getSkinParam().getSprite(stereotype.getSprite()) != null) {
            uSymbol = uSymbol.withStereoAlignment(HorizontalAlignment.RIGHT);
            this.stereo = this.getSkinParam().getSprite(stereotype.getSprite()).asTextBlock(stereotype.getHtmlColor(), 1.0);
        } else if (stereotype != null && stereotype.getLabel(false) != null && portionShower.showPortion(EntityPortion.STEREOTYPE, iLeaf)) {
            this.stereo = Display.getWithNewlines(stereotype.getLabel(this.getSkinParam().useGuillemet())).create(new FontConfiguration(this.getSkinParam(), uSymbol.getFontParamStereotype(), stereotype), HorizontalAlignment.CENTER, this.getSkinParam());
        }
        this.name = new BodyEnhanced(display, uSymbol.getFontParam(), this.getSkinParam(), HorizontalAlignment.CENTER, stereotype, uSymbol.manageHorizontalLine(), false, iLeaf);
        this.asSmall = this.hideText ? uSymbol.asSmall(TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), TextBlockUtils.empty(0.0, 0.0), symbolContext) : uSymbol.asSmall(this.name, this.desc, this.stereo, symbolContext);
    }

    private USymbol getUSymbol(ILeaf iLeaf) {
        USymbol uSymbol;
        USymbol uSymbol2 = iLeaf.getUSymbol() == null ? (this.getSkinParam().useUml2ForComponent() ? USymbol.COMPONENT2 : USymbol.COMPONENT1) : (uSymbol = iLeaf.getUSymbol());
        if (uSymbol == null) {
            throw new IllegalArgumentException();
        }
        return uSymbol;
    }

    public Dimension2D getNameDimension(StringBounder stringBounder) {
        if (this.hideText) {
            return new Dimension2DDouble(0.0, 0.0);
        }
        return this.name.calculateDimension(stringBounder);
    }

    @Override
    public Dimension2D calculateDimension(StringBounder stringBounder) {
        return this.asSmall.calculateDimension(stringBounder);
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        if (!(!this.hideText || this.useRankSame && this.hasSomeHorizontalLink((ILeaf)this.getEntity(), this.links))) {
            Dimension2D dimension2D = this.stereo.calculateDimension(stringBounder);
            Dimension2D dimension2D2 = this.desc.calculateDimension(stringBounder);
            Dimension2D dimension2D3 = this.asSmall.calculateDimension(stringBounder);
            double d = Math.max(dimension2D.getWidth(), dimension2D2.getWidth());
            double d2 = d - dimension2D3.getWidth();
            if (d2 < 1.0) {
                d2 = 1.0;
            }
            double d3 = MathUtils.max(1.0, dimension2D2.getHeight(), dimension2D.getHeight());
            return new Margins(d2 / 2.0, d2 / 2.0, d3, d3);
        }
        return Margins.NONE;
    }

    private boolean hasSomeHorizontalLink(ILeaf iLeaf, Collection<Link> collection) {
        for (Link link : collection) {
            if (link.getLength() != 1 || !link.contains(iLeaf)) continue;
            return true;
        }
        return false;
    }

    @Override
    public final void drawU(UGraphic uGraphic) {
        uGraphic.draw(new UComment("entity " + this.getEntity().getCode().getFullName()));
        if (this.url != null) {
            uGraphic.startUrl(this.url);
        }
        this.asSmall.drawU(uGraphic);
        if (this.hideText) {
            Dimension2D dimension2D = this.asSmall.calculateDimension(uGraphic.getStringBounder());
            Dimension2D dimension2D2 = this.desc.calculateDimension(uGraphic.getStringBounder());
            this.desc.drawU(uGraphic.apply(new UTranslate((dimension2D.getWidth() - dimension2D2.getWidth()) / 2.0, 8.0 + dimension2D.getHeight())));
            Dimension2D dimension2D3 = this.stereo.calculateDimension(uGraphic.getStringBounder());
            this.stereo.drawU(uGraphic.apply(new UTranslate((dimension2D.getWidth() - dimension2D3.getWidth()) / 2.0, -8.0 - dimension2D3.getHeight())));
        }
        if (this.url != null) {
            uGraphic.closeAction();
        }
    }

    @Override
    public ShapeType getShapeType() {
        return this.shapeType;
    }
}

