/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.svg;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.FontStyle;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColorGradient;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.svg.SvgGraphics;
import znaishaded.net.sourceforge.plantuml.ugraphic.ClipContainer;
import znaishaded.net.sourceforge.plantuml.ugraphic.ColorMapper;
import znaishaded.net.sourceforge.plantuml.ugraphic.UClip;
import znaishaded.net.sourceforge.plantuml.ugraphic.UDriver;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFont;
import znaishaded.net.sourceforge.plantuml.ugraphic.UFontContext;
import znaishaded.net.sourceforge.plantuml.ugraphic.UParam;
import znaishaded.net.sourceforge.plantuml.ugraphic.UShape;
import znaishaded.net.sourceforge.plantuml.ugraphic.UText;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DriverTextSvg
implements UDriver<SvgGraphics> {
    private final StringBounder stringBounder;
    private final ClipContainer clipContainer;

    public DriverTextSvg(StringBounder stringBounder, ClipContainer clipContainer) {
        this.stringBounder = stringBounder;
        this.clipContainer = clipContainer;
    }

    @Override
    public void draw(UShape uShape, double d, double d2, ColorMapper colorMapper, UParam uParam, SvgGraphics svgGraphics) {
        UClip uClip = this.clipContainer.getClip();
        if (uClip != null && !uClip.isInside(d, d2)) {
            return;
        }
        UText uText = (UText)uShape;
        FontConfiguration fontConfiguration = uText.getFontConfiguration();
        UFont uFont = fontConfiguration.getFont();
        String string = null;
        if (fontConfiguration.containsStyle(FontStyle.BOLD) || uFont.isBold()) {
            string = "bold";
        }
        String string2 = null;
        if (fontConfiguration.containsStyle(FontStyle.ITALIC) || uFont.isItalic()) {
            string2 = "italic";
        }
        String string3 = null;
        if (fontConfiguration.containsStyle(FontStyle.UNDERLINE)) {
            string3 = "underline";
        } else if (fontConfiguration.containsStyle(FontStyle.STRIKE)) {
            string3 = "line-through";
        }
        String string4 = uText.getText();
        if (string4.startsWith(" ")) {
            double d3 = this.stringBounder.calculateDimension(uFont, " ").getWidth();
            while (string4.startsWith(" ")) {
                d += d3;
                string4 = string4.substring(1);
            }
        }
        string4 = StringUtils.trin(string4);
        Dimension2D dimension2D = this.stringBounder.calculateDimension(uFont, string4);
        String string5 = null;
        double d4 = dimension2D.getWidth();
        double d5 = dimension2D.getHeight();
        if (fontConfiguration.containsStyle(FontStyle.BACKCOLOR)) {
            HtmlColor htmlColor = fontConfiguration.getExtendedColor();
            if (htmlColor instanceof HtmlColorGradient) {
                HtmlColorGradient htmlColorGradient = (HtmlColorGradient)htmlColor;
                String string6 = svgGraphics.createSvgGradient(StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor1())), StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColorGradient.getColor2())), htmlColorGradient.getPolicy());
                svgGraphics.setFillColor("url(#" + string6 + ")");
                svgGraphics.setStrokeColor(null);
                svgGraphics.svgRectangle(d, d2 - d5 + 2.0, d4, d5, 0.0, 0.0, 0.0, null);
            } else {
                string5 = StringUtils.getAsHtml(colorMapper.getMappedColor(htmlColor));
            }
        }
        svgGraphics.setFillColor(StringUtils.getAsHtml(colorMapper.getMappedColor(fontConfiguration.getColor())));
        svgGraphics.text(string4, d, d2, uFont.getFamily(UFontContext.SVG), uFont.getSize(), string, string2, string3, d4, fontConfiguration.getAttributes(), string5);
    }
}

