/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.cli;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.cli.extension.CliCommandHandler;
import org.testingisdocumenting.znai.cli.extension.CliCommandHandlers;
import org.testingisdocumenting.znai.client.DeployTempDir;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import znaishaded.org.apache.commons.cli.CommandLine;
import znaishaded.org.apache.commons.cli.DefaultParser;
import znaishaded.org.apache.commons.cli.HelpFormatter;
import znaishaded.org.apache.commons.cli.Options;
import znaishaded.org.apache.commons.cli.ParseException;

public class ZnaiCliConfig {
    private static final String PREVIEW_KEY = "preview";
    private static final String SERVE_KEY = "serve";
    private static final String GENERATE_KEY = "new";
    private static final String EXPORT_KEY = "export";
    private static final String DEPLOY_KEY = "deploy";
    private static final String MODIFIED_TIME_KEY = "modified-time";
    private static final String DOC_ID_KEY = "doc-id";
    private static final String SOURCE_KEY = "source";
    private static final String MARKUP_TYPE_KEY = "markup-type";
    private static final String HOST_KEY = "host";
    private static final String PORT_KEY = "port";
    private static final String ACTOR_KEY = "actor";
    private static final String LOOKUP_PATHS_KEY = "lookup-paths";
    private static final String HELP_KEY = "help";
    private static final int DEFAULT_PORT = 3333;
    private String docId;
    private String markupType;
    private String host;
    private Path deployRoot;
    private Path exportRoot;
    private Path sourceRoot;
    private boolean isSourceRootSet;
    private Integer port;
    private Mode mode;
    private List<String> specifiedCustomCommands;
    private String actor;
    private String lookupPaths;
    private ModifiedTimeStrategy modifiedTimeStrategy;

    public ZnaiCliConfig(String ... args) {
        this.parseArgs(args);
    }

    public String getModeAsString() {
        return this.mode.getLabel();
    }

    public CliCommandHandler getSpecifiedCustomCommand() {
        return CliCommandHandlers.findByCommand(this.getSpecifiedCustomCommandName());
    }

    private String getSpecifiedCustomCommandName() {
        return this.specifiedCustomCommands.get(0);
    }

    public boolean isScaffoldMode() {
        return this.mode == Mode.SCAFFOLD;
    }

    public boolean isPreviewMode() {
        return this.mode == Mode.PREVIEW;
    }

    public boolean isServeMode() {
        return this.mode == Mode.SERVE;
    }

    public boolean isGenerateOnlyMode() {
        return this.mode == Mode.BUILD;
    }

    public boolean isExportMode() {
        return this.mode == Mode.EXPORT;
    }

    public boolean isCustomCommand() {
        return !this.specifiedCustomCommands.isEmpty();
    }

    public String getMarkupType() {
        return this.markupType;
    }

    public Path getSourceRoot() {
        return this.validateIsSet("sourceRoot", this.sourceRoot);
    }

    public boolean isSourceRootSet() {
        return this.isSourceRootSet;
    }

    public Path getExportRoot() {
        return this.exportRoot;
    }

    public Integer getPort() {
        return this.port;
    }

    public String getHost() {
        return this.host;
    }

    public String getDocId() {
        return this.docId;
    }

    public String getActor() {
        return this.actor;
    }

    public void setSourceRoot(Path sourceRoot) {
        this.sourceRoot = sourceRoot;
    }

    public void setDeployRoot(Path deployRoot) {
        this.deployRoot = deployRoot;
    }

    public List<String> getLookupPaths() {
        if (this.lookupPaths.isEmpty()) {
            return Collections.emptyList();
        }
        return Arrays.asList(this.lookupPaths.split(":"));
    }

    public ModifiedTimeStrategy getModifiedTimeStrategy() {
        return this.modifiedTimeStrategy;
    }

    public Path getDeployRoot() {
        return this.validateIsSet("deployRoot", this.deployRoot);
    }

    public void print() {
        if (!this.isScaffoldMode() && !this.isServeMode()) {
            this.print("source root", this.sourceRoot);
        }
        if (this.isPreviewMode() || this.isServeMode()) {
            this.print("deploy root", this.deployRoot);
            this.print("       host", this.host);
            this.print("       port", this.port);
        }
        if (this.isGenerateOnlyMode()) {
            this.print("     doc id", this.docId);
        }
        if (this.isExportMode()) {
            this.print("export root", this.exportRoot);
        }
    }

    public String toString() {
        return "deployRoot: " + this.deployRoot + "\n";
    }

    private void parseArgs(String[] args) {
        Options options = this.createOptions();
        CommandLine commandLine = this.createCommandLine(args, options);
        if (commandLine.hasOption(HELP_KEY) || args.length < 1) {
            HelpFormatter helpFormatter = new HelpFormatter();
            helpFormatter.printHelp("znai", options);
            System.exit(1);
        }
        this.port = commandLine.hasOption(PORT_KEY) ? Integer.parseInt(commandLine.getOptionValue(PORT_KEY)) : 3333;
        this.mode = this.determineMode(commandLine);
        this.specifiedCustomCommands = CliCommandHandlers.registeredCommandNames().filter(commandLine::hasOption).collect(Collectors.toList());
        this.docId = commandLine.hasOption(DOC_ID_KEY) ? commandLine.getOptionValue(DOC_ID_KEY) : "no-id-specified";
        this.host = commandLine.hasOption(HOST_KEY) ? commandLine.getOptionValue(HOST_KEY) : "localhost";
        this.markupType = commandLine.hasOption(MARKUP_TYPE_KEY) ? commandLine.getOptionValue(MARKUP_TYPE_KEY) : "markdown";
        this.isSourceRootSet = commandLine.hasOption(SOURCE_KEY);
        this.sourceRoot = Paths.get(this.isSourceRootSet ? commandLine.getOptionValue(SOURCE_KEY) : "", new String[0]).toAbsolutePath();
        this.deployRoot = (commandLine.hasOption(DEPLOY_KEY) ? Paths.get(commandLine.getOptionValue(DEPLOY_KEY), new String[0]) : DeployTempDir.prepare(this.getModeAsString(), this.port)).toAbsolutePath();
        this.exportRoot = commandLine.hasOption(EXPORT_KEY) ? Paths.get(commandLine.getOptionValue(EXPORT_KEY), new String[0]) : Paths.get("", new String[0]);
        this.actor = commandLine.hasOption(ACTOR_KEY) ? commandLine.getOptionValue(ACTOR_KEY) : "";
        this.lookupPaths = commandLine.hasOption(LOOKUP_PATHS_KEY) ? commandLine.getOptionValue(LOOKUP_PATHS_KEY) : "";
        this.modifiedTimeStrategy = this.determineModifiedTimeStrategy(commandLine);
        this.validateMode(commandLine);
    }

    private Mode determineMode(CommandLine commandLine) {
        if (commandLine.hasOption(PREVIEW_KEY)) {
            return Mode.PREVIEW;
        }
        if (commandLine.hasOption(SERVE_KEY)) {
            return Mode.SERVE;
        }
        if (commandLine.hasOption(GENERATE_KEY)) {
            return Mode.SCAFFOLD;
        }
        if (commandLine.hasOption(EXPORT_KEY)) {
            return Mode.EXPORT;
        }
        if (this.specifiedCustomCommands != null && !this.specifiedCustomCommands.isEmpty()) {
            return Mode.CUSTOM;
        }
        return Mode.BUILD;
    }

    private ModifiedTimeStrategy determineModifiedTimeStrategy(CommandLine commandLine) {
        String modifiedTime;
        if (!commandLine.hasOption(MODIFIED_TIME_KEY)) {
            return ModifiedTimeStrategy.NA;
        }
        switch (modifiedTime = commandLine.getOptionValue(MODIFIED_TIME_KEY)) {
            case "constant": {
                return ModifiedTimeStrategy.CONSTANT;
            }
            case "file": {
                return ModifiedTimeStrategy.FILE;
            }
        }
        throw new IllegalArgumentException("unsupported modified-time value: " + modifiedTime);
    }

    private void validateMode(CommandLine commandLine) {
        long activeModesCount = Stream.of(PREVIEW_KEY, SERVE_KEY, GENERATE_KEY, EXPORT_KEY).filter(commandLine::hasOption).count() + (long)this.specifiedCustomCommands.size();
        if (activeModesCount > 1L) {
            throw new RuntimeException("only one mode can be active");
        }
    }

    private CommandLine createCommandLine(String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }

    private <E> E validateIsSet(String name, E v) {
        if (v == null) {
            throw new RuntimeException("<" + name + "> is not set. specify it using args or a configuration set method");
        }
        return v;
    }

    private Options createOptions() {
        Options options = new Options();
        options.addOption(null, HELP_KEY, false, "print help");
        options.addOption(null, PORT_KEY, true, "server port");
        options.addOption(null, HOST_KEY, true, "server host");
        options.addOption(null, MARKUP_TYPE_KEY, true, "markup type");
        options.addOption(null, SOURCE_KEY, true, "documentation source dir");
        options.addOption(null, DOC_ID_KEY, true, "documentation id");
        options.addOption(null, MODIFIED_TIME_KEY, true, "strategy of modified time for each page: constant or file last update time: constant, file (default)");
        options.addOption(null, LOOKUP_PATHS_KEY, true, "additional lookup paths separated by color(:)");
        options.addOption(null, DEPLOY_KEY, true, "documentation deploy root dir");
        options.addOption(null, PREVIEW_KEY, false, "preview mode");
        options.addOption(null, SERVE_KEY, false, "server mode");
        options.addOption(null, EXPORT_KEY, true, "export documentation source including required artifacts");
        options.addOption(null, GENERATE_KEY, false, "create new documentation with minimal necessary files");
        CliCommandHandlers.forEach(h2 -> options.addOption(null, h2.commandName(), false, h2.description()));
        return options;
    }

    private void print(String name, Object value) {
        ConsoleOutputs.out(new Object[]{Color.BLUE, name, ": ", Color.YELLOW, value});
    }

    public static enum ModifiedTimeStrategy {
        FILE,
        CONSTANT,
        NA;

    }

    public static enum Mode {
        BUILD("build"),
        PREVIEW("preview"),
        SERVE("serve"),
        EXPORT("export"),
        SCAFFOLD("scaffold new"),
        CUSTOM("custom");

        private final String label;

        private Mode(String label) {
            this.label = label;
        }

        public String getLabel() {
            return this.label;
        }
    }
}

