/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.stream.Stream;

public class ColonDelimitedKeyValues {
    private final String[] lines;
    private final Map<String, String> vars;
    private String currentVarName;
    private final List<String> currentValueLines;

    public ColonDelimitedKeyValues(String content) {
        this.lines = content.split("\n");
        this.vars = new LinkedHashMap<String, String>();
        this.currentVarName = "";
        this.currentValueLines = new ArrayList<String>();
        this.extractVars();
    }

    public void forEach(BiConsumer<String, String> consumer) {
        this.vars.forEach(consumer);
    }

    public <R> Stream<R> map(BiFunction<String, String, R> function) {
        return this.vars.entrySet().stream().map((? super T e) -> function.apply((String)e.getKey(), (String)e.getValue()));
    }

    public String get(String name) {
        if (!this.vars.containsKey(name)) {
            throw new RuntimeException("no value defined for key: " + name);
        }
        return this.vars.get(name);
    }

    public Map<String, String> toMap() {
        return Collections.unmodifiableMap(this.vars);
    }

    public String toString() {
        return this.vars.toString();
    }

    private void extractVars() {
        Arrays.stream(this.lines).forEach(this::processLine);
        this.flushVar();
    }

    private void processLine(String line) {
        KeyValuePart keyValuePart = ColonDelimitedKeyValues.extractKeyAndValuePart(line);
        if (!keyValuePart.key.isEmpty()) {
            this.flushVar();
            this.currentVarName = keyValuePart.key;
            if (!keyValuePart.valuePart.trim().isEmpty()) {
                this.currentValueLines.add(keyValuePart.valuePart);
            }
        } else {
            this.currentValueLines.add(line);
        }
    }

    private static KeyValuePart extractKeyAndValuePart(String line) {
        if (line.startsWith(" ")) {
            return new KeyValuePart("", line);
        }
        line = line.trim();
        int pc = 32;
        int quoteStartIdx = -1;
        int quoteEndIdx = -1;
        int numberOfQuotes = 0;
        int numberOfSpaces = 0;
        for (int i = 0; i < line.length(); ++i) {
            boolean isQuote;
            char c = line.charAt(i);
            boolean bl = isQuote = c == '\"' && pc != 92;
            if (isQuote) {
                if (quoteStartIdx == -1) {
                    quoteStartIdx = i;
                } else if (quoteEndIdx == -1) {
                    quoteEndIdx = i;
                }
                ++numberOfQuotes;
            }
            if (Character.isSpaceChar(c)) {
                ++numberOfSpaces;
            }
            if (c == ':') {
                if (numberOfQuotes == 2) {
                    return new KeyValuePart(line.substring(quoteStartIdx + 1, quoteEndIdx), line.substring(quoteEndIdx + 2));
                }
                if (numberOfQuotes == 0 && numberOfSpaces == 0) {
                    return new KeyValuePart(line.substring(0, i), line.substring(i + 1));
                }
            }
            pc = c;
        }
        return new KeyValuePart("", line);
    }

    private void flushVar() {
        if (this.currentVarName.isEmpty()) {
            return;
        }
        this.vars.put(this.currentVarName, String.join((CharSequence)"\n", this.currentValueLines));
        this.currentValueLines.clear();
        this.currentVarName = "";
    }

    private static class KeyValuePart {
        private final String key;
        private final String valuePart;

        KeyValuePart(String key, String valuePart) {
            this.key = key;
            this.valuePart = valuePart;
        }
    }
}

