/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.google.zxing.qrcode;

import java.util.Hashtable;
import znaishaded.com.google.zxing.BarcodeFormat;
import znaishaded.com.google.zxing.EncodeHintType;
import znaishaded.com.google.zxing.Writer;
import znaishaded.com.google.zxing.WriterException;
import znaishaded.com.google.zxing.common.BitMatrix;
import znaishaded.com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import znaishaded.com.google.zxing.qrcode.encoder.ByteMatrix;
import znaishaded.com.google.zxing.qrcode.encoder.Encoder;
import znaishaded.com.google.zxing.qrcode.encoder.QRCode;

public final class QRCodeWriter
implements Writer {
    private static final int QUIET_ZONE_SIZE = 4;

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n) throws WriterException {
        return this.encode(string, barcodeFormat, n, null);
    }

    public BitMatrix encode(String string, BarcodeFormat barcodeFormat, int n, Hashtable hashtable) throws WriterException {
        Object object;
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Found empty contents");
        }
        if (barcodeFormat != BarcodeFormat.QR_CODE) {
            throw new IllegalArgumentException("Can only encode QR_CODE, but got " + barcodeFormat);
        }
        Object object2 = ErrorCorrectionLevel.L;
        if (hashtable != null && (object = (ErrorCorrectionLevel)hashtable.get(EncodeHintType.ERROR_CORRECTION)) != null) {
            object2 = object;
        }
        object = new QRCode();
        Encoder.encode(string, (ErrorCorrectionLevel)object2, hashtable, (QRCode)object);
        return QRCodeWriter.renderResult((QRCode)object, n);
    }

    private static BitMatrix renderResult(QRCode qRCode, int n) {
        ByteMatrix byteMatrix = qRCode.getMatrix();
        int n2 = byteMatrix.getWidth();
        int n3 = byteMatrix.getHeight();
        int n4 = n2 + 8;
        int n5 = n3 + 8;
        int n6 = 4 * n;
        int n7 = 4 * n;
        BitMatrix bitMatrix = new BitMatrix(n4 * n, n5 * n);
        int n8 = 0;
        int n9 = n7;
        while (n8 < n3) {
            int n10 = 0;
            int n11 = n6;
            while (n10 < n2) {
                if (byteMatrix.get(n10, n8) == 1) {
                    bitMatrix.setRegion(n11, n9, n, n);
                }
                ++n10;
                n11 += n;
            }
            ++n8;
            n9 += n;
        }
        return bitMatrix;
    }
}

