/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.util.ArrayList;
import java.util.List;
import znaishaded.freemarker.core.BuiltInWithParseTimeParameters;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.EvalUtil;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.Token;
import znaishaded.freemarker.core._MiscTemplateException;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateModel;

final class BuiltInsWithParseTimeParameters {
    private BuiltInsWithParseTimeParameters() {
    }

    static class switch_BI
    extends BuiltInWithParseTimeParameters {
        private List parameters;

        switch_BI() {
        }

        void bindToParameters(List parameters, Token openParen, Token closeParen) throws ParseException {
            if (parameters.size() < 2) {
                throw this.newArgumentCountException("must have at least 2", openParen, closeParen);
            }
            this.parameters = parameters;
        }

        protected List getArgumentsAsList() {
            return this.parameters;
        }

        protected int getArgumentsCount() {
            return this.parameters.size();
        }

        protected Expression getArgumentParameterValue(int argIdx) {
            return (Expression)this.parameters.get(argIdx);
        }

        protected void cloneArguments(Expression clone, String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
            ArrayList<Expression> parametersClone = new ArrayList<Expression>(this.parameters.size());
            for (int i = 0; i < this.parameters.size(); ++i) {
                parametersClone.add(((Expression)this.parameters.get(i)).deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState));
            }
            ((switch_BI)clone).parameters = parametersClone;
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            TemplateModel targetValue = this.target.evalToNonMissing(env);
            List parameters = this.parameters;
            int paramCnt = parameters.size();
            int i = 0;
            while (i + 1 < paramCnt) {
                Expression caseExp = (Expression)parameters.get(i);
                TemplateModel caseValue = caseExp.evalToNonMissing(env);
                if (EvalUtil.compare(targetValue, this.target, 1, "==", caseValue, caseExp, this, true, false, false, false, env)) {
                    return ((Expression)parameters.get(i + 1)).evalToNonMissing(env);
                }
                i += 2;
            }
            if (paramCnt % 2 == 0) {
                throw new _MiscTemplateException(this.target, new Object[]{"The value before ?", this.key, "(case1, value1, case2, value2, ...) didn't match any of the case parameters, and there was no default value parameter (an additional last parameter) eihter. "});
            }
            return ((Expression)parameters.get(paramCnt - 1)).evalToNonMissing(env);
        }
    }

    static class then_BI
    extends BuiltInWithParseTimeParameters {
        private Expression whenTrueExp;
        private Expression whenFalseExp;

        then_BI() {
        }

        TemplateModel _eval(Environment env) throws TemplateException {
            boolean lho = this.target.evalToBoolean(env);
            return (lho ? this.whenTrueExp : this.whenFalseExp).evalToNonMissing(env);
        }

        void bindToParameters(List parameters, Token openParen, Token closeParen) throws ParseException {
            if (parameters.size() != 2) {
                throw this.newArgumentCountException("requires exactly 2", openParen, closeParen);
            }
            this.whenTrueExp = (Expression)parameters.get(0);
            this.whenFalseExp = (Expression)parameters.get(1);
        }

        protected Expression getArgumentParameterValue(int argIdx) {
            switch (argIdx) {
                case 0: {
                    return this.whenTrueExp;
                }
                case 1: {
                    return this.whenFalseExp;
                }
            }
            throw new IndexOutOfBoundsException();
        }

        protected int getArgumentsCount() {
            return 2;
        }

        protected List getArgumentsAsList() {
            ArrayList<Expression> args = new ArrayList<Expression>(2);
            args.add(this.whenTrueExp);
            args.add(this.whenFalseExp);
            return args;
        }

        protected void cloneArguments(Expression cloneExp, String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
            then_BI clone = (then_BI)cloneExp;
            clone.whenTrueExp = this.whenTrueExp.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState);
            clone.whenFalseExp = this.whenFalseExp.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState);
        }
    }
}

