/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl;

import java.util.function.Function;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.CompositeFuture;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.NoStackTraceThrowable;

public class CompositeFutureImpl
implements CompositeFuture,
Handler<AsyncResult<CompositeFuture>> {
    private static final Handler<AsyncResult<CompositeFuture>> NO_HANDLER = c -> {};
    private static final Function<CompositeFuture, Throwable> ALL = cf -> {
        int size = cf.size();
        for (int i = 0; i < size; ++i) {
            if (cf.succeeded(i)) continue;
            return cf.cause(i);
        }
        return null;
    };
    private final Future[] results;
    private int count;
    private boolean completed;
    private Throwable cause;
    private Handler<AsyncResult<CompositeFuture>> handler;

    public static CompositeFuture all(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        ++composite.count;
                        if (!composite.isComplete() && composite.count == len) {
                            handler = composite.setCompleted(null);
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    if (!composite.isComplete()) {
                        handler = composite.setCompleted(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    public static CompositeFuture any(Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                if (ar.succeeded()) {
                    CompositeFutureImpl compositeFutureImpl = composite;
                    synchronized (compositeFutureImpl) {
                        if (!composite.isComplete()) {
                            handler = composite.setCompleted(null);
                        }
                    }
                }
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        handler = composite.setCompleted(ar.cause());
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (results.length == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    public static CompositeFuture join(Future<?> ... results) {
        return CompositeFutureImpl.join(ALL, results);
    }

    private static CompositeFuture join(Function<CompositeFuture, Throwable> pred, Future<?> ... results) {
        CompositeFutureImpl composite = new CompositeFutureImpl(results);
        int len = results.length;
        for (int i = 0; i < len; ++i) {
            results[i].setHandler((AsyncResult<T> ar) -> {
                Handler<AsyncResult<CompositeFuture>> handler = null;
                CompositeFutureImpl compositeFutureImpl = composite;
                synchronized (compositeFutureImpl) {
                    ++composite.count;
                    if (!composite.isComplete() && composite.count == len) {
                        Throwable failure = (Throwable)pred.apply(composite);
                        handler = composite.setCompleted(failure);
                    }
                }
                if (handler != null) {
                    handler.handle(composite);
                }
            });
        }
        if (len == 0) {
            composite.setCompleted(null);
        }
        return composite;
    }

    private CompositeFutureImpl(Future<?> ... results) {
        this.results = results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public CompositeFuture setHandler(Handler<AsyncResult<CompositeFuture>> handler) {
        boolean call;
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            this.handler = handler;
            call = this.completed;
        }
        if (call) {
            handler.handle(this);
        }
        return this;
    }

    @Override
    public Throwable cause(int index) {
        return this.future(index).cause();
    }

    @Override
    public boolean succeeded(int index) {
        return this.future(index).succeeded();
    }

    @Override
    public boolean failed(int index) {
        return this.future(index).failed();
    }

    @Override
    public boolean isComplete(int index) {
        return this.future(index).isComplete();
    }

    @Override
    public <T> T resultAt(int index) {
        return this.future(index).result();
    }

    private <T> Future<T> future(int index) {
        if (index < 0 || index > this.results.length) {
            throw new IndexOutOfBoundsException();
        }
        return this.results[index];
    }

    @Override
    public int size() {
        return this.results.length;
    }

    @Override
    public synchronized boolean isComplete() {
        return this.completed;
    }

    @Override
    public synchronized boolean succeeded() {
        return this.completed && this.cause == null;
    }

    @Override
    public synchronized boolean failed() {
        return this.completed && this.cause != null;
    }

    @Override
    public synchronized Throwable cause() {
        return this.completed && this.cause != null ? this.cause : null;
    }

    @Override
    public synchronized CompositeFuture result() {
        return this.completed && this.cause == null ? this : null;
    }

    @Override
    public void complete() {
        if (!this.tryComplete()) {
            throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
        }
    }

    @Override
    public void complete(CompositeFuture result) {
        if (!this.tryComplete(result)) {
            throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(Throwable cause) {
        if (!this.tryFail(cause)) {
            throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
        }
    }

    @Override
    public void fail(String failureMessage) {
        if (!this.tryFail(failureMessage)) {
            throw new IllegalStateException("Result is already complete: " + (this.cause == null ? "succeeded" : "failed"));
        }
    }

    @Override
    public boolean tryComplete(CompositeFuture result) {
        Handler<AsyncResult<CompositeFuture>> handler = this.setCompleted(null);
        if (handler != null) {
            handler.handle(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryComplete() {
        return this.tryComplete(this);
    }

    @Override
    public boolean tryFail(Throwable cause) {
        Handler<AsyncResult<CompositeFuture>> handler = this.setCompleted(cause);
        if (handler != null) {
            handler.handle(this);
            return true;
        }
        return false;
    }

    @Override
    public boolean tryFail(String failureMessage) {
        return this.tryFail(new NoStackTraceThrowable(failureMessage));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Handler<AsyncResult<CompositeFuture>> setCompleted(Throwable cause) {
        CompositeFutureImpl compositeFutureImpl = this;
        synchronized (compositeFutureImpl) {
            if (this.completed) {
                return null;
            }
            this.completed = true;
            this.cause = cause;
            return this.handler != null ? this.handler : NO_HANDLER;
        }
    }

    @Override
    public Handler<AsyncResult<CompositeFuture>> completer() {
        return this;
    }

    @Override
    public void handle(AsyncResult<CompositeFuture> asyncResult) {
        if (asyncResult.succeeded()) {
            this.complete(this);
        } else {
            this.fail(asyncResult.cause());
        }
    }
}

