/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command;

import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.classdiagram.ClassDiagram;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.GroupType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IGroup;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CommandNamespace
extends SingleLineCommand2<ClassDiagram> {
    public CommandNamespace() {
        super(CommandNamespace.getRegexConcat());
    }

    private static RegexConcat getRegexConcat() {
        return new RegexConcat(new RegexLeaf("^namespace[%s]+"), new RegexLeaf("NAME", "([\\p{L}0-9_][\\p{L}0-9_.:\\\\]*)"), new RegexLeaf("[%s]*"), new RegexLeaf("STEREOTYPE", "(\\<\\<.*\\>\\>)?"), new RegexLeaf("[%s]*"), new RegexLeaf("URL", "(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*\\{$"));
    }

    @Override
    protected CommandExecutionResult executeArg(ClassDiagram classDiagram, RegexResult regexResult) {
        Object object;
        String string;
        Code code = Code.of(regexResult.get("NAME", 0));
        IGroup iGroup = classDiagram.getCurrentGroup();
        IGroup iGroup2 = classDiagram.getOrCreateNamespace(code, Display.getWithNewlines(code), GroupType.PACKAGE, iGroup);
        String string2 = regexResult.get("STEREOTYPE", 0);
        if (string2 != null) {
            iGroup2.setStereotype(new Stereotype(string2));
        }
        if ((string = regexResult.get("URL", 0)) != null) {
            object = new UrlBuilder(classDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            Url url = ((UrlBuilder)object).getUrl(string);
            iGroup2.addUrl(url);
        }
        if ((object = regexResult.get("COLOR", 0)) != null) {
            iGroup2.setSpecificColorTOBEREMOVED(ColorType.BACK, classDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid((String)object));
        }
        return CommandExecutionResult.ok();
    }
}

