/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*(note)[%s]+"), new RegexLeaf("CODE", "as[%s]+([\\p{L}0-9_.]+)"), new RegexLeaf("[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("DISPLAY", "[%g]([^%g]+)[%g][%s]+as[%s]+"), new RegexLeaf("CODE", "([\\p{L}0-9_.]+)[%s]*"), ColorParser.exp1(), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult) {
                String string = regexResult.get("DISPLAY", 0);
                return FactoryNoteCommand.this.executeInternal(abstractEntityDiagram, regexResult, BlocLines.getWithNewlines(string));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram abstractEntityDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                return FactoryNoteCommand.this.executeInternal(abstractEntityDiagram, regexResult, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult, BlocLines blocLines) {
        Code code = Code.of(regexResult.get("CODE", 0));
        if (abstractEntityDiagram.leafExist(code)) {
            return CommandExecutionResult.error("Note already created: " + code.getFullName());
        }
        ILeaf iLeaf = abstractEntityDiagram.createLeaf(code, blocLines.toDisplay(), LeafType.NOTE, null);
        assert (iLeaf != null);
        iLeaf.setSpecificColorTOBEREMOVED(ColorType.BACK, abstractEntityDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        return CommandExecutionResult.ok();
    }
}

