/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.classdiagram.AbstractEntityDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.IRegex;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexOr;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Code;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnEntityCommand
implements SingleMultiFactoryCommand<AbstractEntityDiagram> {
    private final IRegex partialPattern;

    public FactoryNoteOnEntityCommand(IRegex iRegex) {
        this.partialPattern = iRegex;
    }

    private RegexConcat getRegexConcatSingleLine(IRegex iRegex) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), iRegex), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    private RegexConcat getRegexConcatMultiLine(IRegex iRegex, boolean bl) {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)"), new RegexOr(new RegexConcat(new RegexLeaf("[%s]+of[%s]+"), iRegex), new RegexLeaf("")), new RegexLeaf("[%s]*"), FactoryNoteOnEntityCommand.color().getRegex(), new RegexLeaf("URL", "[%s]*(" + UrlBuilder.getRegexp() + ")?"), new RegexLeaf(bl ? "[%s]*\\{" : "[%s]*"), new RegexLeaf("$"));
    }

    @Override
    public Command<AbstractEntityDiagram> createSingleLine() {
        return new SingleLineCommand2<AbstractEntityDiagram>(this.getRegexConcatSingleLine(this.partialPattern)){

            @Override
            protected CommandExecutionResult executeArg(AbstractEntityDiagram abstractEntityDiagram, RegexResult regexResult) {
                String string = regexResult.get("NOTE", 0);
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, null, BlocLines.getWithNewlines(string));
            }
        };
    }

    @Override
    public Command<AbstractEntityDiagram> createMultiLine(final boolean bl) {
        return new CommandMultilines2<AbstractEntityDiagram>(this.getRegexConcatMultiLine(this.partialPattern, bl), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                if (bl) {
                    return "(?i)^(\\})$";
                }
                return "(?i)^[%s]*(end[%s]?note)$";
            }

            @Override
            public CommandExecutionResult executeNow(AbstractEntityDiagram abstractEntityDiagram, BlocLines blocLines) {
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                Url url = null;
                if (regexResult.get("URL", 0) != null) {
                    UrlBuilder urlBuilder = new UrlBuilder(abstractEntityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = urlBuilder.getUrl(regexResult.get("URL", 0));
                }
                return FactoryNoteOnEntityCommand.this.executeInternal(regexResult, abstractEntityDiagram, url, blocLines);
            }
        };
    }

    private CommandExecutionResult executeInternal(RegexResult regexResult, AbstractEntityDiagram abstractEntityDiagram, Url url, BlocLines blocLines) {
        Link link;
        IEntity iEntity;
        String string = regexResult.get("POSITION", 0);
        Code code = Code.of(regexResult.get("ENTITY", 0));
        if (code == null) {
            iEntity = abstractEntityDiagram.getLastEntity();
            if (iEntity == null) {
                return CommandExecutionResult.error("Nothing to note to");
            }
        } else {
            iEntity = abstractEntityDiagram.isGroup(code) ? abstractEntityDiagram.getGroup(code) : abstractEntityDiagram.getOrCreateLeaf(code, null, null);
        }
        ILeaf iLeaf = abstractEntityDiagram.createLeaf(UniqueSequence.getCode("GMN"), blocLines.toDisplay(), LeafType.NOTE, null);
        Colors colors = FactoryNoteOnEntityCommand.color().getColor(regexResult, abstractEntityDiagram.getSkinParam().getIHtmlColorSet());
        iLeaf.setColors(colors);
        if (url != null) {
            iLeaf.addUrl(url);
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(string)).withRankdir(abstractEntityDiagram.getSkinParam().getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity, iLeaf, linkType, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.LEFT) {
            link = new Link(iLeaf, iEntity, linkType, Display.NULL, 1);
            link.setHorizontalSolitary(true);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity, iLeaf, linkType, Display.NULL, 2);
        } else if (position == Position.TOP) {
            link = new Link(iLeaf, iEntity, linkType, Display.NULL, 2);
        } else {
            throw new IllegalArgumentException();
        }
        abstractEntityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

