/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleParser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockUtils;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UHorizontalLine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class CreoleHorizontalLine
implements Atom {
    private final FontConfiguration fontConfiguration;
    private final String line;
    private final char style;
    private final ISkinSimple skinParam;

    public static CreoleHorizontalLine create(FontConfiguration fontConfiguration, String string, char c, ISkinSimple iSkinSimple) {
        return new CreoleHorizontalLine(fontConfiguration, string, c, iSkinSimple);
    }

    private CreoleHorizontalLine(FontConfiguration fontConfiguration, String string, char c, ISkinSimple iSkinSimple) {
        this.fontConfiguration = fontConfiguration;
        this.line = string;
        this.style = c;
        this.skinParam = iSkinSimple;
    }

    private UHorizontalLine getHorizontalLine() {
        if (this.line.length() == 0) {
            return UHorizontalLine.infinite(0.0, 0.0, this.style);
        }
        TextBlock textBlock = this.getTitle();
        return UHorizontalLine.infinite(0.0, 0.0, textBlock, this.style);
    }

    private TextBlock getTitle() {
        if (this.line.length() == 0) {
            return TextBlockUtils.empty(0.0, 0.0);
        }
        CreoleParser creoleParser = new CreoleParser(this.fontConfiguration, HorizontalAlignment.LEFT, this.skinParam, CreoleMode.FULL);
        Sheet sheet = creoleParser.createSheet(Display.getWithNewlines(this.line));
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        return sheetBlock1;
    }

    public void drawU(UGraphic uGraphic) {
        Dimension2D dimension2D = this.calculateDimension(uGraphic.getStringBounder());
        uGraphic = uGraphic.apply(new UTranslate(0.0, dimension2D.getHeight() / 2.0));
        uGraphic.draw(this.getHorizontalLine());
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        if (this.line.length() == 0) {
            return new Dimension2DDouble(10.0, 10.0);
        }
        TextBlock textBlock = this.getTitle();
        return textBlock.calculateDimension(stringBounder);
    }

    public double getStartingAltitude(StringBounder stringBounder) {
        return 0.0;
    }
}

