/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.creole;

import java.util.Collections;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.creole.Atom;
import znaishaded.net.sourceforge.plantuml.creole.AtomTree;
import znaishaded.net.sourceforge.plantuml.creole.AtomWithMargin;
import znaishaded.net.sourceforge.plantuml.creole.CreoleContext;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.Stripe;
import znaishaded.net.sourceforge.plantuml.creole.StripeSimple;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyle;
import znaishaded.net.sourceforge.plantuml.creole.StripeStyleType;
import znaishaded.net.sourceforge.plantuml.creole.StripeTable;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StripeTree
implements Stripe {
    private FontConfiguration fontConfiguration;
    private final ISkinSimple skinParam;
    private final AtomTree tree;
    private final Atom marged;
    private final StripeStyle stripeStyle = new StripeStyle(StripeStyleType.TREE, 0, '\u0000');

    public StripeTree(FontConfiguration fontConfiguration, ISkinSimple iSkinSimple, String string) {
        this.fontConfiguration = fontConfiguration;
        this.skinParam = iSkinSimple;
        this.tree = new AtomTree(fontConfiguration.getColor());
        this.marged = new AtomWithMargin(this.tree, 2.0, 2.0);
        this.analyzeAndAdd(string);
    }

    @Override
    public List<Atom> getAtoms() {
        return Collections.singletonList(this.marged);
    }

    public void analyzeAndAdd(String string) {
        List<String> list = StripeTable.getWithNewlinesInternal(string);
        for (String string2 : list) {
            StripeSimple stripeSimple = new StripeSimple(this.fontConfiguration, this.stripeStyle, new CreoleContext(), this.skinParam, CreoleMode.FULL);
            String string3 = string2.replaceFirst("^\\s*\\|_", "");
            int n = (string2.length() - string3.length()) / 2;
            stripeSimple.analyzeAndAdd(string3);
            this.tree.addCell(StripeTable.asAtom(Collections.singletonList(stripeSimple), 0.0), n);
        }
    }
}

