/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.graph2;

import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import java.awt.geom.QuadCurve2D;
import java.util.ArrayList;
import java.util.List;
import znaishaded.net.sourceforge.plantuml.graph2.GeomUtils;

public class Polyline2 {
    private final List<Line2D.Double> lines = new ArrayList<Line2D.Double>();
    private Point2D lastCurrent;
    private final Point2D end;
    private boolean debug = false;

    public Polyline2(Point2D point2D, Point2D point2D2) {
        this.lastCurrent = point2D;
        this.end = point2D2;
    }

    public void addLine(Line2D.Double double_) {
        if (!this.lastCurrent.equals(double_.getP1())) {
            this.lines.add(new Line2D.Double(this.lastCurrent, double_.getP1()));
        }
        this.lines.add(double_);
        this.lastCurrent = double_.getP2();
    }

    public void draw(Graphics2D graphics2D) {
        this.close();
        if (this.debug) {
            graphics2D.setColor(Color.GREEN);
            this.drawDebug(graphics2D);
        }
        graphics2D.setColor(Color.BLUE);
        ArrayList<Point2D.Double> arrayList = new ArrayList<Point2D.Double>();
        for (Line2D.Double cloneable : this.lines) {
            arrayList.add(GeomUtils.getCenter(cloneable));
        }
        graphics2D.draw(new Line2D.Double(this.lines.get(0).getP1(), (Point2D)arrayList.get(0)));
        graphics2D.draw(new Line2D.Double((Point2D)arrayList.get(arrayList.size() - 1), this.end));
        for (int i = 0; i < this.lines.size() - 1; ++i) {
            Point2D point2D = (Point2D)arrayList.get(i);
            Point2D point2D2 = (Point2D)arrayList.get(i + 1);
            Point2D point2D3 = this.lines.get(i).getP2();
            assert (point2D3.equals(this.lines.get(i + 1).getP1()));
            QuadCurve2D.Double double_ = new QuadCurve2D.Double(point2D.getX(), point2D.getY(), point2D3.getX(), point2D3.getY(), point2D2.getX(), point2D2.getY());
            graphics2D.draw(double_);
        }
        if (this.debug) {
            for (Point2D.Double double_ : arrayList) {
                GeomUtils.fillPoint2D(graphics2D, double_);
            }
        }
    }

    private void drawDebug(Graphics2D graphics2D) {
        for (Line2D.Double double_ : this.lines) {
            graphics2D.draw(double_);
            GeomUtils.fillPoint2D(graphics2D, double_.getP1());
            GeomUtils.fillPoint2D(graphics2D, double_.getP2());
        }
    }

    private void close() {
        if (!this.lastCurrent.equals(this.end)) {
            this.lines.add(new Line2D.Double(this.lastCurrent, this.end));
        }
    }
}

