/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.svek.image;

import java.awt.geom.Dimension2D;
import java.awt.geom.Line2D;
import java.awt.geom.Point2D;
import znaishaded.net.sourceforge.plantuml.ColorParam;
import znaishaded.net.sourceforge.plantuml.Dimension2DDouble;
import znaishaded.net.sourceforge.plantuml.Direction;
import znaishaded.net.sourceforge.plantuml.FontParam;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.LineParam;
import znaishaded.net.sourceforge.plantuml.SkinParamBackcolored;
import znaishaded.net.sourceforge.plantuml.SkinParamUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.creole.Stencil;
import znaishaded.net.sourceforge.plantuml.cucadiagram.BodyEnhanced2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.ILeaf;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Stereotype;
import znaishaded.net.sourceforge.plantuml.graph2.GeomUtils;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlockEmpty;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;
import znaishaded.net.sourceforge.plantuml.posimo.DotPath;
import znaishaded.net.sourceforge.plantuml.skin.rose.Rose;
import znaishaded.net.sourceforge.plantuml.svek.AbstractEntityImage;
import znaishaded.net.sourceforge.plantuml.svek.Line;
import znaishaded.net.sourceforge.plantuml.svek.Shape;
import znaishaded.net.sourceforge.plantuml.svek.ShapeType;
import znaishaded.net.sourceforge.plantuml.svek.image.Opale;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeBackColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UChangeColor;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphic;
import znaishaded.net.sourceforge.plantuml.ugraphic.UGraphicStencil;
import znaishaded.net.sourceforge.plantuml.ugraphic.ULine;
import znaishaded.net.sourceforge.plantuml.ugraphic.UPolygon;
import znaishaded.net.sourceforge.plantuml.ugraphic.UStroke;
import znaishaded.net.sourceforge.plantuml.ugraphic.UTranslate;

public class EntityImageNote
extends AbstractEntityImage
implements Stencil {
    private final int cornersize = 10;
    private final HtmlColor noteBackgroundColor;
    private final HtmlColor borderColor;
    private final int marginX1 = 6;
    private final int marginX2 = 15;
    private final int marginY = 5;
    private final boolean withShadow;
    private final ISkinParam skinParam;
    private final TextBlock textBlock;
    private Line opaleLine;
    private Shape shape;
    private Shape other;

    public EntityImageNote(ILeaf iLeaf, ISkinParam iSkinParam) {
        super(iLeaf, EntityImageNote.getSkin(EntityImageNote.getISkinParam(iSkinParam, iLeaf), iLeaf));
        this.skinParam = EntityImageNote.getISkinParam(iSkinParam, iLeaf);
        this.withShadow = this.getSkinParam().shadowing();
        Display display = iLeaf.getDisplay();
        Rose rose = new Rose();
        this.noteBackgroundColor = iLeaf.getColors(this.getSkinParam()).getColor(ColorType.BACK) == null ? rose.getHtmlColor(this.getSkinParam(), ColorParam.noteBackground) : iLeaf.getColors(this.getSkinParam()).getColor(ColorType.BACK);
        this.borderColor = SkinParamUtils.getColor(this.getSkinParam(), ColorParam.noteBorder, null);
        this.textBlock = display.size() == 1 && display.get(0).length() == 0 ? new TextBlockEmpty() : new BodyEnhanced2(display, FontParam.NOTE, this.getSkinParam(), HorizontalAlignment.LEFT, new FontConfiguration(this.getSkinParam(), FontParam.NOTE, null));
    }

    private static ISkinParam getISkinParam(ISkinParam iSkinParam, IEntity iEntity) {
        if (iEntity.getColors(iSkinParam) != null) {
            return iEntity.getColors(iSkinParam).mute(iSkinParam);
        }
        return iSkinParam;
    }

    static ISkinParam getSkin(ISkinParam iSkinParam, IEntity iEntity) {
        Stereotype stereotype = iEntity.getStereotype();
        HtmlColor htmlColor = iEntity.getColors(iSkinParam).getColor(ColorType.BACK);
        if (htmlColor != null) {
            return new SkinParamBackcolored(iSkinParam, htmlColor);
        }
        htmlColor = EntityImageNote.getColorStatic(iSkinParam, ColorParam.noteBackground, stereotype);
        if (htmlColor != null) {
            return new SkinParamBackcolored(iSkinParam, htmlColor);
        }
        return iSkinParam;
    }

    private static HtmlColor getColorStatic(ISkinParam iSkinParam, ColorParam colorParam, Stereotype stereotype) {
        Rose rose = new Rose();
        return rose.getHtmlColor(iSkinParam, colorParam, stereotype);
    }

    public final double getPreferredWidth(StringBounder stringBounder) {
        double d = this.getTextWidth(stringBounder);
        return d;
    }

    public final double getPreferredHeight(StringBounder stringBounder) {
        return this.getTextHeight(stringBounder);
    }

    private Dimension2D getSize(StringBounder stringBounder, TextBlock textBlock) {
        return textBlock.calculateDimension(stringBounder);
    }

    protected final double getTextHeight(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getHeight() + 10.0;
    }

    protected final TextBlock getTextBlock() {
        return this.textBlock;
    }

    protected final double getPureTextWidth(StringBounder stringBounder) {
        TextBlock textBlock = this.getTextBlock();
        Dimension2D dimension2D = this.getSize(stringBounder, textBlock);
        return dimension2D.getWidth();
    }

    public final double getTextWidth(StringBounder stringBounder) {
        return this.getPureTextWidth(stringBounder) + 6.0 + 15.0;
    }

    public Dimension2D calculateDimension(StringBounder stringBounder) {
        double d = this.getPreferredHeight(stringBounder);
        double d2 = this.getPreferredWidth(stringBounder);
        return new Dimension2DDouble(d2, d);
    }

    public final void drawU(UGraphic uGraphic) {
        Url url = this.getEntity().getUrl99();
        if (url != null) {
            uGraphic.startUrl(url);
        }
        UGraphic uGraphic2 = UGraphicStencil.create(uGraphic, this, new UStroke());
        if (this.opaleLine == null || !this.opaleLine.isOpale()) {
            this.drawNormal(uGraphic2);
        } else {
            StringBounder stringBounder = uGraphic.getStringBounder();
            DotPath dotPath = this.opaleLine.getDotPath();
            dotPath.moveSvek(-this.shape.getMinX(), -this.shape.getMinY());
            Point2D point2D = dotPath.getStartPoint();
            Point2D point2D2 = dotPath.getEndPoint();
            double d = this.getTextWidth(stringBounder);
            double d2 = this.getTextHeight(stringBounder);
            Point2D.Double double_ = new Point2D.Double(d / 2.0, d2 / 2.0);
            if (point2D.distance(double_) > point2D2.distance(double_)) {
                dotPath = dotPath.reverse();
                point2D = dotPath.getStartPoint();
            }
            Direction direction = this.getOpaleStrategy(d, d2, point2D);
            Point2D point2D3 = dotPath.getStartPoint();
            Point2D point2D4 = dotPath.getEndPoint();
            Point2D point2D5 = EntityImageNote.move(point2D4, this.shape.getMinX(), this.shape.getMinY());
            Point2D point2D6 = EntityImageNote.move(this.other.projection(point2D5, stringBounder), -this.shape.getMinX(), -this.shape.getMinY());
            Opale opale = new Opale(this.borderColor, this.noteBackgroundColor, this.textBlock, this.skinParam.shadowing(), true);
            opale.setOpale(direction, point2D3, point2D6);
            UGraphic uGraphic3 = this.applyStroke(uGraphic2);
            opale.drawU(Colors.applyStroke(uGraphic3, this.getEntity().getColors(this.skinParam)));
        }
        if (url != null) {
            uGraphic.closeAction();
        }
    }

    private static Point2D move(Point2D point2D, double d, double d2) {
        return new Point2D.Double(point2D.getX() + d, point2D.getY() + d2);
    }

    private void drawNormal(UGraphic uGraphic) {
        StringBounder stringBounder = uGraphic.getStringBounder();
        UPolygon uPolygon = this.getPolygonNormal(stringBounder);
        if (this.withShadow) {
            uPolygon.setDeltaShadow(4.0);
        }
        uGraphic = uGraphic.apply(new UChangeBackColor(this.noteBackgroundColor)).apply(new UChangeColor(this.borderColor));
        UGraphic uGraphic2 = this.applyStroke(uGraphic);
        uGraphic2.draw(uPolygon);
        uGraphic2.apply(new UTranslate(this.getTextWidth(stringBounder) - 10.0, 0.0)).draw(new ULine(0.0, 10.0));
        uGraphic2.apply(new UTranslate(this.getTextWidth(stringBounder), 10.0)).draw(new ULine(-10.0, 0.0));
        this.getTextBlock().drawU(uGraphic.apply(new UTranslate(6.0, 5.0)));
    }

    private UGraphic applyStroke(UGraphic uGraphic) {
        UStroke uStroke = this.skinParam.getThickness(LineParam.noteBorder, null);
        if (uStroke == null) {
            return uGraphic;
        }
        return uGraphic.apply(uStroke);
    }

    private UPolygon getPolygonNormal(StringBounder stringBounder) {
        UPolygon uPolygon = new UPolygon();
        uPolygon.addPoint(0.0, 0.0);
        uPolygon.addPoint(0.0, this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), this.getTextHeight(stringBounder));
        uPolygon.addPoint(this.getTextWidth(stringBounder), 10.0);
        uPolygon.addPoint(this.getTextWidth(stringBounder) - 10.0, 0.0);
        uPolygon.addPoint(0.0, 0.0);
        return uPolygon;
    }

    private Direction getOpaleStrategy(double d, double d2, Point2D point2D) {
        double d3 = GeomUtils.getOrthoDistance(new Line2D.Double(d, 0.0, d, d2), point2D);
        double d4 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, d2, d, d2), point2D);
        double d5 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, 0.0, d2), point2D);
        double d6 = GeomUtils.getOrthoDistance(new Line2D.Double(0.0, 0.0, d, 0.0), point2D);
        if (d5 <= d3 && d5 <= d4 && d5 <= d6) {
            return Direction.LEFT;
        }
        if (d3 <= d4 && d3 <= d5 && d3 <= d6) {
            return Direction.RIGHT;
        }
        if (d6 <= d3 && d6 <= d4 && d6 <= d5) {
            return Direction.UP;
        }
        if (d4 <= d3 && d4 <= d5 && d4 <= d6) {
            return Direction.DOWN;
        }
        return null;
    }

    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    public void setOpaleLine(Line line, Shape shape, Shape shape2) {
        if (shape2 == null) {
            throw new IllegalArgumentException();
        }
        this.opaleLine = line;
        this.shape = shape;
        this.other = shape2;
    }

    public double getStartingX(StringBounder stringBounder, double d) {
        return 0.0;
    }

    public double getEndingX(StringBounder stringBounder, double d) {
        return this.calculateDimension(stringBounder).getWidth();
    }
}

