/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.ugraphic.visio;

import java.io.IOException;
import java.io.OutputStream;
import znaishaded.net.sourceforge.plantuml.ugraphic.visio.VisioShape;

public class VisioLine
implements VisioShape {
    private final int id;
    private final double x1;
    private final double y1;
    private final double x2;
    private final double y2;

    public static VisioLine createInches(int n, double d, double d2, double d3, double d4) {
        return new VisioLine(n, VisioLine.toInches(d), VisioLine.toInches(d2), VisioLine.toInches(d3), VisioLine.toInches(d4));
    }

    private VisioLine(int n, double d, double d2, double d3, double d4) {
        if (d < 0.0 || d2 < 0.0 || d3 < 0.0 || d4 < 0.0) {
            throw new IllegalArgumentException();
        }
        this.id = n;
        this.x1 = d;
        this.y1 = d2;
        this.x2 = d3;
        this.y2 = d4;
    }

    public VisioShape yReverse(double d) {
        return new VisioLine(this.id, this.x1, d - this.y1, this.x2, d - this.y2);
    }

    private static double toInches(double d) {
        return d / 72.0;
    }

    public void print(OutputStream outputStream) throws IOException {
        this.out(outputStream, "<Shape ID='" + this.id + "' Type='Shape' LineStyle='3' FillStyle='3' TextStyle='3'>");
        this.out(outputStream, "<XForm>");
        double d = this.x2 - this.x1;
        double d2 = this.y2 - this.y1;
        this.out(outputStream, "<PinX F='(BeginX+EndX)/2'>" + (this.x1 + this.x2) / 2.0 + "</PinX>");
        this.out(outputStream, "<PinY F='(BeginY+EndY)/2'>" + (this.y1 + this.y2) / 2.0 + "</PinY>");
        double d3 = Math.sqrt(d * d + d2 * d2);
        this.out(outputStream, "<Width F='Sqrt((EndX-BeginX)^2+(EndY-BeginY)^2)'>" + d3 + "</Width>");
        this.out(outputStream, "<Height>0</Height>");
        this.out(outputStream, "<LocPinX F='Width*0.5'>" + d3 / 2.0 + "</LocPinX>");
        this.out(outputStream, "<LocPinY F='Height*0.5'>0</LocPinY>");
        double d4 = Math.atan2(d2, d);
        this.out(outputStream, "<Angle F='ATan2(EndY-BeginY,EndX-BeginX)'>" + d4 + "</Angle>");
        this.out(outputStream, "<FlipX>0</FlipX>");
        this.out(outputStream, "<FlipY>0</FlipY>");
        this.out(outputStream, "<ResizeMode>0</ResizeMode>");
        this.out(outputStream, "</XForm>");
        this.out(outputStream, "<XForm1D>");
        this.out(outputStream, "<BeginX>" + this.x1 + "</BeginX>");
        this.out(outputStream, "<BeginY>" + this.y1 + "</BeginY>");
        this.out(outputStream, "<EndX>" + this.x2 + "</EndX>");
        this.out(outputStream, "<EndY>" + this.y2 + "</EndY>");
        this.out(outputStream, "</XForm1D>");
        this.out(outputStream, "<Geom IX='0'>");
        this.out(outputStream, "<NoFill>1</NoFill>");
        this.out(outputStream, "<NoLine>0</NoLine>");
        this.out(outputStream, "<NoShow>0</NoShow>");
        this.out(outputStream, "<NoSnap>0</NoSnap>");
        this.out(outputStream, "<MoveTo IX='1'>");
        this.out(outputStream, "<X F='Width*0'>0</X>");
        this.out(outputStream, "<Y>0</Y>");
        this.out(outputStream, "</MoveTo>");
        this.out(outputStream, "<LineTo IX='2'>");
        this.out(outputStream, "<X F='Width*1'>" + d3 + "</X>");
        this.out(outputStream, "<Y>0</Y>");
        this.out(outputStream, "</LineTo>");
        this.out(outputStream, "</Geom>");
        this.out(outputStream, "</Shape>");
    }

    private void out(OutputStream outputStream, String string) throws IOException {
        outputStream.write(string.getBytes());
        outputStream.write("\n".getBytes());
    }
}

