/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.client.upload;

import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;

public class UploadPathValidator {
    private static final long MAX_MB_COUNT = 40L;
    private static final long MB = 1000000L;
    private static final long MAX_SIZE = 40000000L;

    public static void validate(Path path2, String file) {
        if (!Files.exists(path2.resolve(file), new LinkOption[0])) {
            throw new RuntimeException(String.format("no %s found in %s", file, path2.toString()));
        }
        ConsoleOutputs.out(new Object[]{Color.BLUE, "validating size of ", Color.PURPLE, path2});
        long size = UploadPathValidator.getSize(path2);
        if (size > 40000000L) {
            throw new RuntimeException(String.format("upload documentation size should be less than %dMb, received: %d(%s)", 40L, size, UploadPathValidator.humanReadable(size)));
        }
    }

    private static String humanReadable(long size) {
        return String.format("%.2fMb", (double)size / 1000000.0);
    }

    private static long getSize(Path path2) {
        try {
            return Files.walk(path2, new FileVisitOption[0]).filter(p -> p.toFile().isFile()).mapToLong(p -> p.toFile().length()).sum();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

