/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.enterprise.monitoring;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.testingisdocumenting.znai.console.ConsoleOutputs;
import org.testingisdocumenting.znai.console.ansi.Color;
import org.testingisdocumenting.znai.enterprise.DocLifecycleListeners;
import org.testingisdocumenting.znai.enterprise.EnterpriseComponentsRegistry;
import org.testingisdocumenting.znai.enterprise.monitoring.FilesFinder;
import org.testingisdocumenting.znai.enterprise.monitoring.MonitorConfig;
import org.testingisdocumenting.znai.fs.FsUtils;
import org.testingisdocumenting.znai.server.ServerLifecycleListener;
import org.testingisdocumenting.znai.server.ZnaiServerConfig;
import org.testingisdocumenting.znai.structure.DocMeta;
import org.testingisdocumenting.znai.utils.FileUtils;
import org.testingisdocumenting.znai.utils.JsonUtils;
import znaishaded.org.apache.commons.codec.digest.DigestUtils;

public class BuildOutputMonitor
implements ServerLifecycleListener {
    private final ScheduledExecutorService executorService = Executors.newSingleThreadScheduledExecutor();
    private final FilesFinder filesFinder;
    private final MonitorConfig monitorConfig;
    private final Map<Path, String> checkSumByPath;

    public BuildOutputMonitor() {
        this(BuildOutputMonitor.parseMonitoringConfig());
    }

    public BuildOutputMonitor(MonitorConfig monitorConfig) {
        this.filesFinder = new FilesFinder(monitorConfig.getBuildRootsAndPatterns());
        this.monitorConfig = monitorConfig;
        this.checkSumByPath = new HashMap<Path, String>();
    }

    @Override
    public void beforeStart(ZnaiServerConfig config) {
        this.start();
    }

    public void start() {
        this.executorService.scheduleAtFixedRate(this::scan, 0L, this.monitorConfig.getIntervalMillis(), TimeUnit.MILLISECONDS);
    }

    private void scan() {
        List<Path> found = this.filesFinder.find();
        found.stream().filter(this::isChecksumDifferentAndUpdate).forEach(this::process);
    }

    private void process(Path zip) {
        try {
            this.unzipAndStore(zip);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unzipAndStore(Path zip) {
        Path tempDir = FsUtils.createTempDir("znai-unzipped-doc");
        try {
            FsUtils.unzip(zip, tempDir);
            Path docsDir = BuildOutputMonitor.listFiles(tempDir).filter(x$0 -> Files.isDirectory(x$0, new LinkOption[0])).findFirst().orElseThrow(() -> new RuntimeException("no directory found inside zip"));
            String docId = docsDir.getFileName().toString();
            ConsoleOutputs.out(new Object[]{"detected ", Color.WHITE, docId, Color.BLUE, " at ", Color.PURPLE, zip});
            EnterpriseComponentsRegistry.documentationStorage().store("build-output-monitor", docId, "", docsDir);
            DocLifecycleListeners.onDocUpdate(new DocMeta(FileUtils.fileTextContent(docsDir.resolve("meta.json"))));
        }
        finally {
            FsUtils.deleteDirectory(tempDir);
        }
    }

    private boolean isChecksumDifferentAndUpdate(Path path2) {
        String previousCheckSum = this.checkSumByPath.get(path2);
        String newCheckSum = this.checkSum(path2);
        this.checkSumByPath.put(path2, newCheckSum);
        if (previousCheckSum == null) {
            return true;
        }
        return !previousCheckSum.equals(newCheckSum);
    }

    private String checkSum(Path path2) {
        try {
            return DigestUtils.md5Hex(Files.newInputStream(path2, new OpenOption[0]));
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static Stream<Path> listFiles(Path dir) {
        try {
            return Files.list(dir);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private static MonitorConfig parseMonitoringConfig() {
        Path fsMonitorConfigPath = EnterpriseComponentsRegistry.enterpriseConfig().getFsMonitorConfigPath();
        if (!Files.exists(fsMonitorConfigPath, new LinkOption[0])) {
            return new MonitorConfig(Collections.emptyMap());
        }
        Map<String, Object> config = JsonUtils.deserializeAsMap(FileUtils.fileTextContent(fsMonitorConfigPath));
        return new MonitorConfig(config);
    }
}

