/*
 * Decompiled with CFR 0.152.
 */
package org.testingisdocumenting.znai.extensions.api;

import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import org.testingisdocumenting.znai.extensions.api.ApiParameter;
import org.testingisdocumenting.znai.extensions.api.ApiParameters;
import org.testingisdocumenting.znai.parser.MarkupParser;
import org.testingisdocumenting.znai.utils.JsonUtils;

public class ApiParametersJsonParser {
    private final ApiParameters apiParameters;
    private final MarkupParser markupParser;
    private final List<Map<String, Object>> json;
    private final Path path;

    public static ApiParameters parse(MarkupParser markupParser, String jsonContent) {
        return new ApiParametersJsonParser(markupParser, jsonContent).parse();
    }

    private ApiParametersJsonParser(MarkupParser markupParser, String jsonContent) {
        this.markupParser = markupParser;
        this.json = JsonUtils.deserializeAsList(jsonContent);
        this.apiParameters = new ApiParameters();
        this.path = Paths.get("", new String[0]);
    }

    public ApiParameters parse() {
        this.json.forEach(p -> this.parseParam(this.apiParameters.getRoot(), (Map<String, Object>)p));
        return this.apiParameters;
    }

    private void parseParam(ApiParameter current, Map<String, Object> param) {
        ApiParameter apiParameter = current.add(param.get("name").toString(), param.get("type").toString(), this.markupParser.parse(this.path, param.get("description").toString()).contentToListOfMaps());
        Object children = param.get("children");
        if (children != null) {
            List list = (List)children;
            list.forEach(p -> this.parseParam(apiParameter, (Map<String, Object>)p));
        }
    }
}

