/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.jayway.jsonpath.internal.filter;

import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import znaishaded.com.jayway.jsonpath.Configuration;
import znaishaded.com.jayway.jsonpath.InvalidPathException;
import znaishaded.com.jayway.jsonpath.JsonPathException;
import znaishaded.com.jayway.jsonpath.Option;
import znaishaded.com.jayway.jsonpath.PathNotFoundException;
import znaishaded.com.jayway.jsonpath.Predicate;
import znaishaded.com.jayway.jsonpath.internal.Path;
import znaishaded.com.jayway.jsonpath.internal.Utils;
import znaishaded.com.jayway.jsonpath.internal.path.PathCompiler;
import znaishaded.com.jayway.jsonpath.internal.path.PredicateContextImpl;
import znaishaded.com.jayway.jsonpath.spi.json.JsonProvider;
import znaishaded.net.minidev.json.parser.JSONParser;
import znaishaded.net.minidev.json.parser.ParseException;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public abstract class ValueNode {
    public static final NullNode NULL_NODE = new NullNode();
    public static final BooleanNode TRUE = new BooleanNode("true");
    public static final BooleanNode FALSE = new BooleanNode("false");
    public static final UndefinedNode UNDEFINED = new UndefinedNode();

    public abstract Class<?> type(Predicate.PredicateContext var1);

    public boolean isPatternNode() {
        return false;
    }

    public PatternNode asPatternNode() {
        throw new InvalidPathException("Expected regexp node");
    }

    public boolean isPathNode() {
        return false;
    }

    public PathNode asPathNode() {
        throw new InvalidPathException("Expected path node");
    }

    public boolean isNumberNode() {
        return false;
    }

    public NumberNode asNumberNode() {
        throw new InvalidPathException("Expected number node");
    }

    public boolean isStringNode() {
        return false;
    }

    public StringNode asStringNode() {
        throw new InvalidPathException("Expected string node");
    }

    public boolean isBooleanNode() {
        return false;
    }

    public BooleanNode asBooleanNode() {
        throw new InvalidPathException("Expected boolean node");
    }

    public boolean isJsonNode() {
        return false;
    }

    public JsonNode asJsonNode() {
        throw new InvalidPathException("Expected json node");
    }

    public boolean isPredicateNode() {
        return false;
    }

    public PredicateNode asPredicateNode() {
        throw new InvalidPathException("Expected predicate node");
    }

    public boolean isValueListNode() {
        return false;
    }

    public ValueListNode asValueListNode() {
        throw new InvalidPathException("Expected value list node");
    }

    public boolean isNullNode() {
        return false;
    }

    public NullNode asNullNode() {
        throw new InvalidPathException("Expected null node");
    }

    public UndefinedNode asUndefinedNode() {
        throw new InvalidPathException("Expected undefined node");
    }

    public boolean isUndefinedNode() {
        return false;
    }

    public boolean isClassNode() {
        return false;
    }

    public ClassNode asClassNode() {
        throw new InvalidPathException("Expected class node");
    }

    private static boolean isPath(Object o) {
        if (o == null || !(o instanceof String)) {
            return false;
        }
        String str = o.toString().trim();
        if (str.length() <= 0) {
            return false;
        }
        char c0 = str.charAt(0);
        if (c0 == '@' || c0 == '$') {
            try {
                PathCompiler.compile(str, new Predicate[0]);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    private static boolean isJson(Object o) {
        if (o == null || !(o instanceof String)) {
            return false;
        }
        String str = o.toString().trim();
        if (str.length() <= 1) {
            return false;
        }
        char c0 = str.charAt(0);
        char c1 = str.charAt(str.length() - 1);
        if (c0 == '[' && c1 == ']' || c0 == '{' && c1 == '}') {
            try {
                new JSONParser(-1).parse(str);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
        return false;
    }

    public static ValueNode toValueNode(Object o) {
        if (o == null) {
            return NULL_NODE;
        }
        if (o instanceof ValueNode) {
            return (ValueNode)o;
        }
        if (o instanceof Class) {
            return ValueNode.createClassNode((Class)o);
        }
        if (ValueNode.isPath(o)) {
            return new PathNode(o.toString(), false, false);
        }
        if (ValueNode.isJson(o)) {
            return ValueNode.createJsonNode(o.toString());
        }
        if (o instanceof String) {
            return ValueNode.createStringNode(o.toString(), true);
        }
        if (o instanceof Character) {
            return ValueNode.createStringNode(o.toString(), false);
        }
        if (o instanceof Number) {
            return ValueNode.createNumberNode(o.toString());
        }
        if (o instanceof Boolean) {
            return ValueNode.createBooleanNode(o.toString());
        }
        if (o instanceof Pattern) {
            return ValueNode.createPatternNode((Pattern)o);
        }
        throw new JsonPathException("Could not determine value type");
    }

    public static StringNode createStringNode(CharSequence charSequence, boolean escape) {
        return new StringNode(charSequence, escape);
    }

    public static ClassNode createClassNode(Class<?> clazz) {
        return new ClassNode(clazz);
    }

    public static NumberNode createNumberNode(CharSequence charSequence) {
        return new NumberNode(charSequence);
    }

    public static BooleanNode createBooleanNode(CharSequence charSequence) {
        return Boolean.parseBoolean(charSequence.toString()) ? TRUE : FALSE;
    }

    public static NullNode createNullNode() {
        return NULL_NODE;
    }

    public static JsonNode createJsonNode(CharSequence json) {
        return new JsonNode(json);
    }

    public static JsonNode createJsonNode(Object parsedJson) {
        return new JsonNode(parsedJson);
    }

    public static PatternNode createPatternNode(CharSequence pattern) {
        return new PatternNode(pattern);
    }

    public static PatternNode createPatternNode(Pattern pattern) {
        return new PatternNode(pattern);
    }

    public static UndefinedNode createUndefinedNode() {
        return UNDEFINED;
    }

    public static PathNode createPathNode(CharSequence path2, boolean existsCheck, boolean shouldExists) {
        return new PathNode(path2, existsCheck, shouldExists);
    }

    public static ValueNode createPathNode(Path path2) {
        return new PathNode(path2);
    }

    public static class PathNode
    extends ValueNode {
        private static final Logger logger = LoggerFactory.getLogger(PathNode.class);
        private final Path path;
        private final boolean existsCheck;
        private final boolean shouldExist;

        PathNode(Path path2) {
            this(path2, false, false);
        }

        PathNode(CharSequence charSequence, boolean existsCheck, boolean shouldExist) {
            this(PathCompiler.compile(charSequence.toString(), new Predicate[0]), existsCheck, shouldExist);
        }

        PathNode(Path path2, boolean existsCheck, boolean shouldExist) {
            this.path = path2;
            this.existsCheck = existsCheck;
            this.shouldExist = shouldExist;
            logger.trace("PathNode {} existsCheck: {}", (Object)path2, (Object)existsCheck);
        }

        public Path getPath() {
            return this.path;
        }

        public boolean isExistsCheck() {
            return this.existsCheck;
        }

        public boolean shouldExists() {
            return this.shouldExist;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isPathNode() {
            return true;
        }

        @Override
        public PathNode asPathNode() {
            return this;
        }

        public PathNode asExistsCheck(boolean shouldExist) {
            return new PathNode(this.path, true, shouldExist);
        }

        public String toString() {
            return this.existsCheck && !this.shouldExist ? Utils.concat("!", this.path.toString()) : this.path.toString();
        }

        public ValueNode evaluate(Predicate.PredicateContext ctx) {
            if (this.isExistsCheck()) {
                try {
                    Configuration c = Configuration.builder().jsonProvider(ctx.configuration().jsonProvider()).options(Option.REQUIRE_PROPERTIES).build();
                    Object result = this.path.evaluate(ctx.item(), ctx.root(), c).getValue(false);
                    return result == JsonProvider.UNDEFINED ? FALSE : TRUE;
                }
                catch (PathNotFoundException e) {
                    return FALSE;
                }
            }
            try {
                Object res;
                if (ctx instanceof PredicateContextImpl) {
                    PredicateContextImpl ctxi = (PredicateContextImpl)ctx;
                    res = ctxi.evaluate(this.path);
                } else {
                    Object doc = this.path.isRootPath() ? ctx.root() : ctx.item();
                    res = this.path.evaluate(doc, ctx.root(), ctx.configuration()).getValue();
                }
                res = ctx.configuration().jsonProvider().unwrap(res);
                if (res instanceof Number) {
                    return ValueNode.createNumberNode(res.toString());
                }
                if (res instanceof BigDecimal) {
                    return ValueNode.createNumberNode(res.toString());
                }
                if (res instanceof String) {
                    return ValueNode.createStringNode(res.toString(), false);
                }
                if (res instanceof Boolean) {
                    return ValueNode.createBooleanNode(res.toString());
                }
                if (res == null) {
                    return NULL_NODE;
                }
                if (ctx.configuration().jsonProvider().isArray(res)) {
                    return ValueNode.createJsonNode(res);
                }
                if (ctx.configuration().jsonProvider().isMap(res)) {
                    return ValueNode.createJsonNode(res);
                }
                throw new JsonPathException("Could not convert " + res.toString() + " to a ValueNode");
            }
            catch (PathNotFoundException e) {
                return UNDEFINED;
            }
        }
    }

    public static class ValueListNode
    extends ValueNode
    implements Iterable<ValueNode> {
        private List<ValueNode> nodes = new ArrayList<ValueNode>();

        public ValueListNode(Collection<?> values) {
            for (Object value : values) {
                this.nodes.add(ValueListNode.toValueNode(value));
            }
        }

        public boolean contains(ValueNode node) {
            return this.nodes.contains(node);
        }

        public boolean subsetof(ValueListNode right) {
            for (ValueNode leftNode : this.nodes) {
                if (right.nodes.contains(leftNode)) continue;
                return false;
            }
            return true;
        }

        public List<ValueNode> getNodes() {
            return Collections.unmodifiableList(this.nodes);
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return List.class;
        }

        @Override
        public boolean isValueListNode() {
            return true;
        }

        @Override
        public ValueListNode asValueListNode() {
            return this;
        }

        public String toString() {
            return "[" + Utils.join(",", this.nodes) + "]";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ValueListNode)) {
                return false;
            }
            ValueListNode that = (ValueListNode)o;
            return !(that == null ? that.nodes != null : !this.nodes.equals(that.nodes));
        }

        @Override
        public Iterator<ValueNode> iterator() {
            return this.nodes.iterator();
        }
    }

    public static class PredicateNode
    extends ValueNode {
        private final Predicate predicate;

        public PredicateNode(Predicate predicate) {
            this.predicate = predicate;
        }

        public Predicate getPredicate() {
            return this.predicate;
        }

        @Override
        public PredicateNode asPredicateNode() {
            return this;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isPredicateNode() {
            return true;
        }

        public boolean equals(Object o) {
            return false;
        }

        public String toString() {
            return this.predicate.toString();
        }
    }

    public static class UndefinedNode
    extends ValueNode {
        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public UndefinedNode asUndefinedNode() {
            return this;
        }

        @Override
        public boolean isUndefinedNode() {
            return true;
        }

        public boolean equals(Object o) {
            return false;
        }
    }

    public static class NullNode
    extends ValueNode {
        private NullNode() {
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.class;
        }

        @Override
        public boolean isNullNode() {
            return true;
        }

        @Override
        public NullNode asNullNode() {
            return this;
        }

        public String toString() {
            return "null";
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            return o instanceof NullNode;
        }
    }

    public static class ClassNode
    extends ValueNode {
        private final Class clazz;

        private ClassNode(Class clazz) {
            this.clazz = clazz;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Class.class;
        }

        @Override
        public boolean isClassNode() {
            return true;
        }

        @Override
        public ClassNode asClassNode() {
            return this;
        }

        public Class getClazz() {
            return this.clazz;
        }

        public String toString() {
            return this.clazz.getName();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassNode)) {
                return false;
            }
            ClassNode that = (ClassNode)o;
            return !(this.clazz == null ? that.clazz != null : !this.clazz.equals(that.clazz));
        }
    }

    public static class BooleanNode
    extends ValueNode {
        private final Boolean value;

        private BooleanNode(CharSequence boolValue) {
            this.value = Boolean.parseBoolean(boolValue.toString());
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Boolean.class;
        }

        @Override
        public boolean isBooleanNode() {
            return true;
        }

        @Override
        public BooleanNode asBooleanNode() {
            return this;
        }

        public boolean getBoolean() {
            return this.value;
        }

        public String toString() {
            return this.value.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof BooleanNode)) {
                return false;
            }
            BooleanNode that = (BooleanNode)o;
            return !(this.value == null ? that.value != null : !this.value.equals(that.value));
        }
    }

    public static class NumberNode
    extends ValueNode {
        public static NumberNode NAN = new NumberNode((BigDecimal)null);
        private final BigDecimal number;

        private NumberNode(BigDecimal number) {
            this.number = number;
        }

        private NumberNode(CharSequence num) {
            this.number = new BigDecimal(num.toString());
        }

        @Override
        public StringNode asStringNode() {
            return new StringNode(this.number.toString(), false);
        }

        public BigDecimal getNumber() {
            return this.number;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Number.class;
        }

        @Override
        public boolean isNumberNode() {
            return true;
        }

        @Override
        public NumberNode asNumberNode() {
            return this;
        }

        public String toString() {
            return this.number.toString();
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof NumberNode) && !(o instanceof StringNode)) {
                return false;
            }
            NumberNode that = ((ValueNode)o).asNumberNode();
            if (that == NAN) {
                return false;
            }
            return this.number.compareTo(that.number) == 0;
        }
    }

    public static class StringNode
    extends ValueNode {
        private final String string;
        private boolean useSingleQuote = true;

        private StringNode(CharSequence charSequence, boolean escape) {
            if (charSequence.length() > 1) {
                char open = charSequence.charAt(0);
                char close = charSequence.charAt(charSequence.length() - 1);
                if (open == '\'' && close == '\'') {
                    charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                } else if (open == '\"' && close == '\"') {
                    charSequence = charSequence.subSequence(1, charSequence.length() - 1);
                    this.useSingleQuote = false;
                }
            }
            this.string = escape ? Utils.unescape(charSequence.toString()) : charSequence.toString();
        }

        @Override
        public NumberNode asNumberNode() {
            BigDecimal number = null;
            try {
                number = new BigDecimal(this.string);
            }
            catch (NumberFormatException nfe) {
                return NumberNode.NAN;
            }
            return new NumberNode(number);
        }

        public String getString() {
            return this.string;
        }

        public int length() {
            return this.getString().length();
        }

        public boolean isEmpty() {
            return this.getString().isEmpty();
        }

        public boolean contains(String str) {
            return this.getString().contains(str);
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return String.class;
        }

        @Override
        public boolean isStringNode() {
            return true;
        }

        @Override
        public StringNode asStringNode() {
            return this;
        }

        public String toString() {
            String quote = this.useSingleQuote ? "'" : "\"";
            return quote + Utils.escape(this.string, true) + quote;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof StringNode) && !(o instanceof NumberNode)) {
                return false;
            }
            StringNode that = ((ValueNode)o).asStringNode();
            return !(this.string == null ? that.getString() != null : !this.string.equals(that.getString()));
        }
    }

    public static class JsonNode
    extends ValueNode {
        private final Object json;
        private final boolean parsed;

        private JsonNode(CharSequence charSequence) {
            this.json = charSequence.toString();
            this.parsed = false;
        }

        public JsonNode(Object parsedJson) {
            this.json = parsedJson;
            this.parsed = true;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            if (this.isArray(ctx)) {
                return List.class;
            }
            if (this.isMap(ctx)) {
                return Map.class;
            }
            if (this.parse(ctx) instanceof Number) {
                return Number.class;
            }
            if (this.parse(ctx) instanceof String) {
                return String.class;
            }
            if (this.parse(ctx) instanceof Boolean) {
                return Boolean.class;
            }
            return Void.class;
        }

        @Override
        public boolean isJsonNode() {
            return true;
        }

        @Override
        public JsonNode asJsonNode() {
            return this;
        }

        public ValueNode asValueListNode(Predicate.PredicateContext ctx) {
            if (!this.isArray(ctx)) {
                return UNDEFINED;
            }
            return new ValueListNode(Collections.unmodifiableList((List)this.parse(ctx)));
        }

        public Object parse(Predicate.PredicateContext ctx) {
            try {
                return this.parsed ? this.json : new JSONParser(-1).parse(this.json.toString());
            }
            catch (ParseException e) {
                throw new IllegalArgumentException(e);
            }
        }

        public boolean isParsed() {
            return this.parsed;
        }

        public Object getJson() {
            return this.json;
        }

        public boolean isArray(Predicate.PredicateContext ctx) {
            return ctx.configuration().jsonProvider().isArray(this.parse(ctx));
        }

        public boolean isMap(Predicate.PredicateContext ctx) {
            return ctx.configuration().jsonProvider().isMap(this.parse(ctx));
        }

        public int length(Predicate.PredicateContext ctx) {
            return this.isArray(ctx) ? ctx.configuration().jsonProvider().length(this.parse(ctx)) : -1;
        }

        public boolean isEmpty(Predicate.PredicateContext ctx) {
            if (this.isArray(ctx) || this.isMap(ctx)) {
                return ctx.configuration().jsonProvider().length(this.parse(ctx)) == 0;
            }
            if (this.parse(ctx) instanceof String) {
                return ((String)this.parse(ctx)).length() == 0;
            }
            return true;
        }

        public String toString() {
            return this.json.toString();
        }

        public boolean equals(JsonNode jsonNode, Predicate.PredicateContext ctx) {
            if (this == jsonNode) {
                return true;
            }
            return !(this.json == null ? jsonNode.json != null : !this.json.equals(jsonNode.parse(ctx)));
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof JsonNode)) {
                return false;
            }
            JsonNode jsonNode = (JsonNode)o;
            return !(this.json == null ? jsonNode.json != null : !this.json.equals(jsonNode.json));
        }
    }

    public static class PatternNode
    extends ValueNode {
        private final String pattern;
        private final Pattern compiledPattern;

        private PatternNode(CharSequence charSequence) {
            String tmp = charSequence.toString();
            int begin = tmp.indexOf(47);
            int end = tmp.lastIndexOf(47);
            int flags = tmp.endsWith("/i") ? 2 : 0;
            this.pattern = tmp.substring(begin + 1, end);
            this.compiledPattern = Pattern.compile(this.pattern, flags);
        }

        public PatternNode(Pattern pattern) {
            this.pattern = pattern.pattern();
            this.compiledPattern = pattern;
        }

        public Pattern getCompiledPattern() {
            return this.compiledPattern;
        }

        @Override
        public Class<?> type(Predicate.PredicateContext ctx) {
            return Void.TYPE;
        }

        @Override
        public boolean isPatternNode() {
            return true;
        }

        @Override
        public PatternNode asPatternNode() {
            return this;
        }

        public String toString() {
            String flags = "";
            if ((this.compiledPattern.flags() & 2) == 2) {
                flags = "i";
            }
            if (!this.pattern.startsWith("/")) {
                return "/" + this.pattern + "/" + flags;
            }
            return this.pattern;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof PatternNode)) {
                return false;
            }
            PatternNode that = (PatternNode)o;
            return !(this.compiledPattern == null ? that.compiledPattern != null : !this.compiledPattern.equals(that.compiledPattern));
        }
    }
}

