/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.com.jayway.jsonpath.internal.path;

import znaishaded.com.jayway.jsonpath.Configuration;
import znaishaded.com.jayway.jsonpath.internal.EvaluationAbortException;
import znaishaded.com.jayway.jsonpath.internal.EvaluationContext;
import znaishaded.com.jayway.jsonpath.internal.Path;
import znaishaded.com.jayway.jsonpath.internal.PathRef;
import znaishaded.com.jayway.jsonpath.internal.path.EvaluationContextImpl;
import znaishaded.com.jayway.jsonpath.internal.path.RootPathToken;
import znaishaded.org.slf4j.Logger;
import znaishaded.org.slf4j.LoggerFactory;

public class CompiledPath
implements Path {
    private static final Logger logger = LoggerFactory.getLogger(CompiledPath.class);
    private final RootPathToken root;
    private final boolean isRootPath;

    public CompiledPath(RootPathToken root, boolean isRootPath) {
        this.root = root;
        this.isRootPath = isRootPath;
    }

    @Override
    public boolean isRootPath() {
        return this.isRootPath;
    }

    @Override
    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration, boolean forUpdate) {
        if (logger.isDebugEnabled()) {
            logger.debug("Evaluating path: {}", (Object)this.toString());
        }
        EvaluationContextImpl ctx = new EvaluationContextImpl(this, rootDocument, configuration, forUpdate);
        try {
            PathRef op = ctx.forUpdate() ? PathRef.createRoot(rootDocument) : PathRef.NO_OP;
            this.root.evaluate("", op, document, ctx);
        }
        catch (EvaluationAbortException abort) {
            // empty catch block
        }
        return ctx;
    }

    @Override
    public EvaluationContext evaluate(Object document, Object rootDocument, Configuration configuration) {
        return this.evaluate(document, rootDocument, configuration, false);
    }

    @Override
    public boolean isDefinite() {
        return this.root.isPathDefinite();
    }

    @Override
    public boolean isFunctionPath() {
        return this.root.isFunctionPath();
    }

    public String toString() {
        return this.root.toString();
    }
}

