/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import znaishaded.freemarker.core.ArithmeticEngine;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.TemplateObject;
import znaishaded.freemarker.core._MiscTemplateException;
import znaishaded.freemarker.template.SimpleNumber;
import znaishaded.freemarker.template.TemplateException;
import znaishaded.freemarker.template.TemplateModel;

final class ArithmeticExpression
extends Expression {
    static final int TYPE_SUBSTRACTION = 0;
    static final int TYPE_MULTIPLICATION = 1;
    static final int TYPE_DIVISION = 2;
    static final int TYPE_MODULO = 3;
    private static final char[] OPERATOR_IMAGES = new char[]{'-', '*', '/', '%'};
    private final Expression lho;
    private final Expression rho;
    private final int operator;

    ArithmeticExpression(Expression lho, Expression rho, int operator) {
        this.lho = lho;
        this.rho = rho;
        this.operator = operator;
    }

    TemplateModel _eval(Environment env) throws TemplateException {
        return ArithmeticExpression._eval(env, this, this.lho.evalToNumber(env), this.operator, this.rho.evalToNumber(env));
    }

    static TemplateModel _eval(Environment env, TemplateObject parent, Number lhoNumber, int operator, Number rhoNumber) throws TemplateException, _MiscTemplateException {
        ArithmeticEngine ae = env != null ? env.getArithmeticEngine() : parent.getTemplate().getArithmeticEngine();
        switch (operator) {
            case 0: {
                return new SimpleNumber(ae.subtract(lhoNumber, rhoNumber));
            }
            case 1: {
                return new SimpleNumber(ae.multiply(lhoNumber, rhoNumber));
            }
            case 2: {
                return new SimpleNumber(ae.divide(lhoNumber, rhoNumber));
            }
            case 3: {
                return new SimpleNumber(ae.modulus(lhoNumber, rhoNumber));
            }
        }
        if (parent instanceof Expression) {
            throw new _MiscTemplateException((Expression)parent, new Object[]{"Unknown operation: ", new Integer(operator)});
        }
        throw new _MiscTemplateException(new Object[]{"Unknown operation: ", new Integer(operator)});
    }

    public String getCanonicalForm() {
        return this.lho.getCanonicalForm() + ' ' + ArithmeticExpression.getOperatorSymbol(this.operator) + ' ' + this.rho.getCanonicalForm();
    }

    String getNodeTypeSymbol() {
        return String.valueOf(ArithmeticExpression.getOperatorSymbol(this.operator));
    }

    static char getOperatorSymbol(int operator) {
        return OPERATOR_IMAGES[operator];
    }

    boolean isLiteral() {
        return this.constantValue != null || this.lho.isLiteral() && this.rho.isLiteral();
    }

    protected Expression deepCloneWithIdentifierReplaced_inner(String replacedIdentifier, Expression replacement, Expression.ReplacemenetState replacementState) {
        return new ArithmeticExpression(this.lho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.rho.deepCloneWithIdentifierReplaced(replacedIdentifier, replacement, replacementState), this.operator);
    }

    int getParameterCount() {
        return 3;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return this.lho;
            }
            case 1: {
                return this.rho;
            }
            case 2: {
                return new Integer(this.operator);
            }
        }
        throw new IndexOutOfBoundsException();
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.LEFT_HAND_OPERAND;
            }
            case 1: {
                return ParameterRole.RIGHT_HAND_OPERAND;
            }
            case 2: {
                return ParameterRole.AST_NODE_SUBTYPE;
            }
        }
        throw new IndexOutOfBoundsException();
    }
}

