/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.io.IOException;
import znaishaded.freemarker.core.Assignment;
import znaishaded.freemarker.core.Environment;
import znaishaded.freemarker.core.Expression;
import znaishaded.freemarker.core.ParameterRole;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core.TemplateElement;
import znaishaded.freemarker.template.TemplateException;

final class AssignmentInstruction
extends TemplateElement {
    private int scope;
    private Expression namespaceExp;

    AssignmentInstruction(int scope) {
        this.scope = scope;
        this.setRegulatedChildBufferCapacity(1);
    }

    void addAssignment(Assignment assignment) {
        this.addRegulatedChild(assignment);
    }

    void setNamespaceExp(Expression namespaceExp) {
        this.namespaceExp = namespaceExp;
        int ln = this.getRegulatedChildCount();
        for (int i = 0; i < ln; ++i) {
            ((Assignment)this.getRegulatedChild(i)).setNamespaceExp(namespaceExp);
        }
    }

    void accept(Environment env) throws TemplateException, IOException {
        int ln = this.getRegulatedChildCount();
        for (int i = 0; i < ln; ++i) {
            Assignment assignment = (Assignment)this.getRegulatedChild(i);
            env.visit(assignment);
        }
    }

    protected String dump(boolean canonical) {
        StringBuffer buf = new StringBuffer();
        if (canonical) {
            buf.append('<');
        }
        buf.append(Assignment.getDirectiveName(this.scope));
        if (canonical) {
            buf.append(' ');
            int ln = this.getRegulatedChildCount();
            for (int i = 0; i < ln; ++i) {
                if (i != 0) {
                    buf.append(", ");
                }
                Assignment assignment = (Assignment)this.getRegulatedChild(i);
                buf.append(assignment.getCanonicalForm());
            }
        } else {
            buf.append("-container");
        }
        if (this.namespaceExp != null) {
            buf.append(" in ");
            buf.append(this.namespaceExp.getCanonicalForm());
        }
        if (canonical) {
            buf.append(">");
        }
        return buf.toString();
    }

    int getParameterCount() {
        return 2;
    }

    Object getParameterValue(int idx) {
        switch (idx) {
            case 0: {
                return new Integer(this.scope);
            }
            case 1: {
                return this.namespaceExp;
            }
        }
        return null;
    }

    ParameterRole getParameterRole(int idx) {
        switch (idx) {
            case 0: {
                return ParameterRole.VARIABLE_SCOPE;
            }
            case 1: {
                return ParameterRole.NAMESPACE;
            }
        }
        return null;
    }

    String getNodeTypeSymbol() {
        return Assignment.getDirectiveName(this.scope);
    }

    public TemplateElement postParseCleanup(boolean stripWhitespace) throws ParseException {
        super.postParseCleanup(stripWhitespace);
        return this;
    }

    boolean isNestedBlockRepeater() {
        return false;
    }
}

