/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.core;

import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import znaishaded.freemarker.core.ParseException;
import znaishaded.freemarker.core._ObjectBuilderSettingEvaluationException;
import znaishaded.freemarker.core._SettingEvaluationEnvironment;
import znaishaded.freemarker.ext.beans.BeansWrapper;
import znaishaded.freemarker.template.DefaultObjectWrapper;
import znaishaded.freemarker.template.SimpleObjectWrapper;
import znaishaded.freemarker.template.TemplateHashModel;
import znaishaded.freemarker.template.TemplateMethodModelEx;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.Version;
import znaishaded.freemarker.template.utility.ClassUtil;
import znaishaded.freemarker.template.utility.StringUtil;
import znaishaded.freemarker.template.utility.WriteProtectable;

public class _ObjectBuilderSettingEvaluator {
    private static final String INSTANCE_FIELD_NAME = "INSTANCE";
    private static final String BUILD_METHOD_NAME = "build";
    private static final String BUILDER_CLASS_POSTFIX = "Builder";
    private static Map SHORTHANDS;
    private final String src;
    private final Class expectedClass;
    private final _SettingEvaluationEnvironment env;
    private int pos;
    private boolean v2321Mode = false;

    private _ObjectBuilderSettingEvaluator(String src, int pos, Class expectedClass, _SettingEvaluationEnvironment env) {
        this.src = src;
        this.pos = pos;
        this.expectedClass = expectedClass;
        this.env = env;
    }

    public static Object eval(String src, Class expectedClass, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(src, 0, expectedClass, env).eval();
    }

    public static int configureBean(String argumentListSrc, int posAfterOpenParen, Object bean, _SettingEvaluationEnvironment env) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return new _ObjectBuilderSettingEvaluator(argumentListSrc, posAfterOpenParen, bean.getClass(), env).configureBean(bean);
    }

    private Object eval() throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        return this.execute(this.parse());
    }

    private int configureBean(Object bean) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        PropertyAssignmentsExpression propAssignments = new PropertyAssignmentsExpression(bean);
        this.fetchParameterListInto(propAssignments);
        this.skipWS();
        propAssignments.eval();
        return this.pos;
    }

    private BuilderExpression parse() throws _ObjectBuilderSettingEvaluationException {
        this.skipWS();
        BuilderExpression exp = this.fetchBuilderCall(true, false);
        this.skipWS();
        if (this.pos != this.src.length()) {
            throw new _ObjectBuilderSettingEvaluationException("end-of-expression", this.src, this.pos);
        }
        return exp;
    }

    private Object execute(BuilderExpression exp) throws _ObjectBuilderSettingEvaluationException, ClassNotFoundException, InstantiationException, IllegalAccessException {
        if (!this.v2321Mode) {
            return ClassUtil.forName(exp.className).newInstance();
        }
        return exp.eval();
    }

    private Object eval(Object value) throws _ObjectBuilderSettingEvaluationException {
        return value instanceof SettingExpression ? ((SettingExpression)value).eval() : value;
    }

    private BuilderExpression fetchBuilderCall(boolean topLevel, boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        BuilderExpression exp = new BuilderExpression();
        String fetchedClassName = this.fetchClassName(optional);
        if (fetchedClassName == null) {
            return null;
        }
        exp.className = _ObjectBuilderSettingEvaluator.shorthandToFullQualified(fetchedClassName);
        if (!fetchedClassName.equals(exp.className)) {
            this.v2321Mode = true;
        }
        this.skipWS();
        char openParen = this.fetchOptionalChar("(");
        if (openParen == '\u0000' && !topLevel) {
            if (!optional) {
                throw new _ObjectBuilderSettingEvaluationException("(", this.src, this.pos);
            }
            this.pos = startPos;
            return null;
        }
        if (openParen != '\u0000') {
            this.fetchParameterListInto(exp);
        }
        return exp;
    }

    private void fetchParameterListInto(ExpressionWithParameters exp) throws _ObjectBuilderSettingEvaluationException {
        this.v2321Mode = true;
        this.skipWS();
        if (this.fetchOptionalChar(")") != ')') {
            do {
                this.skipWS();
                Object paramNameOrValue = this.fetchValueOrName(false);
                if (paramNameOrValue == null) continue;
                this.skipWS();
                if (paramNameOrValue instanceof ParameterName) {
                    exp.namedParamNames.add(((ParameterName)paramNameOrValue).name);
                    this.skipWS();
                    this.fetchRequiredChar("=");
                    this.skipWS();
                    int paramValPos = this.pos;
                    Object paramValue = this.fetchValueOrName(false);
                    if (paramValue instanceof ParameterName) {
                        throw new _ObjectBuilderSettingEvaluationException("concrete value", this.src, paramValPos);
                    }
                    exp.namedParamValues.add(this.eval(paramValue));
                } else {
                    if (!exp.namedParamNames.isEmpty()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters must precede named parameters");
                    }
                    if (!exp.getAllowPositionalParameters()) {
                        throw new _ObjectBuilderSettingEvaluationException("Positional parameters not supported here");
                    }
                    exp.positionalParamValues.add(this.eval(paramNameOrValue));
                }
                this.skipWS();
            } while (this.fetchRequiredChar(",)") == ',');
        }
    }

    private Object fetchValueOrName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        if (this.pos < this.src.length()) {
            Object val = this.fetchNumberLike(true);
            if (val != null) {
                return val;
            }
            val = this.fetchStringLiteral(true);
            if (val != null) {
                return val;
            }
            val = this.fetchBuilderCall(false, true);
            if (val != null) {
                return val;
            }
            String name = this.fetchSimpleName(true);
            if (name != null) {
                if (name.equals("true")) {
                    return Boolean.TRUE;
                }
                if (name.equals("false")) {
                    return Boolean.FALSE;
                }
                if (name.equals("null")) {
                    return NullExpression.INSTANCE;
                }
                return new ParameterName(name);
            }
        }
        if (optional) {
            return null;
        }
        throw new _ObjectBuilderSettingEvaluationException("value or name", this.src, this.pos);
    }

    private String fetchSimpleName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c;
        char c2 = c = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (!this.isIdentifierStart(c)) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("class name", this.src, this.pos);
        }
        int startPos = this.pos++;
        while (this.pos != this.src.length() && this.isIdentifierMiddle(c = this.src.charAt(this.pos))) {
            ++this.pos;
        }
        return this.src.substring(startPos, this.pos);
    }

    private String fetchClassName(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        StringBuffer sb = new StringBuffer();
        while (true) {
            String name;
            if ((name = this.fetchSimpleName(true)) == null) {
                if (!optional) {
                    throw new _ObjectBuilderSettingEvaluationException("name", this.src, this.pos);
                }
                this.pos = startPos;
                return null;
            }
            sb.append(name);
            this.skipWS();
            if (this.pos >= this.src.length() || this.src.charAt(this.pos) != '.') break;
            sb.append('.');
            ++this.pos;
            this.skipWS();
        }
        return sb.toString();
    }

    private Object fetchNumberLike(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        boolean isVersion = false;
        boolean hasDot = false;
        while (this.pos != this.src.length()) {
            char c = this.src.charAt(this.pos);
            if (c == '.') {
                if (hasDot) {
                    isVersion = true;
                } else {
                    hasDot = true;
                }
            } else if (!this.isASCIIDigit(c) && c != '-') break;
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("number-like", this.src, this.pos);
        }
        String tk = this.src.substring(startPos, this.pos);
        if (isVersion) {
            try {
                return new Version(tk);
            }
            catch (IllegalArgumentException e) {
                throw new _ObjectBuilderSettingEvaluationException("Malformed version number: " + tk, e);
            }
        }
        try {
            if (tk.endsWith(".")) {
                throw new NumberFormatException("A number can't end with a dot");
            }
            if (tk.startsWith(".") || tk.startsWith("-.") || tk.startsWith("+.")) {
                throw new NumberFormatException("A number can't start with a dot");
            }
            return new BigDecimal(tk);
        }
        catch (NumberFormatException e) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed number: " + tk, e);
        }
    }

    private Object fetchStringLiteral(boolean optional) throws _ObjectBuilderSettingEvaluationException {
        int startPos = this.pos;
        int q = 0;
        boolean afterEscape = false;
        boolean raw = false;
        while (true) {
            if (this.pos == this.src.length()) {
                if (q == 0) break;
                throw new _ObjectBuilderSettingEvaluationException(String.valueOf((char)q), this.src, this.pos);
            }
            int c = this.src.charAt(this.pos);
            if (q == 0) {
                if (c == 114 && this.pos + 1 < this.src.length()) {
                    raw = true;
                    c = this.src.charAt(this.pos + 1);
                }
                if (c == 39) {
                    q = 39;
                } else {
                    if (c != 34) break;
                    q = 34;
                }
                if (raw) {
                    ++this.pos;
                }
            } else if (!afterEscape) {
                if (c == 92 && !raw) {
                    afterEscape = true;
                } else {
                    char prevC;
                    if (c == q) break;
                    if (c == 123 && ((prevC = this.src.charAt(this.pos - 1)) == '$' || prevC == '#')) {
                        throw new _ObjectBuilderSettingEvaluationException("${...} and #{...} aren't allowed here.");
                    }
                }
            } else {
                afterEscape = false;
            }
            ++this.pos;
        }
        if (startPos == this.pos) {
            if (optional) {
                return null;
            }
            throw new _ObjectBuilderSettingEvaluationException("string literal", this.src, this.pos);
        }
        String sInside = this.src.substring(startPos + (raw ? 2 : 1), this.pos);
        try {
            ++this.pos;
            return raw ? sInside : StringUtil.FTLStringLiteralDec(sInside);
        }
        catch (ParseException e) {
            throw new _ObjectBuilderSettingEvaluationException("Malformed string literal: " + sInside, e);
        }
    }

    private void skipWS() {
        while (this.pos != this.src.length()) {
            char c = this.src.charAt(this.pos);
            if (!Character.isWhitespace(c)) {
                return;
            }
            ++this.pos;
        }
        return;
    }

    private char fetchOptionalChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, true);
    }

    private char fetchRequiredChar(String expectedChars) throws _ObjectBuilderSettingEvaluationException {
        return this.fetchChar(expectedChars, false);
    }

    private char fetchChar(String expectedChars, boolean optional) throws _ObjectBuilderSettingEvaluationException {
        char c;
        char c2 = c = this.pos < this.src.length() ? this.src.charAt(this.pos) : (char)'\u0000';
        if (expectedChars.indexOf(c) != -1) {
            ++this.pos;
            return c;
        }
        if (optional) {
            return '\u0000';
        }
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < expectedChars.length(); ++i) {
            if (i != 0) {
                sb.append(" or ");
            }
            sb.append(StringUtil.jQuote(expectedChars.substring(i, i + 1)));
        }
        if (optional) {
            sb.append(" or end-of-string");
        }
        throw new _ObjectBuilderSettingEvaluationException(sb.toString(), this.src, this.pos);
    }

    private boolean isASCIIDigit(char c) {
        return c >= '0' && c <= '9';
    }

    private boolean isIdentifierStart(char c) {
        return Character.isLetter(c) || c == '_' || c == '$';
    }

    private boolean isIdentifierMiddle(char c) {
        return this.isIdentifierStart(c) || this.isASCIIDigit(c);
    }

    private static synchronized String shorthandToFullQualified(String className) {
        String fullClassName;
        if (SHORTHANDS == null) {
            SHORTHANDS = new HashMap();
            SHORTHANDS.put("DefaultObjectWrapper", DefaultObjectWrapper.class.getName());
            SHORTHANDS.put("BeansWrapper", BeansWrapper.class.getName());
            SHORTHANDS.put("SimpleObjectWrapper", SimpleObjectWrapper.class.getName());
        }
        return (fullClassName = (String)SHORTHANDS.get(className)) == null ? className : fullClassName;
    }

    private void setJavaBeanProperties(Object bean, List namedParamNames, List namedParamValues) throws _ObjectBuilderSettingEvaluationException {
        int i;
        HashMap<String, Method> beanPropSetters;
        if (namedParamNames.isEmpty()) {
            return;
        }
        Class<?> cl = bean.getClass();
        try {
            PropertyDescriptor[] propDescs = Introspector.getBeanInfo(cl).getPropertyDescriptors();
            beanPropSetters = new HashMap<String, Method>(propDescs.length * 4 / 3, 1.0f);
            for (i = 0; i < propDescs.length; ++i) {
                PropertyDescriptor propDesc = propDescs[i];
                Method writeMethod = propDesc.getWriteMethod();
                if (writeMethod == null) continue;
                beanPropSetters.put(propDesc.getName(), writeMethod);
            }
        }
        catch (Exception e) {
            throw new _ObjectBuilderSettingEvaluationException("Failed to inspect " + cl.getName() + " class", e);
        }
        TemplateHashModel beanTM = null;
        for (i = 0; i < namedParamNames.size(); ++i) {
            String name = (String)namedParamNames.get(i);
            if (!beanPropSetters.containsKey(name)) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class has no writeable JavaBeans property called " + StringUtil.jQuote(name) + ".");
            }
            Method beanPropSetter = beanPropSetters.put(name, null);
            if (beanPropSetter == null) {
                throw new _ObjectBuilderSettingEvaluationException("JavaBeans property " + StringUtil.jQuote(name) + " is set twice.");
            }
            try {
                TemplateModel m3;
                if (beanTM == null) {
                    TemplateModel wrappedObj = this.env.getObjectWrapper().wrap(bean);
                    if (!(wrappedObj instanceof TemplateHashModel)) {
                        throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " class is not a wrapped as TemplateHashModel.");
                    }
                    beanTM = (TemplateHashModel)wrappedObj;
                }
                if ((m3 = beanTM.get(beanPropSetter.getName())) == null) {
                    throw new _ObjectBuilderSettingEvaluationException("Can't find " + beanPropSetter + " as FreeMarker method.");
                }
                if (!(m3 instanceof TemplateMethodModelEx)) {
                    throw new _ObjectBuilderSettingEvaluationException(StringUtil.jQuote(beanPropSetter.getName()) + " wasn't a TemplateMethodModelEx.");
                }
                ArrayList<TemplateModel> args = new ArrayList<TemplateModel>();
                args.add(this.env.getObjectWrapper().wrap(namedParamValues.get(i)));
                ((TemplateMethodModelEx)m3).exec(args);
                continue;
            }
            catch (Exception e) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to set " + StringUtil.jQuote(name), e);
            }
        }
    }

    private static class NullExpression
    extends SettingExpression {
        static final NullExpression INSTANCE = new NullExpression();

        private NullExpression() {
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            return null;
        }
    }

    private class PropertyAssignmentsExpression
    extends ExpressionWithParameters {
        private final Object bean;

        public PropertyAssignmentsExpression(Object bean) {
            this.bean = bean;
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(this.bean, this.namedParamNames, this.namedParamValues);
            return this.bean;
        }

        protected boolean getAllowPositionalParameters() {
            return false;
        }
    }

    private class BuilderExpression
    extends ExpressionWithParameters {
        private String className;

        private BuilderExpression() {
        }

        Object eval() throws _ObjectBuilderSettingEvaluationException {
            Object result;
            boolean clIsBuilderClass;
            Class cl;
            try {
                cl = ClassUtil.forName(this.className);
            }
            catch (Exception e) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get class " + StringUtil.jQuote(this.className) + ".", e);
            }
            try {
                cl = ClassUtil.forName(cl.getName() + _ObjectBuilderSettingEvaluator.BUILDER_CLASS_POSTFIX);
                clIsBuilderClass = true;
            }
            catch (ClassNotFoundException e) {
                clIsBuilderClass = false;
            }
            if (!clIsBuilderClass && this.hasNoParameters()) {
                try {
                    Field f = cl.getField(_ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME);
                    if ((f.getModifiers() & 9) == 9) {
                        return f.get(null);
                    }
                }
                catch (NoSuchFieldException e) {
                }
                catch (Exception e) {
                    throw new _ObjectBuilderSettingEvaluationException("Error when trying to access " + StringUtil.jQuote(this.className) + "." + _ObjectBuilderSettingEvaluator.INSTANCE_FIELD_NAME, e);
                }
            }
            Object constructorResult = this.callConstructor(cl);
            _ObjectBuilderSettingEvaluator.this.setJavaBeanProperties(constructorResult, this.namedParamNames, this.namedParamValues);
            if (clIsBuilderClass) {
                result = this.callBuild(constructorResult);
            } else {
                if (constructorResult instanceof WriteProtectable) {
                    ((WriteProtectable)constructorResult).writeProtect();
                }
                result = constructorResult;
            }
            if (!_ObjectBuilderSettingEvaluator.this.expectedClass.isInstance(result)) {
                throw new _ObjectBuilderSettingEvaluationException("The resulting object (of class " + result.getClass() + ") is not a(n) " + _ObjectBuilderSettingEvaluator.this.expectedClass.getName() + ".");
            }
            return result;
        }

        private Object callConstructor(Class cl) throws _ObjectBuilderSettingEvaluationException {
            if (this.hasNoParameters()) {
                try {
                    return cl.newInstance();
                }
                catch (Exception e) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " 0-argument constructor", e);
                }
            }
            BeansWrapper ow = _ObjectBuilderSettingEvaluator.this.env.getObjectWrapper();
            ArrayList<TemplateModel> tmArgs = new ArrayList<TemplateModel>(this.positionalParamValues.size());
            for (int i = 0; i < this.positionalParamValues.size(); ++i) {
                try {
                    tmArgs.add(ow.wrap(this.positionalParamValues.get(i)));
                    continue;
                }
                catch (TemplateModelException e) {
                    throw new _ObjectBuilderSettingEvaluationException("Failed to wrap arg #" + (i + 1), e);
                }
            }
            try {
                return ow.newInstance(cl, tmArgs);
            }
            catch (Exception e) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to call " + cl.getName() + " constructor", e);
            }
        }

        private Object callBuild(Object constructorResult) throws _ObjectBuilderSettingEvaluationException {
            Method buildMethod;
            Class<?> cl = constructorResult.getClass();
            try {
                buildMethod = constructorResult.getClass().getMethod(_ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME, null);
            }
            catch (NoSuchMethodException e) {
                throw new _ObjectBuilderSettingEvaluationException("The " + cl.getName() + " builder class must have a public " + _ObjectBuilderSettingEvaluator.BUILD_METHOD_NAME + "() method", e);
            }
            catch (Exception e) {
                throw new _ObjectBuilderSettingEvaluationException("Failed to get the build() method of the " + cl.getName() + " builder class", e);
            }
            try {
                return buildMethod.invoke(constructorResult, (Object[])null);
            }
            catch (Exception e) {
                Throwable cause = e instanceof InvocationTargetException ? ((InvocationTargetException)e).getTargetException() : e;
                throw new _ObjectBuilderSettingEvaluationException("Failed to call build() method on " + cl.getName() + " instance", cause);
            }
        }

        private boolean hasNoParameters() {
            return this.positionalParamValues.isEmpty() && this.namedParamValues.isEmpty();
        }

        protected boolean getAllowPositionalParameters() {
            return true;
        }
    }

    private abstract class ExpressionWithParameters
    extends SettingExpression {
        protected List positionalParamValues;
        protected List namedParamNames;
        protected List namedParamValues;

        private ExpressionWithParameters() {
            this.positionalParamValues = new ArrayList();
            this.namedParamNames = new ArrayList();
            this.namedParamValues = new ArrayList();
        }

        protected abstract boolean getAllowPositionalParameters();
    }

    private static abstract class SettingExpression {
        private SettingExpression() {
        }

        abstract Object eval() throws _ObjectBuilderSettingEvaluationException;
    }

    private static class ParameterName {
        private final String name;

        public ParameterName(String name) {
            this.name = name;
        }
    }
}

