/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.freemarker.ext.rhino;

import znaishaded.freemarker.ext.beans.BeansWrapper;
import znaishaded.freemarker.ext.rhino.RhinoFunctionModel;
import znaishaded.freemarker.ext.util.ModelFactory;
import znaishaded.freemarker.template.AdapterTemplateModel;
import znaishaded.freemarker.template.ObjectWrapper;
import znaishaded.freemarker.template.TemplateBooleanModel;
import znaishaded.freemarker.template.TemplateCollectionModel;
import znaishaded.freemarker.template.TemplateHashModelEx;
import znaishaded.freemarker.template.TemplateModel;
import znaishaded.freemarker.template.TemplateModelException;
import znaishaded.freemarker.template.TemplateNumberModel;
import znaishaded.freemarker.template.TemplateScalarModel;
import znaishaded.freemarker.template.TemplateSequenceModel;
import znaishaded.org.mozilla.javascript.Context;
import znaishaded.org.mozilla.javascript.EvaluatorException;
import znaishaded.org.mozilla.javascript.Function;
import znaishaded.org.mozilla.javascript.NativeJavaObject;
import znaishaded.org.mozilla.javascript.Scriptable;
import znaishaded.org.mozilla.javascript.ScriptableObject;

public class RhinoScriptableModel
implements TemplateHashModelEx,
TemplateSequenceModel,
AdapterTemplateModel,
TemplateScalarModel,
TemplateBooleanModel,
TemplateNumberModel {
    static final ModelFactory FACTORY = new ModelFactory(){

        public TemplateModel create(Object object, ObjectWrapper wrapper) {
            return new RhinoScriptableModel((Scriptable)object, (BeansWrapper)wrapper);
        }
    };
    private final Scriptable scriptable;
    private final BeansWrapper wrapper;

    public RhinoScriptableModel(Scriptable scriptable, BeansWrapper wrapper) {
        this.scriptable = scriptable;
        this.wrapper = wrapper;
    }

    public TemplateModel get(String key) throws TemplateModelException {
        Object retval = ScriptableObject.getProperty((Scriptable)this.scriptable, (String)key);
        if (retval instanceof Function) {
            return new RhinoFunctionModel((Function)retval, this.scriptable, this.wrapper);
        }
        return this.wrapper.wrap(retval);
    }

    public TemplateModel get(int index) throws TemplateModelException {
        Object retval = ScriptableObject.getProperty((Scriptable)this.scriptable, (int)index);
        if (retval instanceof Function) {
            return new RhinoFunctionModel((Function)retval, this.scriptable, this.wrapper);
        }
        return this.wrapper.wrap(retval);
    }

    public boolean isEmpty() {
        return this.scriptable.getIds().length == 0;
    }

    public TemplateCollectionModel keys() throws TemplateModelException {
        return (TemplateCollectionModel)this.wrapper.wrap(this.scriptable.getIds());
    }

    public int size() {
        return this.scriptable.getIds().length;
    }

    public TemplateCollectionModel values() throws TemplateModelException {
        Object[] ids = this.scriptable.getIds();
        Object[] values = new Object[ids.length];
        for (int i = 0; i < values.length; ++i) {
            Object id = ids[i];
            values[i] = id instanceof Number ? ScriptableObject.getProperty((Scriptable)this.scriptable, (int)((Number)id).intValue()) : ScriptableObject.getProperty((Scriptable)this.scriptable, (String)String.valueOf(id));
        }
        return (TemplateCollectionModel)this.wrapper.wrap(values);
    }

    public boolean getAsBoolean() {
        return Context.toBoolean((Object)this.scriptable);
    }

    public Number getAsNumber() {
        return new Double(Context.toNumber((Object)this.scriptable));
    }

    public String getAsString() {
        return Context.toString((Object)this.scriptable);
    }

    Scriptable getScriptable() {
        return this.scriptable;
    }

    BeansWrapper getWrapper() {
        return this.wrapper;
    }

    public Object getAdaptedObject(Class hint) {
        try {
            return NativeJavaObject.coerceType((Class)hint, (Object)this.scriptable);
        }
        catch (EvaluatorException e) {
            return NativeJavaObject.coerceType((Class)Object.class, (Object)this.scriptable);
        }
    }
}

