/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.datagram.impl;

import java.net.InetSocketAddress;
import znaishaded.io.netty.buffer.ByteBuf;
import znaishaded.io.netty.buffer.ByteBufAllocator;
import znaishaded.io.netty.channel.ChannelHandlerContext;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.datagram.DatagramPacket;
import znaishaded.io.vertx.core.datagram.impl.DatagramPacketImpl;
import znaishaded.io.vertx.core.datagram.impl.DatagramSocketImpl;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.net.impl.VertxHandler;

final class DatagramServerHandler
extends VertxHandler<DatagramSocketImpl.Connection> {
    private final DatagramSocketImpl socket;

    DatagramServerHandler(DatagramSocketImpl socket) {
        this.socket = socket;
    }

    @Override
    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.setConnection(this.socket.createConnection(ctx));
    }

    @Override
    protected void handleMessage(DatagramSocketImpl.Connection server, ContextImpl context, ChannelHandlerContext chctx, Object msg) throws Exception {
        server.handlePacket((DatagramPacket)msg);
    }

    @Override
    protected Object decode(Object msg, ByteBufAllocator allocator) throws Exception {
        if (msg instanceof znaishaded.io.netty.channel.socket.DatagramPacket) {
            znaishaded.io.netty.channel.socket.DatagramPacket packet = (znaishaded.io.netty.channel.socket.DatagramPacket)msg;
            ByteBuf content = (ByteBuf)packet.content();
            if (content.isDirect()) {
                content = DatagramServerHandler.safeBuffer(content, allocator);
            }
            return new DatagramPacketImpl((InetSocketAddress)packet.sender(), Buffer.buffer(content));
        }
        return msg;
    }
}

