/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http;

import java.util.ArrayList;
import znaishaded.io.vertx.core.http.Http2Settings;
import znaishaded.io.vertx.core.http.HttpServerOptions;
import znaishaded.io.vertx.core.http.HttpVersion;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;

public class HttpServerOptionsConverter {
    public static void fromJson(JsonObject json, HttpServerOptions obj) {
        if (json.getValue("acceptUnmaskedFrames") instanceof Boolean) {
            obj.setAcceptUnmaskedFrames((Boolean)json.getValue("acceptUnmaskedFrames"));
        }
        if (json.getValue("alpnVersions") instanceof JsonArray) {
            ArrayList<HttpVersion> list = new ArrayList<HttpVersion>();
            json.getJsonArray("alpnVersions").forEach(item2 -> {
                if (item2 instanceof String) {
                    list.add(HttpVersion.valueOf((String)item2));
                }
            });
            obj.setAlpnVersions(list);
        }
        if (json.getValue("compressionLevel") instanceof Number) {
            obj.setCompressionLevel(((Number)json.getValue("compressionLevel")).intValue());
        }
        if (json.getValue("compressionSupported") instanceof Boolean) {
            obj.setCompressionSupported((Boolean)json.getValue("compressionSupported"));
        }
        if (json.getValue("decoderInitialBufferSize") instanceof Number) {
            obj.setDecoderInitialBufferSize(((Number)json.getValue("decoderInitialBufferSize")).intValue());
        }
        if (json.getValue("decompressionSupported") instanceof Boolean) {
            obj.setDecompressionSupported((Boolean)json.getValue("decompressionSupported"));
        }
        if (json.getValue("handle100ContinueAutomatically") instanceof Boolean) {
            obj.setHandle100ContinueAutomatically((Boolean)json.getValue("handle100ContinueAutomatically"));
        }
        if (json.getValue("http2ConnectionWindowSize") instanceof Number) {
            obj.setHttp2ConnectionWindowSize(((Number)json.getValue("http2ConnectionWindowSize")).intValue());
        }
        if (json.getValue("initialSettings") instanceof JsonObject) {
            obj.setInitialSettings(new Http2Settings((JsonObject)json.getValue("initialSettings")));
        }
        if (json.getValue("maxChunkSize") instanceof Number) {
            obj.setMaxChunkSize(((Number)json.getValue("maxChunkSize")).intValue());
        }
        if (json.getValue("maxHeaderSize") instanceof Number) {
            obj.setMaxHeaderSize(((Number)json.getValue("maxHeaderSize")).intValue());
        }
        if (json.getValue("maxInitialLineLength") instanceof Number) {
            obj.setMaxInitialLineLength(((Number)json.getValue("maxInitialLineLength")).intValue());
        }
        if (json.getValue("maxWebsocketFrameSize") instanceof Number) {
            obj.setMaxWebsocketFrameSize(((Number)json.getValue("maxWebsocketFrameSize")).intValue());
        }
        if (json.getValue("maxWebsocketMessageSize") instanceof Number) {
            obj.setMaxWebsocketMessageSize(((Number)json.getValue("maxWebsocketMessageSize")).intValue());
        }
        if (json.getValue("websocketSubProtocols") instanceof String) {
            obj.setWebsocketSubProtocols((String)json.getValue("websocketSubProtocols"));
        }
    }

    public static void toJson(HttpServerOptions obj, JsonObject json) {
        json.put("acceptUnmaskedFrames", obj.isAcceptUnmaskedFrames());
        if (obj.getAlpnVersions() != null) {
            JsonArray array = new JsonArray();
            obj.getAlpnVersions().forEach(item2 -> array.add(item2.name()));
            json.put("alpnVersions", array);
        }
        json.put("compressionLevel", obj.getCompressionLevel());
        json.put("compressionSupported", obj.isCompressionSupported());
        json.put("decoderInitialBufferSize", obj.getDecoderInitialBufferSize());
        json.put("decompressionSupported", obj.isDecompressionSupported());
        json.put("handle100ContinueAutomatically", obj.isHandle100ContinueAutomatically());
        json.put("http2ConnectionWindowSize", obj.getHttp2ConnectionWindowSize());
        if (obj.getInitialSettings() != null) {
            json.put("initialSettings", obj.getInitialSettings().toJson());
        }
        json.put("maxChunkSize", obj.getMaxChunkSize());
        json.put("maxHeaderSize", obj.getMaxHeaderSize());
        json.put("maxInitialLineLength", obj.getMaxInitialLineLength());
        json.put("maxWebsocketFrameSize", obj.getMaxWebsocketFrameSize());
        json.put("maxWebsocketMessageSize", obj.getMaxWebsocketMessageSize());
        if (obj.getWebsocketSubProtocols() != null) {
            json.put("websocketSubProtocols", obj.getWebsocketSubProtocols());
        }
    }
}

