/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.http.impl;

import java.util.concurrent.TimeoutException;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.http.HttpClientRequest;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.impl.HttpClientImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientRequestImpl;
import znaishaded.io.vertx.core.http.impl.HttpClientResponseImpl;
import znaishaded.io.vertx.core.http.impl.HttpUtils;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;

abstract class HttpClientRequestBase
implements HttpClientRequest {
    private static final Logger log = LoggerFactory.getLogger(HttpClientRequestImpl.class);
    protected final HttpClientImpl client;
    protected final HttpMethod method;
    protected final String uri;
    protected final String path;
    protected final String host;
    protected final int port;
    protected final String query;
    protected final boolean ssl;
    private Handler<Throwable> exceptionHandler;
    private long currentTimeoutTimerId = -1L;
    private long currentTimeoutMs;
    private long lastDataReceived;
    protected Throwable exceptionOccurred;
    private Object metric;

    HttpClientRequestBase(HttpClientImpl client, boolean ssl, HttpMethod method, String host, int port2, String uri) {
        this.client = client;
        this.uri = uri;
        this.method = method;
        this.host = host;
        this.port = port2;
        this.path = uri.length() > 0 ? HttpUtils.parsePath(uri) : "";
        this.query = HttpUtils.parseQuery(uri);
        this.ssl = ssl;
    }

    Object metric() {
        return this.metric;
    }

    void metric(Object metric) {
        this.metric = metric;
    }

    protected abstract void doHandleResponse(HttpClientResponseImpl var1, long var2);

    protected abstract void checkComplete();

    protected String hostHeader() {
        if (this.port == 80 && !this.ssl || this.port == 443 && this.ssl) {
            return this.host;
        }
        return this.host + ':' + this.port;
    }

    @Override
    public String absoluteURI() {
        return (this.ssl ? "https://" : "http://") + this.hostHeader() + this.uri;
    }

    @Override
    public String query() {
        return this.query;
    }

    @Override
    public String path() {
        return this.path;
    }

    @Override
    public String uri() {
        return this.uri;
    }

    @Override
    public HttpMethod method() {
        return this.method;
    }

    @Override
    public synchronized HttpClientRequest exceptionHandler(Handler<Throwable> handler) {
        if (handler != null) {
            this.checkComplete();
            this.exceptionHandler = handler;
        } else {
            this.exceptionHandler = null;
        }
        return this;
    }

    synchronized Handler<Throwable> exceptionHandler() {
        return this.exceptionHandler;
    }

    @Override
    public synchronized HttpClientRequest setTimeout(long timeoutMs) {
        this.cancelOutstandingTimeoutTimer();
        this.currentTimeoutMs = timeoutMs;
        this.currentTimeoutTimerId = this.client.getVertx().setTimer(timeoutMs, id -> this.handleTimeout(timeoutMs));
        return this;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void handleException(Throwable t) {
        Handler<Throwable> handler;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            this.cancelOutstandingTimeoutTimer();
            this.exceptionOccurred = t;
            handler = this.exceptionHandler != null ? this.exceptionHandler : log::error;
        }
        handler.handle(t);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void handleResponse(HttpClientResponseImpl resp) {
        long timeoutMS;
        HttpClientRequestBase httpClientRequestBase = this;
        synchronized (httpClientRequestBase) {
            if (this.exceptionOccurred != null) {
                return;
            }
            timeoutMS = this.cancelOutstandingTimeoutTimer();
        }
        try {
            this.doHandleResponse(resp, timeoutMS);
        }
        catch (Throwable t) {
            this.handleException(t);
        }
    }

    private long cancelOutstandingTimeoutTimer() {
        long ret = this.currentTimeoutTimerId;
        if (ret != -1L) {
            this.client.getVertx().cancelTimer(this.currentTimeoutTimerId);
            this.currentTimeoutTimerId = -1L;
            ret = this.currentTimeoutMs;
            this.currentTimeoutMs = 0L;
        }
        return ret;
    }

    private void handleTimeout(long timeoutMs) {
        if (this.lastDataReceived == 0L) {
            this.timeout(timeoutMs);
        } else {
            long now = System.currentTimeMillis();
            long timeSinceLastData = now - this.lastDataReceived;
            if (timeSinceLastData >= timeoutMs) {
                this.timeout(timeoutMs);
            } else {
                this.lastDataReceived = 0L;
                this.setTimeout(timeoutMs - timeSinceLastData);
            }
        }
    }

    private void timeout(long timeoutMs) {
        String msg = "The timeout period of " + timeoutMs + "ms has been exceeded while executing " + (Object)((Object)this.method) + " " + this.uri + " for host " + this.host;
        this.handleException(new TimeoutException(msg){

            @Override
            public synchronized Throwable fillInStackTrace() {
                return this;
            }
        });
    }

    void handleResponseEnd() {
    }

    synchronized void dataReceived() {
        if (this.currentTimeoutTimerId != -1L) {
            this.lastDataReceived = System.currentTimeMillis();
        }
    }
}

