/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.impl.launcher;

import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import java.util.stream.Collectors;
import znaishaded.io.vertx.core.cli.CLI;
import znaishaded.io.vertx.core.cli.CLIException;
import znaishaded.io.vertx.core.cli.CommandLine;
import znaishaded.io.vertx.core.cli.InvalidValueException;
import znaishaded.io.vertx.core.cli.MissingOptionException;
import znaishaded.io.vertx.core.cli.MissingValueException;
import znaishaded.io.vertx.core.cli.UsageMessageFormatter;
import znaishaded.io.vertx.core.cli.annotations.CLIConfigurator;
import znaishaded.io.vertx.core.impl.launcher.CommandLineUtils;
import znaishaded.io.vertx.core.impl.launcher.ServiceCommandFactoryLoader;
import znaishaded.io.vertx.core.impl.launcher.commands.RunCommand;
import znaishaded.io.vertx.core.spi.launcher.Command;
import znaishaded.io.vertx.core.spi.launcher.CommandFactory;
import znaishaded.io.vertx.core.spi.launcher.CommandFactoryLookup;
import znaishaded.io.vertx.core.spi.launcher.DefaultCommandFactory;
import znaishaded.io.vertx.core.spi.launcher.ExecutionContext;

public class VertxCommandLauncher
extends UsageMessageFormatter {
    protected static List<String> PROCESS_ARGS;
    protected final List<CommandFactoryLookup> lookups;
    protected final Map<String, CommandRegistration> commandByName;
    protected Object main;

    public static List<String> getProcessArguments() {
        return PROCESS_ARGS;
    }

    public VertxCommandLauncher() {
        this(Collections.singletonList(new ServiceCommandFactoryLoader()));
    }

    public VertxCommandLauncher(Collection<CommandFactoryLookup> lookups) {
        this.lookups = new ArrayList<CommandFactoryLookup>(lookups);
        this.commandByName = new TreeMap<String, CommandRegistration>();
        this.load();
    }

    protected void load() {
        for (CommandFactoryLookup lookup : this.lookups) {
            Collection<CommandFactory<?>> commands = lookup.lookup();
            commands.forEach(this::register);
        }
    }

    public VertxCommandLauncher register(CommandFactory factory) {
        CLI cli = factory.define();
        this.commandByName.put(cli.getName(), new CommandRegistration(factory, cli));
        return this;
    }

    public VertxCommandLauncher register(Class<? extends Command> clazz) {
        DefaultCommandFactory<? extends Command> factory = new DefaultCommandFactory<Command>(clazz);
        CLI cli = factory.define();
        this.commandByName.put(cli.getName(), new CommandRegistration(factory, cli));
        return this;
    }

    public VertxCommandLauncher unregister(String name) {
        this.commandByName.remove(name);
        return this;
    }

    public Collection<String> getCommandNames() {
        return this.commandByName.keySet();
    }

    protected Command getNewCommandInstance(String name, CommandLine commandLine) {
        CommandRegistration registration = this.commandByName.get(name);
        if (registration != null) {
            Object command = registration.factory.create(commandLine);
            registration.addCommand((Command)command);
            return command;
        }
        return null;
    }

    public Command getExistingCommandInstance(String name) {
        CommandRegistration registration = this.commandByName.get(name);
        if (registration != null) {
            return registration.getCommand();
        }
        return null;
    }

    public void execute(String command, String ... cla) {
        if (command != null && VertxCommandLauncher.isAskingForVersion(command)) {
            this.execute("version", new String[0]);
            return;
        }
        if (command == null || VertxCommandLauncher.isAskingForHelp(command)) {
            this.printGlobalUsage();
            return;
        }
        CommandRegistration registration = this.commandByName.get(command);
        if (registration == null) {
            this.printCommandNotFound(command);
            return;
        }
        CLI cli = registration.cli;
        try {
            if (cla.length >= 1 && VertxCommandLauncher.isAskingForHelp(cla[0])) {
                this.printCommandUsage(cli);
                return;
            }
            CommandLine evaluated = cli.parse(Arrays.asList(cla));
            Command cmd = this.getNewCommandInstance(command, evaluated);
            ExecutionContext context = new ExecutionContext(cmd, this, evaluated);
            if (this.main != null) {
                context.put("Main", this.main);
                context.put("Main-Class", this.main.getClass().getName());
            }
            CLIConfigurator.inject(evaluated, cmd);
            cmd.setUp(context);
            cmd.run();
            cmd.tearDown();
        }
        catch (InvalidValueException | MissingOptionException | MissingValueException e) {
            this.printSpecificException(cli, e);
        }
        catch (CLIException e) {
            this.printGenericExecutionError(cli, e);
        }
        catch (RuntimeException e) {
            if (e.getCause() instanceof CLIException) {
                this.printGenericExecutionError(cli, (CLIException)e.getCause());
                return;
            }
            throw e;
        }
    }

    protected void printCommandUsage(CLI cli) {
        StringBuilder builder = new StringBuilder();
        cli.usage(builder, this.getCommandLinePrefix());
        this.getPrintStream().println(builder.toString());
    }

    protected void printGenericExecutionError(CLI cli, CLIException e) {
        this.getPrintStream().println("Error while executing command " + cli.getName() + ": " + e.getMessage() + this.getNewLine());
        if (e.getCause() != null) {
            e.getCause().printStackTrace(this.getPrintStream());
        }
    }

    protected void printSpecificException(CLI cli, Exception e) {
        this.getPrintStream().println(e.getMessage() + this.getNewLine());
        this.printCommandUsage(cli);
    }

    protected void printCommandNotFound(String command) {
        StringBuilder builder = new StringBuilder();
        this.buildWrapped(builder, 0, "The command '" + command + "' is not a valid command." + this.getNewLine() + "See '" + this.getCommandLinePrefix() + " --help'");
        this.getPrintStream().println(builder.toString());
    }

    protected void printGlobalUsage() {
        StringBuilder builder = new StringBuilder();
        this.computeUsage(builder, this.getCommandLinePrefix() + " [COMMAND] [OPTIONS] [arg...]");
        builder.append(this.getNewLine());
        builder.append("Commands:").append(this.getNewLine());
        this.renderCommands(builder, this.commandByName.values().stream().map(r -> r.cli).collect(Collectors.toList()));
        builder.append(this.getNewLine()).append(this.getNewLine());
        this.buildWrapped(builder, 0, "Run '" + this.getCommandLinePrefix() + " COMMAND --help' for more information on a command.");
        this.getPrintStream().println(builder.toString());
    }

    protected String getCommandLinePrefix() {
        String sysProp = System.getProperty("vertx.cli.usage.prefix");
        if (sysProp != null) {
            return sysProp;
        }
        String jar = CommandLineUtils.getJar();
        if (jar != null) {
            return "java -jar " + jar;
        }
        String command = CommandLineUtils.getFirstSegmentOfCommand();
        if (command != null) {
            return "java " + command;
        }
        return "vertx";
    }

    protected static boolean isAskingForHelp(String command) {
        return command.equalsIgnoreCase("--help") || command.equalsIgnoreCase("-help") || command.equalsIgnoreCase("-h") || command.equalsIgnoreCase("?") || command.equalsIgnoreCase("/?");
    }

    protected static boolean isAskingForVersion(String command) {
        return command.equalsIgnoreCase("-version") || command.equalsIgnoreCase("--version");
    }

    public void dispatch(String[] args) {
        this.dispatch(null, args);
    }

    public void dispatch(Object main, String[] args) {
        this.main = main == null ? this : main;
        PROCESS_ARGS = Collections.unmodifiableList(Arrays.asList(args));
        if (args.length >= 1 && VertxCommandLauncher.isAskingForHelp(args[0])) {
            this.printGlobalUsage();
            return;
        }
        if (args.length >= 1 && VertxCommandLauncher.isAskingForVersion(args[0])) {
            this.execute("version", new String[0]);
            return;
        }
        if (args.length >= 1 && this.commandByName.get(args[0]) != null) {
            this.execute(args[0], Arrays.copyOfRange(args, 1, args.length));
            return;
        }
        if (args.length >= 2 && VertxCommandLauncher.isAskingForHelp(args[1])) {
            this.execute(args[0], "--help");
            return;
        }
        String verticle = this.getMainVerticle();
        String command = this.getCommandFromManifest();
        if (verticle != null) {
            String[] newArgs = new String[args.length + 1];
            newArgs[0] = verticle;
            System.arraycopy(args, 0, newArgs, 1, args.length);
            this.execute(this.getDefaultCommand(), newArgs);
            return;
        }
        if (command != null) {
            this.execute(command, args);
            return;
        }
        if (args.length == 0) {
            this.printGlobalUsage();
        } else if (args[0].equalsIgnoreCase("-ha")) {
            this.execute("bare", Arrays.copyOfRange(args, 1, args.length));
        } else {
            this.printCommandNotFound(args[0]);
        }
    }

    protected String getDefaultCommand() {
        String fromManifest = this.getCommandFromManifest();
        if (fromManifest == null) {
            return "run";
        }
        return fromManifest;
    }

    protected String getCommandFromManifest() {
        try {
            Enumeration<URL> resources = RunCommand.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String command;
                InputStream stream = resources.nextElement().openStream();
                Manifest manifest = new Manifest(stream);
                Attributes attributes = manifest.getMainAttributes();
                String mainClass = attributes.getValue("Main-Class");
                if (this.main.getClass().getName().equals(mainClass) && (command = attributes.getValue("Main-Command")) != null) {
                    stream.close();
                    return command;
                }
                stream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return null;
    }

    public PrintStream getPrintStream() {
        return System.out;
    }

    protected String getMainVerticle() {
        try {
            Enumeration<URL> resources = RunCommand.class.getClassLoader().getResources("META-INF/MANIFEST.MF");
            while (resources.hasMoreElements()) {
                String theMainVerticle;
                InputStream stream = resources.nextElement().openStream();
                Manifest manifest = new Manifest(stream);
                Attributes attributes = manifest.getMainAttributes();
                String mainClass = attributes.getValue("Main-Class");
                if (this.main != null && this.main.getClass().getName().equals(mainClass) && (theMainVerticle = attributes.getValue("Main-Verticle")) != null) {
                    stream.close();
                    return theMainVerticle;
                }
                stream.close();
            }
        }
        catch (IOException e) {
            throw new IllegalStateException(e.getMessage());
        }
        return null;
    }

    public static void resetProcessArguments() {
        PROCESS_ARGS = null;
    }

    public static class CommandRegistration {
        public final CommandFactory factory;
        public final CLI cli;
        private List<Command> commands = new ArrayList<Command>();

        public CommandRegistration(CommandFactory factory) {
            this(factory, factory.define());
        }

        public CommandRegistration(CommandFactory factory, CLI cli) {
            this.factory = factory;
            this.cli = cli;
        }

        public void addCommand(Command command) {
            this.commands.add(command);
        }

        public Command getCommand() {
            if (!this.commands.isEmpty()) {
                return this.commands.get(0);
            }
            return null;
        }

        public List<Command> getCommands() {
            return this.commands;
        }
    }
}

