/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.net.impl.transport;

import java.net.InetSocketAddress;
import java.util.concurrent.ThreadFactory;
import znaishaded.io.netty.bootstrap.ServerBootstrap;
import znaishaded.io.netty.channel.Channel;
import znaishaded.io.netty.channel.EventLoopGroup;
import znaishaded.io.netty.channel.ServerChannel;
import znaishaded.io.netty.channel.epoll.EpollChannelOption;
import znaishaded.io.netty.channel.kqueue.KQueue;
import znaishaded.io.netty.channel.kqueue.KQueueDatagramChannel;
import znaishaded.io.netty.channel.kqueue.KQueueDomainSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueEventLoopGroup;
import znaishaded.io.netty.channel.kqueue.KQueueServerDomainSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueServerSocketChannel;
import znaishaded.io.netty.channel.kqueue.KQueueSocketChannel;
import znaishaded.io.netty.channel.socket.DatagramChannel;
import znaishaded.io.netty.channel.socket.InternetProtocolFamily;
import znaishaded.io.netty.channel.unix.DomainSocketAddress;
import znaishaded.io.vertx.core.net.NetServerOptions;
import znaishaded.io.vertx.core.net.SocketAddress;
import znaishaded.io.vertx.core.net.impl.transport.Transport;

class KQueueTransport
extends Transport {
    KQueueTransport() {
    }

    @Override
    public java.net.SocketAddress convert(SocketAddress address, boolean resolved) {
        if (address.path() != null) {
            return new DomainSocketAddress(address.path());
        }
        if (resolved) {
            return new InetSocketAddress(address.host(), address.port());
        }
        return InetSocketAddress.createUnresolved(address.host(), address.port());
    }

    @Override
    public boolean isAvailable() {
        return KQueue.isAvailable();
    }

    @Override
    public Throwable unavailabilityCause() {
        return KQueue.unavailabilityCause();
    }

    @Override
    public EventLoopGroup eventLoopGroup(int nThreads, ThreadFactory threadFactory, int ioRatio) {
        KQueueEventLoopGroup eventLoopGroup = new KQueueEventLoopGroup(nThreads, threadFactory);
        eventLoopGroup.setIoRatio(ioRatio);
        return eventLoopGroup;
    }

    @Override
    public DatagramChannel datagramChannel() {
        return new KQueueDatagramChannel();
    }

    @Override
    public DatagramChannel datagramChannel(InternetProtocolFamily family) {
        return new KQueueDatagramChannel();
    }

    @Override
    public Class<? extends Channel> channelType(boolean domain) {
        if (domain) {
            return KQueueDomainSocketChannel.class;
        }
        return KQueueSocketChannel.class;
    }

    @Override
    public Class<? extends ServerChannel> serverChannelType(boolean domain) {
        if (domain) {
            return KQueueServerDomainSocketChannel.class;
        }
        return KQueueServerSocketChannel.class;
    }

    @Override
    public void configure(NetServerOptions options, ServerBootstrap bootstrap) {
        bootstrap.option(EpollChannelOption.SO_REUSEPORT, options.isReusePort());
        super.configure(options, bootstrap);
    }
}

