/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.core.shareddata.impl;

import java.util.Objects;
import java.util.concurrent.atomic.AtomicLong;
import znaishaded.io.vertx.core.AsyncResult;
import znaishaded.io.vertx.core.Future;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.impl.ContextImpl;
import znaishaded.io.vertx.core.impl.VertxInternal;
import znaishaded.io.vertx.core.shareddata.Counter;

public class AsynchronousCounter
implements Counter {
    private final VertxInternal vertx;
    private final AtomicLong counter;

    public AsynchronousCounter(VertxInternal vertx) {
        this.vertx = vertx;
        this.counter = new AtomicLong();
    }

    public AsynchronousCounter(VertxInternal vertx, AtomicLong counter) {
        this.vertx = vertx;
        this.counter = counter;
    }

    @Override
    public void get(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.get())));
    }

    @Override
    public void incrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.incrementAndGet())));
    }

    @Override
    public void getAndIncrement(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.getAndIncrement())));
    }

    @Override
    public void decrementAndGet(Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.decrementAndGet())));
    }

    @Override
    public void addAndGet(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.addAndGet(value))));
    }

    @Override
    public void getAndAdd(long value, Handler<AsyncResult<Long>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.getAndAdd(value))));
    }

    @Override
    public void compareAndSet(long expected, long value, Handler<AsyncResult<Boolean>> resultHandler) {
        Objects.requireNonNull(resultHandler, "resultHandler");
        ContextImpl context = this.vertx.getOrCreateContext();
        context.runOnContext(v -> resultHandler.handle(Future.succeededFuture(this.counter.compareAndSet(expected, value))));
    }
}

