/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web;

import java.util.List;
import java.util.Map;
import java.util.Set;
import znaishaded.io.vertx.codegen.annotations.CacheReturn;
import znaishaded.io.vertx.codegen.annotations.Fluent;
import znaishaded.io.vertx.codegen.annotations.GenIgnore;
import znaishaded.io.vertx.codegen.annotations.Nullable;
import znaishaded.io.vertx.codegen.annotations.VertxGen;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.http.HttpMethod;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.ext.auth.User;
import znaishaded.io.vertx.ext.web.Cookie;
import znaishaded.io.vertx.ext.web.FileUpload;
import znaishaded.io.vertx.ext.web.LanguageHeader;
import znaishaded.io.vertx.ext.web.Locale;
import znaishaded.io.vertx.ext.web.ParsedHeaderValues;
import znaishaded.io.vertx.ext.web.Route;
import znaishaded.io.vertx.ext.web.Session;

@VertxGen
public interface RoutingContext {
    @CacheReturn
    public HttpServerRequest request();

    @CacheReturn
    public HttpServerResponse response();

    public void next();

    public void fail(int var1);

    public void fail(Throwable var1);

    @Fluent
    public RoutingContext put(String var1, Object var2);

    public <T> T get(String var1);

    public <T> T remove(String var1);

    @GenIgnore
    public Map<String, Object> data();

    @CacheReturn
    public Vertx vertx();

    public @Nullable String mountPoint();

    public Route currentRoute();

    public String normalisedPath();

    public @Nullable Cookie getCookie(String var1);

    @Fluent
    public RoutingContext addCookie(Cookie var1);

    default public @Nullable Cookie removeCookie(String name) {
        return this.removeCookie(name, true);
    }

    public @Nullable Cookie removeCookie(String var1, boolean var2);

    public int cookieCount();

    public Set<Cookie> cookies();

    public @Nullable String getBodyAsString();

    public @Nullable String getBodyAsString(String var1);

    public @Nullable JsonObject getBodyAsJson();

    public @Nullable JsonArray getBodyAsJsonArray();

    public @Nullable Buffer getBody();

    public Set<FileUpload> fileUploads();

    public @Nullable Session session();

    public @Nullable User user();

    @CacheReturn
    public @Nullable Throwable failure();

    @CacheReturn
    public int statusCode();

    public @Nullable String getAcceptableContentType();

    @CacheReturn
    public ParsedHeaderValues parsedHeaders();

    public int addHeadersEndHandler(Handler<Void> var1);

    public boolean removeHeadersEndHandler(int var1);

    public int addBodyEndHandler(Handler<Void> var1);

    public boolean removeBodyEndHandler(int var1);

    public boolean failed();

    public void setBody(Buffer var1);

    public void setSession(Session var1);

    public void setUser(User var1);

    public void clearUser();

    public void setAcceptableContentType(@Nullable String var1);

    default public void reroute(String path2) {
        this.reroute(this.request().method(), path2);
    }

    public void reroute(HttpMethod var1, String var2);

    @Deprecated
    @CacheReturn
    public List<Locale> acceptableLocales();

    @CacheReturn
    default public List<LanguageHeader> acceptableLanguages() {
        return this.parsedHeaders().acceptLanguage();
    }

    @CacheReturn
    @Deprecated
    default public Locale preferredLocale() {
        return this.preferredLanguage();
    }

    @CacheReturn
    default public LanguageHeader preferredLanguage() {
        List<LanguageHeader> acceptableLanguages = this.acceptableLanguages();
        return acceptableLanguages.size() > 0 ? acceptableLanguages.get(0) : null;
    }

    public Map<String, String> pathParams();

    public @Nullable String pathParam(String var1);

    public MultiMap queryParams();

    public @Nullable List<String> queryParam(String var1);
}

