/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.impl;

import java.io.File;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import znaishaded.io.netty.handler.codec.http.HttpHeaderValues;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.buffer.Buffer;
import znaishaded.io.vertx.core.file.FileSystem;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerFileUpload;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.ext.web.FileUpload;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.BodyHandler;
import znaishaded.io.vertx.ext.web.impl.FileUploadImpl;

public class BodyHandlerImpl
implements BodyHandler {
    private static final Logger log = LoggerFactory.getLogger(BodyHandlerImpl.class);
    private static final String BODY_HANDLED = "__body-handled";
    private long bodyLimit = -1L;
    private String uploadsDir;
    private boolean mergeFormAttributes = true;
    private boolean deleteUploadedFilesOnEnd = false;

    public BodyHandlerImpl() {
        this.setUploadsDirectory("file-uploads");
    }

    public BodyHandlerImpl(String uploadDirectory) {
        this.setUploadsDirectory(uploadDirectory);
    }

    @Override
    public void handle(RoutingContext context) {
        HttpServerRequest request = context.request();
        if (request.headers().contains(HttpHeaders.UPGRADE, HttpHeaders.WEBSOCKET, true)) {
            context.next();
            return;
        }
        Boolean handled = (Boolean)context.get(BODY_HANDLED);
        if (handled == null || !handled.booleanValue()) {
            BHandler handler = new BHandler(context);
            request.handler((Handler)handler);
            request.endHandler(v -> handler.end());
            context.put(BODY_HANDLED, true);
        } else {
            if (this.mergeFormAttributes && request.isExpectMultipart()) {
                request.params().addAll(request.formAttributes());
            }
            context.next();
        }
    }

    @Override
    public BodyHandler setBodyLimit(long bodyLimit) {
        this.bodyLimit = bodyLimit;
        return this;
    }

    @Override
    public BodyHandler setUploadsDirectory(String uploadsDirectory) {
        this.uploadsDir = uploadsDirectory;
        return this;
    }

    @Override
    public BodyHandler setMergeFormAttributes(boolean mergeFormAttributes) {
        this.mergeFormAttributes = mergeFormAttributes;
        return this;
    }

    @Override
    public BodyHandler setDeleteUploadedFilesOnEnd(boolean deleteUploadedFilesOnEnd) {
        this.deleteUploadedFilesOnEnd = deleteUploadedFilesOnEnd;
        return this;
    }

    private class BHandler
    implements Handler<Buffer> {
        RoutingContext context;
        Buffer body = Buffer.buffer();
        boolean failed;
        AtomicInteger uploadCount = new AtomicInteger();
        AtomicBoolean cleanup = new AtomicBoolean(false);
        boolean ended;
        long uploadSize = 0L;
        final boolean isMultipart;
        final boolean isUrlEncoded;

        public BHandler(RoutingContext context) {
            this.context = context;
            Set<FileUpload> fileUploads = context.fileUploads();
            String contentType = context.request().getHeader(HttpHeaders.CONTENT_TYPE);
            if (contentType == null) {
                this.isMultipart = false;
                this.isUrlEncoded = false;
            } else {
                String lowerCaseContentType = contentType.toLowerCase();
                this.isMultipart = lowerCaseContentType.startsWith(HttpHeaderValues.MULTIPART_FORM_DATA.toString());
                this.isUrlEncoded = lowerCaseContentType.startsWith(HttpHeaderValues.APPLICATION_X_WWW_FORM_URLENCODED.toString());
            }
            if (this.isMultipart || this.isUrlEncoded) {
                this.makeUploadDir(context.vertx().fileSystem());
                context.request().setExpectMultipart(true);
                context.request().uploadHandler(upload -> {
                    long size;
                    if (BodyHandlerImpl.this.bodyLimit != -1L && upload.isSizeAvailable() && (size = this.uploadSize + upload.size()) > BodyHandlerImpl.this.bodyLimit) {
                        this.failed = true;
                        context.fail(413);
                        return;
                    }
                    this.uploadCount.incrementAndGet();
                    String uploadedFileName = new File(BodyHandlerImpl.this.uploadsDir, UUID.randomUUID().toString()).getPath();
                    upload.streamToFileSystem(uploadedFileName);
                    FileUploadImpl fileUpload = new FileUploadImpl(uploadedFileName, (HttpServerFileUpload)upload);
                    fileUploads.add(fileUpload);
                    upload.exceptionHandler(t -> {
                        this.deleteFileUploads();
                        context.fail((Throwable)t);
                    });
                    upload.endHandler(v -> this.uploadEnded());
                });
            }
            context.request().exceptionHandler(t -> {
                this.deleteFileUploads();
                context.fail((Throwable)t);
            });
        }

        private void makeUploadDir(FileSystem fileSystem) {
            if (!fileSystem.existsBlocking(BodyHandlerImpl.this.uploadsDir)) {
                fileSystem.mkdirsBlocking(BodyHandlerImpl.this.uploadsDir);
            }
        }

        @Override
        public void handle(Buffer buff) {
            if (this.failed) {
                return;
            }
            this.uploadSize += (long)buff.length();
            if (BodyHandlerImpl.this.bodyLimit != -1L && this.uploadSize > BodyHandlerImpl.this.bodyLimit) {
                this.failed = true;
                this.context.fail(413);
                this.context.vertx().runOnContext(v -> this.deleteFileUploads());
            } else if (!this.isMultipart) {
                this.body.appendBuffer(buff);
            }
        }

        void uploadEnded() {
            int count = this.uploadCount.decrementAndGet();
            if (this.ended && count == 0) {
                this.doEnd();
            }
        }

        void end() {
            this.ended = true;
            if (this.uploadCount.get() == 0) {
                this.doEnd();
            }
        }

        void doEnd() {
            if (this.failed) {
                this.deleteFileUploads();
                return;
            }
            if (BodyHandlerImpl.this.deleteUploadedFilesOnEnd) {
                this.context.addBodyEndHandler(x -> this.deleteFileUploads());
            }
            HttpServerRequest req = this.context.request();
            if (BodyHandlerImpl.this.mergeFormAttributes && req.isExpectMultipart()) {
                req.params().addAll(req.formAttributes());
            }
            this.context.setBody(this.body);
            this.context.next();
        }

        private void deleteFileUploads() {
            if (this.cleanup.compareAndSet(false, true)) {
                for (FileUpload fileUpload : this.context.fileUploads()) {
                    FileSystem fileSystem = this.context.vertx().fileSystem();
                    String uploadedFileName = fileUpload.uploadedFileName();
                    fileSystem.exists(uploadedFileName, existResult -> {
                        if (existResult.failed()) {
                            log.warn((Object)("Could not detect if uploaded file exists, not deleting: " + uploadedFileName), existResult.cause());
                        } else if (((Boolean)existResult.result()).booleanValue()) {
                            fileSystem.delete(uploadedFileName, deleteResult -> {
                                if (deleteResult.failed()) {
                                    log.warn((Object)("Delete of uploaded file failed: " + uploadedFileName), deleteResult.cause());
                                }
                            });
                        }
                    });
                }
            }
        }
    }
}

