/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.io.vertx.ext.web.handler.sockjs.impl;

import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Random;
import java.util.Set;
import znaishaded.io.netty.handler.codec.http.cookie.Cookie;
import znaishaded.io.netty.handler.codec.http.cookie.ServerCookieDecoder;
import znaishaded.io.netty.handler.codec.http.cookie.ServerCookieEncoder;
import znaishaded.io.vertx.core.Handler;
import znaishaded.io.vertx.core.MultiMap;
import znaishaded.io.vertx.core.Vertx;
import znaishaded.io.vertx.core.http.HttpHeaders;
import znaishaded.io.vertx.core.http.HttpServerRequest;
import znaishaded.io.vertx.core.http.HttpServerResponse;
import znaishaded.io.vertx.core.impl.StringEscapeUtils;
import znaishaded.io.vertx.core.json.JsonArray;
import znaishaded.io.vertx.core.json.JsonObject;
import znaishaded.io.vertx.core.logging.Logger;
import znaishaded.io.vertx.core.logging.LoggerFactory;
import znaishaded.io.vertx.core.shareddata.LocalMap;
import znaishaded.io.vertx.ext.web.RoutingContext;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSHandlerOptions;
import znaishaded.io.vertx.ext.web.handler.sockjs.SockJSSocket;
import znaishaded.io.vertx.ext.web.handler.sockjs.Transport;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.SockJSSession;
import znaishaded.io.vertx.ext.web.handler.sockjs.impl.TransportListener;

class BaseTransport {
    private static final Logger log = LoggerFactory.getLogger(BaseTransport.class);
    protected final Vertx vertx;
    protected final LocalMap<String, SockJSSession> sessions;
    protected SockJSHandlerOptions options;
    protected static final String COMMON_PATH_ELEMENT_RE = "\\/[^\\/\\.]+\\/([^\\/\\.]+)\\/";
    private static final long RAND_OFFSET = 0x80000000L;

    public BaseTransport(Vertx vertx, LocalMap<String, SockJSSession> sessions, SockJSHandlerOptions options) {
        this.vertx = vertx;
        this.sessions = sessions;
        this.options = options;
    }

    protected SockJSSession getSession(RoutingContext rc, long timeout, long heartbeatInterval, String sessionID, Handler<SockJSSocket> sockHandler) {
        SockJSSession session = this.sessions.computeIfAbsent(sessionID, s2 -> new SockJSSession(this.vertx, this.sessions, rc, (String)s2, timeout, heartbeatInterval, sockHandler));
        return session;
    }

    protected void sendInvalidJSON(HttpServerResponse response) {
        if (log.isTraceEnabled()) {
            log.trace("Broken JSON");
        }
        response.setStatusCode(500);
        response.end("Broken JSON encoding.");
    }

    protected String escapeForJavaScript(String str) {
        try {
            str = StringEscapeUtils.escapeJavaScript(str);
        }
        catch (Exception e) {
            log.error((Object)"Failed to escape", e);
            str = null;
        }
        return str;
    }

    static void setJSESSIONID(SockJSHandlerOptions options, RoutingContext rc) {
        String cookies = rc.request().getHeader("cookie");
        if (options.isInsertJSESSIONID()) {
            if (cookies != null) {
                String[] parts = cookies.contains(";") ? cookies.split(";") : new String[]{cookies};
                for (String part : parts) {
                    if (!part.startsWith("JSESSIONID")) continue;
                    cookies = part + "; path=/";
                    break;
                }
            }
            if (cookies == null) {
                cookies = "JSESSIONID=dummy; path=/";
            }
            rc.response().putHeader("Set-Cookie", cookies);
        }
    }

    static void setCORS(RoutingContext rc) {
        HttpServerRequest req = rc.request();
        String origin = req.headers().get("origin");
        if (origin == null || "null".equals(origin)) {
            origin = "*";
        }
        req.response().headers().set("Access-Control-Allow-Origin", origin);
        req.response().headers().set("Access-Control-Allow-Credentials", "true");
        String hdr = req.headers().get("Access-Control-Request-Headers");
        if (hdr != null) {
            req.response().headers().set("Access-Control-Allow-Headers", hdr);
        }
    }

    static Handler<RoutingContext> createInfoHandler(final SockJSHandlerOptions options) {
        return new Handler<RoutingContext>(){
            boolean websocket;
            {
                this.websocket = !options.getDisabledTransports().contains(Transport.WEBSOCKET.toString());
            }

            @Override
            public void handle(RoutingContext rc) {
                if (log.isTraceEnabled()) {
                    log.trace("In Info handler");
                }
                rc.response().putHeader("Content-Type", "application/json; charset=UTF-8");
                BaseTransport.setNoCacheHeaders(rc);
                JsonObject json = new JsonObject();
                json.put("websocket", this.websocket);
                json.put("cookie_needed", options.isInsertJSESSIONID());
                json.put("origins", new JsonArray().add("*:*"));
                json.put("entropy", 0x80000000L + (long)new Random().nextInt());
                BaseTransport.setCORS(rc);
                rc.response().end(json.encode());
            }
        };
    }

    static void setNoCacheHeaders(RoutingContext rc) {
        rc.response().putHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
    }

    static Handler<RoutingContext> createCORSOptionsHandler(SockJSHandlerOptions options, String methods) {
        return rc -> {
            if (log.isTraceEnabled()) {
                log.trace("In CORS options handler");
            }
            rc.response().putHeader("Cache-Control", "public,max-age=31536000");
            long oneYearSeconds = 31536000L;
            long oneYearms = oneYearSeconds * 1000L;
            String expires = new SimpleDateFormat("EEE, dd MMM yyyy HH:mm:ss zzz").format(new Date(System.currentTimeMillis() + oneYearms));
            rc.response().putHeader("Expires", expires).putHeader("Access-Control-Allow-Methods", methods).putHeader("Access-Control-Max-Age", String.valueOf(oneYearSeconds));
            BaseTransport.setCORS(rc);
            BaseTransport.setJSESSIONID(options, rc);
            rc.response().setStatusCode(204);
            rc.response().end();
        };
    }

    static MultiMap removeCookieHeaders(MultiMap headers) {
        String cookieHeader = headers.get(HttpHeaders.COOKIE);
        if (cookieHeader != null) {
            headers.remove(HttpHeaders.COOKIE);
            Set<Cookie> nettyCookies = ServerCookieDecoder.STRICT.decode(cookieHeader);
            for (Cookie cookie : nettyCookies) {
                if (!cookie.name().equals("JSESSIONID")) continue;
                headers.add(HttpHeaders.COOKIE, (CharSequence)ServerCookieEncoder.STRICT.encode(cookie));
                break;
            }
        }
        return headers;
    }

    protected static abstract class BaseListener
    implements TransportListener {
        protected final RoutingContext rc;
        protected final SockJSSession session;
        protected boolean closed;

        protected BaseListener(RoutingContext rc, SockJSSession session) {
            this.rc = rc;
            this.session = session;
        }

        protected void addCloseHandler(HttpServerResponse resp, SockJSSession session) {
            resp.closeHandler(v -> {
                if (log.isTraceEnabled()) {
                    log.trace("Connection closed (from client?), closing session");
                }
                session.shutdown();
                this.closed = true;
            });
        }

        @Override
        public void sessionClosed() {
            this.session.writeClosed(this);
            this.close();
        }
    }
}

