/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml;

import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import znaishaded.net.sourceforge.plantuml.BlockUml;
import znaishaded.net.sourceforge.plantuml.BlockUmlBuilder;
import znaishaded.net.sourceforge.plantuml.FileFormat;
import znaishaded.net.sourceforge.plantuml.FileFormatOption;
import znaishaded.net.sourceforge.plantuml.FileImageData;
import znaishaded.net.sourceforge.plantuml.FileSystem;
import znaishaded.net.sourceforge.plantuml.GeneratedImage;
import znaishaded.net.sourceforge.plantuml.GeneratedImageImpl;
import znaishaded.net.sourceforge.plantuml.ISourceFileReader;
import znaishaded.net.sourceforge.plantuml.Log;
import znaishaded.net.sourceforge.plantuml.OptionFlags;
import znaishaded.net.sourceforge.plantuml.PSystemError;
import znaishaded.net.sourceforge.plantuml.PSystemUtils;
import znaishaded.net.sourceforge.plantuml.SuggestedFile;
import znaishaded.net.sourceforge.plantuml.UmlDiagram;
import znaishaded.net.sourceforge.plantuml.core.Diagram;
import znaishaded.net.sourceforge.plantuml.preproc.Defines;
import znaishaded.net.sourceforge.plantuml.preproc.FileWithSuffix;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SourceFileReader
implements ISourceFileReader {
    private final File file;
    private final File outputDirectory;
    private final BlockUmlBuilder builder;
    private FileFormatOption fileFormatOption;

    public SourceFileReader(File file) throws IOException {
        this(file, file.getAbsoluteFile().getParentFile());
    }

    public SourceFileReader(File file, File file2, String string) throws IOException {
        this(Defines.createWithFileName(file), file, file2, Collections.emptyList(), string, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File file2) throws IOException {
        this(Defines.createWithFileName(file), file, file2, Collections.emptyList(), null, new FileFormatOption(FileFormat.PNG));
    }

    public SourceFileReader(File file, File file2, FileFormatOption fileFormatOption) throws IOException {
        this(Defines.createWithFileName(file), file, file2, Collections.emptyList(), null, fileFormatOption);
    }

    public SourceFileReader(Defines defines, File file, File file2, List<String> list, String string, FileFormatOption fileFormatOption) throws IOException {
        this.file = file;
        this.fileFormatOption = fileFormatOption;
        if (!file.exists()) {
            throw new IllegalArgumentException();
        }
        FileSystem.getInstance().setCurrentDir(file.getAbsoluteFile().getParentFile());
        if (file2 == null) {
            file2 = file.getAbsoluteFile().getParentFile();
        } else if (!file2.isAbsolute()) {
            file2 = FileSystem.getInstance().getFile(file2.getPath());
        }
        if (!file2.exists()) {
            file2.mkdirs();
        }
        this.outputDirectory = file2;
        this.builder = new BlockUmlBuilder(list, string, defines, this.getReader(string), file.getAbsoluteFile().getParentFile(), file.getAbsolutePath());
    }

    @Override
    public boolean hasError() {
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            if (!(blockUml.getDiagram() instanceof PSystemError)) continue;
            return true;
        }
        return false;
    }

    private File getDirIfDirectory(String string) {
        Log.info("Checking=" + string);
        if (this.endsWithSlashOrAntislash(string)) {
            Log.info("It ends with / so it looks like a directory");
            string = string.substring(0, string.length() - 1);
            File file = new File(string);
            Log.info("f=" + file);
            if (!file.isAbsolute()) {
                Log.info("It's relative, so let's change it");
                file = new File(this.outputDirectory, string);
                Log.info("f=" + file);
            }
            if (!file.exists()) {
                Log.info("It does not exist: let's create it");
                try {
                    file.mkdirs();
                }
                catch (Exception exception) {
                    Log.info("Error " + exception);
                }
                if (file.exists() && file.isDirectory()) {
                    Log.info("Creation ok");
                    return file;
                }
                Log.info("We cannot create it");
            } else if (!file.isDirectory()) {
                Log.info("It exists, but is not a directory: we ignore it");
                return null;
            }
            return file;
        }
        File file = new File(string);
        Log.info("f=" + file);
        if (!file.isAbsolute()) {
            Log.info("Relative, so let's change it");
            file = new File(this.outputDirectory, string);
            Log.info("f=" + file);
        }
        if (file.exists() && file.isDirectory()) {
            Log.info("It's an existing directory");
            return file;
        }
        Log.info("It's not a directory");
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public List<GeneratedImage> getGeneratedImages() throws IOException {
        Log.info("Reading file: " + this.file);
        int n = 0;
        ArrayList<Object> arrayList = new ArrayList<Object>();
        for (BlockUml blockUml : this.builder.getBlockUmls()) {
            Object object;
            String string = blockUml.getFileOrDirname();
            SuggestedFile suggestedFile = null;
            if (string != null) {
                Log.info("name from block=" + string);
                object = this.getDirIfDirectory(string);
                if (object == null) {
                    Log.info(string + " is not taken as a directory");
                    suggestedFile = SuggestedFile.fromOutputFile(new File(this.outputDirectory, string), this.fileFormatOption.getFileFormat(), 0);
                } else {
                    Log.info("We are going to create files in directory " + object);
                    suggestedFile = SuggestedFile.fromOutputFile(new File((File)object, this.file.getName()), this.fileFormatOption.getFileFormat(), 0);
                }
                Log.info("We are going to put data in " + suggestedFile);
            }
            if (suggestedFile == null) {
                suggestedFile = SuggestedFile.fromOutputFile(new File(this.outputDirectory, this.file.getName()), this.fileFormatOption.getFileFormat(), n++);
            }
            suggestedFile.getParentFile().mkdirs();
            try {
                object = blockUml.getDiagram();
            }
            catch (Throwable throwable) {
                BufferedOutputStream bufferedOutputStream;
                GeneratedImageImpl generatedImageImpl = new GeneratedImageImpl(suggestedFile.getFile(0), "Crash Error", blockUml);
                OutputStream outputStream = null;
                try {
                    bufferedOutputStream = new BufferedOutputStream(new FileOutputStream(suggestedFile.getFile(0)));
                    UmlDiagram.exportDiagramError(bufferedOutputStream, throwable, this.fileFormatOption, 42L, null, blockUml.getFlashData(), UmlDiagram.getFailureText2(throwable, blockUml.getFlashData()));
                    if (bufferedOutputStream == null) return Collections.singletonList(generatedImageImpl);
                }
                catch (Throwable throwable2) {
                    if (outputStream == null) throw throwable2;
                    outputStream.close();
                    throw throwable2;
                }
                ((OutputStream)bufferedOutputStream).close();
                return Collections.singletonList(generatedImageImpl);
            }
            List<FileImageData> list = PSystemUtils.exportDiagrams((Diagram)object, suggestedFile, this.fileFormatOption);
            if (list.size() > 1) {
                n += list.size() - 1;
            }
            OptionFlags.getInstance().logData(this.file, (Diagram)object);
            for (FileImageData object2 : list) {
                Object object3;
                String string2 = "[" + this.file.getName() + "] " + object.getDescription();
                File file = object2.getFile();
                if (OptionFlags.getInstance().isWord() && (object3 = object.getWarningOrError()) != null) {
                    String string3 = file.getName().substring(0, file.getName().length() - 4) + ".err";
                    File file2 = new File(file.getParentFile(), string3);
                    PrintStream printStream = new PrintStream(new FileOutputStream(file2));
                    printStream.print((String)object3);
                    printStream.close();
                }
                object3 = new GeneratedImageImpl(file, string2, blockUml);
                arrayList.add(object3);
            }
        }
        Log.info("Number of image(s): " + arrayList.size());
        return Collections.unmodifiableList(arrayList);
    }

    private boolean endsWithSlashOrAntislash(String string) {
        return string.endsWith("/") || string.endsWith("\\");
    }

    @Override
    public List<BlockUml> getBlocks() {
        return this.builder.getBlockUmls();
    }

    private Reader getReader(String string) throws FileNotFoundException, UnsupportedEncodingException {
        if (string == null) {
            Log.info("Using default charset");
            return new InputStreamReader(new FileInputStream(this.file));
        }
        Log.info("Using charset " + string);
        return new InputStreamReader((InputStream)new FileInputStream(this.file), string);
    }

    @Override
    public final void setFileFormatOption(FileFormatOption fileFormatOption) {
        this.fileFormatOption = fileFormatOption;
    }

    public final Set<FileWithSuffix> getIncludedFiles() {
        return this.builder.getIncludedFiles();
    }
}

