/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond;

import java.awt.geom.Dimension2D;
import znaishaded.net.sourceforge.plantuml.ISkinParam;
import znaishaded.net.sourceforge.plantuml.ISkinSimple;
import znaishaded.net.sourceforge.plantuml.LineBreakStrategy;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.Branch;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.AbstractFtile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Diamond;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileEmpty;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileMinWidth;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.FtileUtils;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileIfDown;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfNude;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithDiamonds;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.cond.FtileIfWithLinks;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamond;
import znaishaded.net.sourceforge.plantuml.activitydiagram3.ftile.vertical.FtileDiamondInside;
import znaishaded.net.sourceforge.plantuml.creole.CreoleMode;
import znaishaded.net.sourceforge.plantuml.creole.CreoleParser;
import znaishaded.net.sourceforge.plantuml.creole.Sheet;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock1;
import znaishaded.net.sourceforge.plantuml.creole.SheetBlock2;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.graphic.FontConfiguration;
import znaishaded.net.sourceforge.plantuml.graphic.HorizontalAlignment;
import znaishaded.net.sourceforge.plantuml.graphic.HtmlColor;
import znaishaded.net.sourceforge.plantuml.graphic.Rainbow;
import znaishaded.net.sourceforge.plantuml.graphic.StringBounder;
import znaishaded.net.sourceforge.plantuml.graphic.TextBlock;
import znaishaded.net.sourceforge.plantuml.svek.ConditionStyle;

public class ConditionalBuilder {
    private final Swimlane swimlane;
    private final HtmlColor borderColor;
    private final HtmlColor backColor;
    private final Rainbow arrowColor;
    private final FtileFactory ftileFactory;
    private final ConditionStyle conditionStyle;
    private final Branch branch1;
    private final Branch branch2;
    private final ISkinParam skinParam;
    private final StringBounder stringBounder;
    private final FontConfiguration fontArrow;
    private final FontConfiguration fontTest;
    private final Ftile tile1;
    private final Ftile tile2;

    public ConditionalBuilder(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, Branch branch2, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2) {
        this.swimlane = swimlane;
        this.borderColor = htmlColor;
        this.backColor = htmlColor2;
        this.arrowColor = rainbow;
        this.ftileFactory = ftileFactory;
        this.conditionStyle = conditionStyle;
        this.branch1 = branch;
        this.branch2 = branch2;
        this.skinParam = iSkinParam;
        this.stringBounder = stringBounder;
        this.fontArrow = fontConfiguration;
        this.fontTest = fontConfiguration2;
        this.tile1 = new FtileMinWidth(branch.getFtile(), 30.0);
        this.tile2 = new FtileMinWidth(branch2.getFtile(), 30.0);
    }

    public static Ftile create(Swimlane swimlane, HtmlColor htmlColor, HtmlColor htmlColor2, Rainbow rainbow, FtileFactory ftileFactory, ConditionStyle conditionStyle, Branch branch, Branch branch2, ISkinParam iSkinParam, StringBounder stringBounder, FontConfiguration fontConfiguration, FontConfiguration fontConfiguration2) {
        ConditionalBuilder conditionalBuilder = new ConditionalBuilder(swimlane, htmlColor, htmlColor2, rainbow, ftileFactory, conditionStyle, branch, branch2, iSkinParam, stringBounder, fontConfiguration, fontConfiguration2);
        if (ConditionalBuilder.isEmptyOrOnlySingleStop(branch2) && !ConditionalBuilder.isEmptyOrOnlySingleStop(branch)) {
            return conditionalBuilder.createDown(conditionalBuilder.branch1, conditionalBuilder.branch2);
        }
        if (branch.isEmpty() && branch2.isOnlySingleStop()) {
            return conditionalBuilder.createDown(conditionalBuilder.branch1, conditionalBuilder.branch2);
        }
        if (ConditionalBuilder.isEmptyOrOnlySingleStop(branch) && !ConditionalBuilder.isEmptyOrOnlySingleStop(branch2)) {
            return conditionalBuilder.createDown(conditionalBuilder.branch2, conditionalBuilder.branch1);
        }
        if (branch2.isEmpty() && branch.isOnlySingleStop()) {
            return conditionalBuilder.createDown(conditionalBuilder.branch2, conditionalBuilder.branch1);
        }
        return conditionalBuilder.createWithLinks();
    }

    private static boolean isEmptyOrOnlySingleStop(Branch branch) {
        return branch.isEmpty() || branch.isOnlySingleStop();
    }

    private Ftile createDown(Branch branch, Branch branch2) {
        FtileMinWidth ftileMinWidth = new FtileMinWidth(branch.getFtile(), 30.0);
        FtileMinWidth ftileMinWidth2 = new FtileMinWidth(branch2.getFtile(), 30.0);
        TextBlock textBlock = this.getLabelPositive(branch);
        TextBlock textBlock2 = this.getLabelPositive(branch2);
        Ftile ftile = this.getDiamond1(false, textBlock, textBlock2);
        Ftile ftile2 = this.getDiamond2(branch, branch2, true);
        if (branch2.isOnlySingleStop()) {
            return FtileIfDown.create(ftile, ftile2, this.swimlane, FtileUtils.addHorizontalMargin(ftileMinWidth, 10.0), this.arrowColor, this.ftileFactory, branch2.getFtile(), branch2.getInlinkRenderingColorAndStyle());
        }
        if (branch.isOnlySingleStop()) {
            return FtileIfDown.create(ftile, ftile2, this.swimlane, FtileUtils.addHorizontalMargin(ftileMinWidth2, 10.0), this.arrowColor, this.ftileFactory, branch.getFtile(), branch.getInlinkRenderingColorAndStyle());
        }
        if (branch.isEmpty()) {
            return FtileIfDown.create(ftile, ftile2, this.swimlane, FtileUtils.addHorizontalMargin(ftileMinWidth2, 10.0), this.arrowColor, this.ftileFactory, null, null);
        }
        return FtileIfDown.create(ftile, ftile2, this.swimlane, FtileUtils.addHorizontalMargin(ftileMinWidth, 10.0), this.arrowColor, this.ftileFactory, null, branch2.getInlinkRenderingColorAndStyle());
    }

    private Ftile createNude() {
        return new FtileIfNude(this.tile1, this.tile2, this.swimlane);
    }

    private Ftile createWithDiamonds() {
        Ftile ftile = this.getDiamond1(true);
        Ftile ftile2 = this.getDiamond2(this.branch1, this.branch2, false);
        FtileIfWithDiamonds ftileIfWithDiamonds = new FtileIfWithDiamonds(ftile, this.tile1, this.tile2, ftile2, this.swimlane, this.stringBounder);
        Dimension2D dimension2D = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D dimension2D2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double d = ftileIfWithDiamonds.computeMarginNeedForBranchLabe1(this.stringBounder, dimension2D);
        double d2 = ftileIfWithDiamonds.computeMarginNeedForBranchLabe2(this.stringBounder, dimension2D2);
        Ftile ftile3 = FtileUtils.addHorizontalMargin(ftileIfWithDiamonds, d, d2);
        double d3 = ftileIfWithDiamonds.computeVerticalMarginNeedForBranchs(this.stringBounder, dimension2D, dimension2D2);
        ftile3 = FtileUtils.addVerticalMargin(ftile3, d3, 0.0);
        return ftile3;
    }

    private Ftile createWithLinks() {
        Ftile ftile = this.getDiamond1(true);
        Ftile ftile2 = this.getDiamond2(this.branch1, this.branch2, false);
        Ftile ftile3 = FtileUtils.addHorizontalMargin(this.tile1, 10.0);
        Ftile ftile4 = FtileUtils.addHorizontalMargin(this.tile2, 10.0);
        FtileIfWithLinks ftileIfWithLinks = new FtileIfWithLinks(ftile, ftile3, ftile4, ftile2, this.swimlane, this.arrowColor, this.stringBounder);
        Dimension2D dimension2D = this.getLabelPositive(this.branch1).calculateDimension(this.stringBounder);
        Dimension2D dimension2D2 = this.getLabelPositive(this.branch2).calculateDimension(this.stringBounder);
        double d = ftileIfWithLinks.computeMarginNeedForBranchLabe1(this.stringBounder, dimension2D);
        double d2 = ftileIfWithLinks.computeMarginNeedForBranchLabe2(this.stringBounder, dimension2D2);
        double d3 = ftileIfWithLinks.computeVerticalMarginNeedForBranchs(this.stringBounder, dimension2D, dimension2D2);
        Ftile ftile5 = ftileIfWithLinks.addLinks(this.branch1, this.branch2, this.stringBounder);
        ftile5 = FtileUtils.addHorizontalMargin(ftile5, d, d2);
        ftile5 = FtileUtils.addVerticalMargin(ftile5, d3, 0.0);
        return ftile5;
    }

    private Ftile getDiamond1(boolean bl) {
        return this.getDiamond1(bl, this.getLabelPositive(this.branch1), this.getLabelPositive(this.branch2));
    }

    private Ftile getDiamond1(boolean bl, TextBlock textBlock, TextBlock textBlock2) {
        Ftile ftile;
        Display display = this.branch1.getLabelTest();
        Sheet sheet = new CreoleParser(this.fontTest, this.skinParam.getDefaultTextAlignment(HorizontalAlignment.LEFT), this.skinParam, CreoleMode.FULL).createSheet(display);
        SheetBlock1 sheetBlock1 = new SheetBlock1(sheet, LineBreakStrategy.NONE, this.skinParam.getPadding());
        SheetBlock2 sheetBlock2 = new SheetBlock2(sheetBlock1, Diamond.asStencil(sheetBlock1), this.tile1.getThickness());
        if (this.conditionStyle == ConditionStyle.INSIDE) {
            ftile = bl ? new FtileDiamondInside(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane, sheetBlock2).withWestAndEast(textBlock, textBlock2) : new FtileDiamondInside(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane, sheetBlock2).withSouth(textBlock).withEast(textBlock2);
        } else if (this.conditionStyle == ConditionStyle.DIAMOND) {
            ftile = bl ? new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(sheetBlock2).withWestAndEast(textBlock, textBlock2) : new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane).withNorth(sheetBlock2).withSouth(textBlock).withEast(textBlock2);
        } else {
            throw new IllegalStateException();
        }
        return ftile;
    }

    private TextBlock getLabelPositive(Branch branch) {
        return branch.getLabelPositive().create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
    }

    private Ftile getDiamond2(Branch branch, Branch branch2, boolean bl) {
        AbstractFtile abstractFtile;
        if (this.hasTwoBranches()) {
            Display display = branch.getFtile().getOutLinkRendering().getDisplay();
            TextBlock textBlock = display == null ? null : display.create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            Display display2 = branch2.getFtile().getOutLinkRendering().getDisplay();
            TextBlock textBlock2 = display2 == null ? null : display2.create(this.fontArrow, HorizontalAlignment.LEFT, (ISkinSimple)this.ftileFactory.skinParam(), CreoleMode.SIMPLE_LINE);
            FtileDiamond ftileDiamond = new FtileDiamond(this.tile1.skinParam(), this.backColor, this.borderColor, this.swimlane);
            ftileDiamond = bl ? ftileDiamond.withNorth(textBlock) : ftileDiamond.withWest(textBlock);
            ftileDiamond = ftileDiamond.withEast(textBlock2);
            abstractFtile = ftileDiamond;
        } else {
            abstractFtile = new FtileEmpty(this.tile1.skinParam(), 0.0, 6.0, this.swimlane, this.swimlane);
        }
        return abstractFtile;
    }

    public boolean hasTwoBranches() {
        return this.tile1.calculateDimension(this.stringBounder).hasPointOut() && this.tile2.calculateDimension(this.stringBounder).hasPointOut();
    }
}

