/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.activitydiagram.ActivityDiagram;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Display;
import znaishaded.net.sourceforge.plantuml.cucadiagram.IEntity;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LeafType;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkDecor;
import znaishaded.net.sourceforge.plantuml.cucadiagram.LinkType;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.utils.UniqueSequence;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteActivityCommand
implements SingleMultiFactoryCommand<ActivityDiagram> {
    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)[%s]*"), ColorParser.exp1(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    @Override
    public Command<ActivityDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<ActivityDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public final CommandExecutionResult executeNow(ActivityDiagram activityDiagram, BlocLines blocLines) {
                Object object;
                RegexResult regexResult = this.getStartingPattern().matcher(StringUtils.trin(blocLines.getFirst499()));
                blocLines = blocLines.subExtract(1, 1);
                blocLines = blocLines.removeEmptyColumns();
                Display display = blocLines.toDisplay();
                Url url = null;
                if (display.size() > 0) {
                    object = new UrlBuilder(activityDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
                    url = ((UrlBuilder)object).getUrl(display.get(0).toString());
                }
                if (url != null) {
                    display = display.subList(1, display.size());
                }
                object = activityDiagram.createLeaf(UniqueSequence.getCode("GMN"), display, LeafType.NOTE, null);
                if (url != null) {
                    object.addUrl(url);
                }
                return FactoryNoteActivityCommand.this.executeInternal(activityDiagram, regexResult, (IEntity)object);
            }
        };
    }

    @Override
    public Command<ActivityDiagram> createSingleLine() {
        return new SingleLineCommand2<ActivityDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(ActivityDiagram activityDiagram, RegexResult regexResult) {
                IEntity iEntity = activityDiagram.createNote(UniqueSequence.getCode("GN"), Display.getWithNewlines(regexResult.get("NOTE", 0)));
                return FactoryNoteActivityCommand.this.executeInternal(activityDiagram, regexResult, iEntity);
            }
        };
    }

    private CommandExecutionResult executeInternal(ActivityDiagram activityDiagram, RegexResult regexResult, IEntity iEntity) {
        Link link;
        iEntity.setSpecificColorTOBEREMOVED(ColorType.BACK, activityDiagram.getSkinParam().getIHtmlColorSet().getColorIfValid(regexResult.get("COLOR", 0)));
        IEntity iEntity2 = activityDiagram.getLastEntityConsulted();
        if (iEntity2 == null) {
            iEntity2 = activityDiagram.getStart();
        }
        Position position = Position.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0))).withRankdir(activityDiagram.getSkinParam().getRankdir());
        LinkType linkType = new LinkType(LinkDecor.NONE, LinkDecor.NONE).getDashed();
        if (position == Position.RIGHT) {
            link = new Link(iEntity2, iEntity, linkType, Display.NULL, 1);
        } else if (position == Position.LEFT) {
            link = new Link(iEntity, iEntity2, linkType, Display.NULL, 1);
        } else if (position == Position.BOTTOM) {
            link = new Link(iEntity2, iEntity, linkType, Display.NULL, 2);
        } else if (position == Position.TOP) {
            link = new Link(iEntity, iEntity2, linkType, Display.NULL, 2);
        } else {
            throw new IllegalArgumentException();
        }
        activityDiagram.addLink(link);
        return CommandExecutionResult.ok();
    }
}

