/*
 * Decompiled with CFR 0.152.
 */
package znaishaded.net.sourceforge.plantuml.command.note;

import znaishaded.net.sourceforge.plantuml.StringUtils;
import znaishaded.net.sourceforge.plantuml.Url;
import znaishaded.net.sourceforge.plantuml.UrlBuilder;
import znaishaded.net.sourceforge.plantuml.command.BlocLines;
import znaishaded.net.sourceforge.plantuml.command.Command;
import znaishaded.net.sourceforge.plantuml.command.CommandExecutionResult;
import znaishaded.net.sourceforge.plantuml.command.CommandMultilines2;
import znaishaded.net.sourceforge.plantuml.command.MultilinesStrategy;
import znaishaded.net.sourceforge.plantuml.command.Position;
import znaishaded.net.sourceforge.plantuml.command.SingleLineCommand2;
import znaishaded.net.sourceforge.plantuml.command.note.SingleMultiFactoryCommand;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexConcat;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexLeaf;
import znaishaded.net.sourceforge.plantuml.command.regex.RegexResult;
import znaishaded.net.sourceforge.plantuml.cucadiagram.CucaDiagram;
import znaishaded.net.sourceforge.plantuml.cucadiagram.Link;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorParser;
import znaishaded.net.sourceforge.plantuml.graphic.color.ColorType;
import znaishaded.net.sourceforge.plantuml.graphic.color.Colors;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class FactoryNoteOnLinkCommand
implements SingleMultiFactoryCommand<CucaDiagram> {
    private RegexConcat getRegexConcatSingleLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), FactoryNoteOnLinkCommand.color().getRegex(), new RegexLeaf("[%s]*:[%s]*"), new RegexLeaf("NOTE", "(.*)"), new RegexLeaf("$"));
    }

    private RegexConcat getRegexConcatMultiLine() {
        return new RegexConcat(new RegexLeaf("^[%s]*note[%s]+"), new RegexLeaf("POSITION", "(right|left|top|bottom)?[%s]*on[%s]+link"), new RegexLeaf("[%s]*"), FactoryNoteOnLinkCommand.color().getRegex(), new RegexLeaf("$"));
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    @Override
    public Command<CucaDiagram> createMultiLine(boolean bl) {
        return new CommandMultilines2<CucaDiagram>(this.getRegexConcatMultiLine(), MultilinesStrategy.KEEP_STARTING_QUOTE){

            @Override
            public String getPatternEnd() {
                return "(?i)^[%s]*end[%s]?note$";
            }

            @Override
            public CommandExecutionResult executeNow(CucaDiagram cucaDiagram, BlocLines blocLines) {
                String string = blocLines.getFirst499().toString();
                blocLines = blocLines.subExtract(1, 1);
                if ((blocLines = blocLines.removeEmptyColumns()).size() > 0) {
                    RegexResult regexResult = this.getStartingPattern().matcher(string);
                    return FactoryNoteOnLinkCommand.this.executeInternal(cucaDiagram, blocLines, regexResult);
                }
                return CommandExecutionResult.error("No note defined");
            }
        };
    }

    @Override
    public Command<CucaDiagram> createSingleLine() {
        return new SingleLineCommand2<CucaDiagram>(this.getRegexConcatSingleLine()){

            @Override
            protected CommandExecutionResult executeArg(CucaDiagram cucaDiagram, RegexResult regexResult) {
                BlocLines blocLines = BlocLines.getWithNewlines(regexResult.get("NOTE", 0));
                return FactoryNoteOnLinkCommand.this.executeInternal(cucaDiagram, blocLines, regexResult);
            }
        };
    }

    private CommandExecutionResult executeInternal(CucaDiagram cucaDiagram, BlocLines blocLines, RegexResult regexResult) {
        Object object;
        Link link = cucaDiagram.getLastLink();
        if (link == null) {
            return CommandExecutionResult.error("No link defined");
        }
        Position position = Position.BOTTOM;
        if (regexResult.get("POSITION", 0) != null) {
            position = Position.valueOf(StringUtils.goUpperCase(regexResult.get("POSITION", 0)));
        }
        Url url = null;
        if (regexResult.get("URL", 0) != null) {
            object = new UrlBuilder(cucaDiagram.getSkinParam().getValue("topurl"), UrlBuilder.ModeUrl.STRICT);
            url = ((UrlBuilder)object).getUrl(regexResult.get("URL", 0));
        }
        object = FactoryNoteOnLinkCommand.color().getColor(regexResult, cucaDiagram.getSkinParam().getIHtmlColorSet());
        link.addNote(blocLines.toDisplay(), position, (Colors)object);
        return CommandExecutionResult.ok();
    }
}

